/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class Bassins
extends JFrame {
    private final Bassins ich;
    protected double XMin;
    protected double XMax;
    protected double YMin;
    protected double YMax;
    protected double ReibKoeff;
    protected double GravConst;
    protected double MagAbst;
    protected int MagAnz;
    protected double[] MagX = new double[3];
    protected double[] MagY = new double[3];
    protected double[] MagPar = new double[3];
    protected Color[] MagnetFarben = new Color[4];
    protected double Genauigkeit;
    protected double AnfangsSchrittweite;
    protected double MagEntf;
    protected double XVersch;
    protected double YVersch;
    protected double XFaktor;
    protected double YFaktor;
    protected boolean zeichneMagnete = true;
    protected boolean isSaved = false;
    protected String fensterTitel;
    protected Magnetpendel Main;
    protected Vector berechnungsThreads = new Vector();
    protected Vector threadListe = new Vector();
    protected calcPaneClass calcPane;
    private final JMenuBar mainMenuBar = new JMenuBar();
    private JMenu ablageMenu;
    private JMenu ebeneMenu;
    private JMenu bassinMenu;
    private Action openAction;
    private Action closeAction;
    private Action saveAction;
    private Action saveAsAction;
    private Action exportAction;
    private Action pageSetupAction;
    private Action printAction;
    private Action quitAction;
    private Action vergrAction;
    private Action verklAction;
    private Action verschAction;
    private Action resetAusschnittAction;
    private Action magnetEinstellenAction;
    private Action verschMagnetAction;
    private Action stopContAction;
    private Action parameterAction;
    private Action transferAction;
    private Action groesseAction;
    private Action showBassinsAction;
    private File file;
    private PageFormat pageFormat;
    private final PrinterJob printJob = PrinterJob.getPrinterJob();
    protected int prozZahl = 1;
    protected int whatToDo = 0;
    protected int ausgewaehlterMagnet = -1;
    private Calendar startZeitCal;
    private static final int defSizeX = 600;
    private static final int defSizeY = 400;

    public Bassins(Magnetpendel parent, String title) {
        int i;
        this.ich = this;
        this.Main = parent;
        this.XMin = this.Main.trajektorie.XMin;
        this.XMax = this.Main.trajektorie.XMax;
        this.YMin = this.Main.trajektorie.YMin;
        this.YMax = this.Main.trajektorie.YMax;
        this.ReibKoeff = this.Main.trajektorie.ReibKoeff;
        this.GravConst = this.Main.trajektorie.GravConst;
        this.MagAbst = this.Main.trajektorie.MagAbst;
        this.MagAnz = this.Main.trajektorie.MagAnz;
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagX[i] = this.Main.trajektorie.MagX[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagY[i] = this.Main.trajektorie.MagY[i];
        }
        for (i = 0; i < this.MagAnz; ++i) {
            this.MagPar[i] = this.Main.trajektorie.MagPar[i];
        }
        for (i = 0; i < this.MagAnz + 1; ++i) {
            this.MagnetFarben[i] = this.Main.trajektorie.MagnetFarben[i];
        }
        this.Genauigkeit = this.Main.trajektorie.Genauigkeit;
        this.AnfangsSchrittweite = this.Main.trajektorie.AnfangsSchrittweite;
        this.MagEntf = this.Main.trajektorie.MagEntf;
        this.prozZahl = Runtime.getRuntime().availableProcessors();
        if (this.prozZahl < 1) {
            this.prozZahl = 1;
        }
        if (this.prozZahl > 16) {
            this.prozZahl = 16;
        }
        this.fensterTitel = title != null ? title : "Bassins " + this.Main.bassinsNumber;
        this.setResizable(false);
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                Bassins.this.askCloseWindow();
            }
        });
        this.calcPane = new calcPaneClass();
        this.calcPane.setBackground(new Color(255, 255, 255));
        this.getContentPane().setLayout(new BorderLayout(10, 0));
        this.getContentPane().add((Component)this.calcPane, "Center");
        this.pack();
        this.createActions();
        this.addMenus();
        this.setTitle(this.fensterTitel);
        Insets wBorder = this.getInsets();
        this.setSize(600 + wBorder.left + wBorder.right, 400 + this.getHeight() - this.calcPane.getHeight() + wBorder.top + wBorder.bottom);
    }

    public void askCloseWindow() {
        if (!this.isSaved && !new AutoDialog().display("M\u00f6chten Sie wirklich das Fenster schlie\u00dfen?", "Die aktuelle Berechnung ist noch nicht gespeichert.", "Ja", "Nein")) {
            return;
        }
        ((JFrame)this.calcPane.getTopLevelAncestor()).setVisible(false);
        this.berechnungStoppen();
        JMenu helpMenu = Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1);
        int itemCount = helpMenu.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            JMenuItem helpItem = helpMenu.getItem(i);
            if (helpItem == null || helpItem.getText() != this.fensterTitel) continue;
            Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1).remove(i);
            if (i == itemCount - 1) {
                if (!this.Main.isVisible() && new AutoDialog().display("M\u00f6chten Sie das Programm beenden?", "Sie haben gerade das letzte Fenster geschlossen.\n('Nein' \u00f6ffnet das Hauptfenster neu.)", "Ja", "Nein")) {
                    System.exit(0);
                }
                this.Main.setVisible(true);
            }
            i = itemCount;
        }
        this.cloneFensterMenuForAllBassinsWindows();
    }

    public void createActions() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.openAction = new openActionClass("\u00d6ffnen...", KeyStroke.getKeyStroke(79, shortcutKeyMask));
        this.closeAction = new closeActionClass("Schlie\u00dfen", KeyStroke.getKeyStroke(87, shortcutKeyMask));
        this.saveAction = new saveActionClass("Sichern", KeyStroke.getKeyStroke(83, shortcutKeyMask));
        this.saveAsAction = new saveAsActionClass("Sichern unter...", KeyStroke.getKeyStroke(83, shortcutKeyMask + 1));
        this.exportAction = new exportActionClass("Bild exportieren...", KeyStroke.getKeyStroke(69, shortcutKeyMask));
        this.pageSetupAction = new pageSetupActionClass("Papierformat...", KeyStroke.getKeyStroke(80, 5));
        this.printAction = new printActionClass("Drucken...", KeyStroke.getKeyStroke(80, shortcutKeyMask));
        this.quitAction = new quitActionClass("Programm beenden", KeyStroke.getKeyStroke(81, shortcutKeyMask));
        this.vergrAction = new vergrActionClass("Ausschnitt vergr\u00f6\u00dfern", KeyStroke.getKeyStroke(521, shortcutKeyMask));
        this.verklAction = new verklActionClass("Ausschnitt verkleinern", KeyStroke.getKeyStroke(45, shortcutKeyMask));
        this.verschAction = new verschActionClass("Ausschnitt verschieben", KeyStroke.getKeyStroke(106, shortcutKeyMask));
        this.resetAusschnittAction = new resetAusschnittActionClass("Ausschnitt zur\u00fccksetzen", KeyStroke.getKeyStroke(61, shortcutKeyMask));
        this.verschMagnetAction = new verschMagnetActionClass("Magnet verschieben", null);
        this.magnetEinstellenAction = new magnetEinstellenActionClass("Magnete einstellen...", KeyStroke.getKeyStroke(77, shortcutKeyMask));
        this.stopContAction = new stopContActionClass("Berechnung anhalten", KeyStroke.getKeyStroke(72, shortcutKeyMask));
        this.parameterAction = new parameterActionClass("Parameter \u00e4ndern...", KeyStroke.getKeyStroke(75, shortcutKeyMask));
        this.transferAction = new transferActionClass("Parameter -> Trajektorie", null);
        this.groesseAction = new groesseActionClass("Gr\u00f6\u00dfe \u00e4ndern...", KeyStroke.getKeyStroke(71, shortcutKeyMask));
        this.showBassinsAction = new showBassinsActionClass(this.fensterTitel, null, this);
    }

    public void addMenus() {
        this.ablageMenu = this.Main.compiledForMac ? new JMenu("Ablage") : new JMenu("Datei");
        JMenuItem helpItem = new JMenuItem("Neu");
        helpItem.setEnabled(false);
        this.ablageMenu.add(helpItem);
        this.ablageMenu.add(new JMenuItem(this.openAction));
        this.ablageMenu.addSeparator();
        this.ablageMenu.add(new JMenuItem(this.closeAction));
        this.ablageMenu.add(new JMenuItem(this.saveAction));
        this.ablageMenu.add(new JMenuItem(this.saveAsAction));
        this.ablageMenu.add(new JMenuItem(this.exportAction));
        this.ablageMenu.addSeparator();
        this.ablageMenu.add(new JMenuItem(this.pageSetupAction));
        this.ablageMenu.add(new JMenuItem(this.printAction));
        if (!this.Main.compiledForMac) {
            this.ablageMenu.addSeparator();
            this.ablageMenu.add(new JMenuItem(this.quitAction));
        }
        this.mainMenuBar.add(this.ablageMenu);
        this.ebeneMenu = new JMenu("Ebene");
        this.ebeneMenu.add(new JMenuItem(this.vergrAction));
        this.ebeneMenu.add(new JMenuItem(this.verklAction));
        this.ebeneMenu.add(new JMenuItem(this.verschAction));
        this.ebeneMenu.add(new JMenuItem(this.resetAusschnittAction));
        this.ebeneMenu.addSeparator();
        this.ebeneMenu.add(new JMenuItem(this.verschMagnetAction));
        this.ebeneMenu.add(new JMenuItem(this.magnetEinstellenAction));
        this.mainMenuBar.add(this.ebeneMenu);
        this.bassinMenu = new JMenu("Bassins");
        this.bassinMenu.add(new JMenuItem(this.stopContAction));
        this.bassinMenu.addSeparator();
        this.bassinMenu.add(new JMenuItem(this.parameterAction));
        this.bassinMenu.add(new JMenuItem(this.transferAction));
        this.bassinMenu.addSeparator();
        this.bassinMenu.add(new JMenuItem(this.groesseAction));
        this.mainMenuBar.add(this.bassinMenu);
        this.setJMenuBar(this.mainMenuBar);
        JMenu helpMenu = Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1);
        helpMenu.add(new JMenuItem(this.showBassinsAction));
        this.cloneFensterMenuForAllBassinsWindows();
    }

    public void cloneFensterMenue() {
        int j = this.mainMenuBar.getMenuCount() - 1;
        if (j > 2) {
            this.mainMenuBar.remove(j);
        }
        JMenu helpMenu = Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1);
        JMenu thisMenu = new JMenu(helpMenu.getText());
        for (j = 0; j < helpMenu.getItemCount(); ++j) {
            JMenuItem helpItem = helpMenu.getItem(j);
            if (helpItem == null) {
                thisMenu.addSeparator();
                continue;
            }
            thisMenu.add(new JMenuItem(helpItem.getAction()));
        }
        this.mainMenuBar.add(thisMenu);
    }

    public void cloneFensterMenuForAllBassinsWindows() {
        JMenu helpMenu = Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1);
        int itemCount = helpMenu.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            Action helpAction;
            JMenuItem helpItem = helpMenu.getItem(i);
            if (helpItem == null || !((helpAction = helpItem.getAction()) instanceof showBassinsActionClass)) continue;
            ((showBassinsActionClass)helpAction).parent.cloneFensterMenue();
        }
    }

    public void fensterTitelAendern(String titel) {
        JMenuItem helpItem = null;
        JMenu helpMenu = Magnetpendel.mainMenuBar.getMenu(Magnetpendel.mainMenuBar.getMenuCount() - 1);
        int itemCount = helpMenu.getItemCount();
        for (int i = 0; i < itemCount; ++i) {
            helpItem = helpMenu.getItem(i);
            if (helpItem == null || !helpItem.getText().equals(this.fensterTitel)) continue;
            i = itemCount;
        }
        this.fensterTitel = titel;
        this.setTitle(this.fensterTitel);
        if (helpItem == null) {
            return;
        }
        this.showBassinsAction.putValue("Name", this.fensterTitel);
        this.cloneFensterMenuForAllBassinsWindows();
    }

    public void readFile(File f) {
        System.out.print("Lesen...");
        try {
            CalcBassins berechnungsThread2;
            int i;
            this.file = f;
            FileInputStream fis = new FileInputStream(f);
            ObjectInputStream stream = new ObjectInputStream(fis);
            String dummy = (String)stream.readObject();
            this.XMin = stream.readDouble();
            this.XMax = stream.readDouble();
            this.YMin = stream.readDouble();
            this.YMax = stream.readDouble();
            this.ReibKoeff = stream.readDouble();
            this.GravConst = stream.readDouble();
            this.MagAbst = stream.readDouble();
            this.MagAnz = stream.readInt();
            for (i = 0; i < 3; ++i) {
                this.MagX[i] = stream.readDouble();
            }
            for (i = 0; i < 3; ++i) {
                this.MagY[i] = stream.readDouble();
            }
            for (i = 0; i < 3; ++i) {
                this.MagPar[i] = stream.readDouble();
            }
            for (i = 0; i < 3; ++i) {
                this.MagnetFarben[i] = (Color)stream.readObject();
            }
            this.Genauigkeit = stream.readDouble();
            this.AnfangsSchrittweite = stream.readDouble();
            this.MagEntf = stream.readDouble();
            int breite = stream.readInt();
            int hoehe = stream.readInt();
            JFrame window = (JFrame)this.calcPane.getTopLevelAncestor();
            window.setSize(breite, hoehe);
            window.setResizable(false);
            this.calcPane.setSize(breite, hoehe);
            stream.mark(10);
            if (!((String)stream.readObject()).equals("V2")) {
                System.out.println("!!!!!");
                stream.reset();
                berechnungsThread2 = new CalcBassins(this.calcPane, 0, 100);
                berechnungsThread2.breite = breite;
                berechnungsThread2.hoehe = hoehe;
                berechnungsThread2.PixelStaerkeAnfang = stream.readInt();
                berechnungsThread2.ykoSave = stream.readInt();
                dummy = (String)stream.readObject();
                berechnungsThread2.bild = ImageIO.read(stream);
            } else {
                this.berechnungsThreads.removeAllElements();
                this.prozZahl = stream.readInt();
                System.out.print("pZ:" + this.prozZahl);
                for (i = 0; i < this.prozZahl; ++i) {
                    System.out.print(stream.readObject());
                    int y_start = stream.readInt();
                    System.out.print("ys:" + y_start);
                    int y_end = stream.readInt();
                    System.out.print("ye:" + y_end);
                    berechnungsThread2 = new CalcBassins(this.calcPane, y_start, y_end);
                    berechnungsThread2.setValues(this.XMin, this.XMax, this.YMin, this.YMax, this.ReibKoeff, this.GravConst, this.MagAbst, this.MagAnz, this.MagX, this.MagY, this.MagPar, this.MagnetFarben, this.Genauigkeit, this.AnfangsSchrittweite, this.MagEntf);
                    berechnungsThread2.PixelStaerkeAnfang = stream.readInt();
                    berechnungsThread2.ykoSave = stream.readInt();
                    berechnungsThread2.firsttime = false;
                    this.berechnungsThreads.add(berechnungsThread2);
                }
                if (this.berechnungsThreads.size() != this.prozZahl) {
                    new AutoDialog().display("Fehler:", "Konnte nicht gen\u00fcgend Threads initialisieren!!!", "OK");
                    stream.close();
                    return;
                }
            }
            System.out.print(stream.readObject());
            BufferedImage bild = new BufferedImage(breite, hoehe, 1);
            bild = ImageIO.read(stream);
            System.out.print("Bild gelesen");
            System.out.println("b:" + bild.getWidth() + " h:" + bild.getHeight());
            stream.close();
            for (CalcBassins berechnungsThread2 : this.berechnungsThreads) {
                berechnungsThread2.bild = bild.getSubimage(0, berechnungsThread2.yko_start - 1, breite, berechnungsThread2.yko_end - berechnungsThread2.yko_start + 1);
            }
        }
        catch (Exception ex) {
            new AutoDialog().display("Fehler beim Lesen der Datei!", ex.toString());
            return;
        }
        System.out.println("...fertig.");
        this.repaint();
        this.berechnungStarten();
    }

    public void save(File f) {
        int i = 0;
        System.out.print("Schreiben...");
        try {
            FileOutputStream fos = new FileOutputStream(f);
            ObjectOutputStream stream = new ObjectOutputStream(fos);
            stream.writeObject("bass");
            stream.writeDouble(this.XMin);
            stream.writeDouble(this.XMax);
            stream.writeDouble(this.YMin);
            stream.writeDouble(this.YMax);
            stream.writeDouble(this.ReibKoeff);
            stream.writeDouble(this.GravConst);
            stream.writeDouble(this.MagAbst);
            stream.writeInt(this.MagAnz);
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagX[i]);
            }
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagY[i]);
            }
            for (i = 0; i < 3; ++i) {
                stream.writeDouble(this.MagPar[i]);
            }
            for (i = 0; i < 3; ++i) {
                stream.writeObject(this.MagnetFarben[i]);
            }
            stream.writeDouble(this.Genauigkeit);
            stream.writeDouble(this.AnfangsSchrittweite);
            stream.writeDouble(this.MagEntf);
            stream.writeInt(this.getWidth());
            stream.writeInt(this.getHeight());
            stream.writeObject("V2");
            stream.writeInt(this.berechnungsThreads.size());
            i = 1;
            for (CalcBassins berechnungsThread : this.berechnungsThreads) {
                stream.writeObject("\nThread " + i++ + ":\n");
                stream.writeInt(berechnungsThread.yko_start);
                System.out.print(" " + berechnungsThread.yko_start);
                stream.writeInt(berechnungsThread.yko_end);
                System.out.print(" " + berechnungsThread.yko_end);
                stream.writeInt(berechnungsThread.PixelStaerkeAnfang);
                System.out.print(" " + berechnungsThread.PixelStaerkeAnfang);
                stream.writeInt(berechnungsThread.ykoSave);
                System.out.print(" " + berechnungsThread.ykoSave);
            }
            stream.writeObject("\nBILD\n");
            System.out.print("BILD");
            BufferedImage bild = new BufferedImage(this.calcPane.getWidth(), this.calcPane.getHeight(), 1);
            Graphics2D gra = bild.createGraphics();
            this.zeichneMagnete = false;
            this.calcPane.paint(gra);
            this.zeichneMagnete = true;
            ImageIO.write((RenderedImage)bild, "png", stream);
            stream.close();
            this.isSaved = true;
            System.out.println("...fertig.");
        }
        catch (Exception ex) {
            new AutoDialog().display("Fehler beim Schreiben der Datei!", ex.toString());
        }
    }

    public void doPrint() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        PrintJob pj = tk.getPrintJob(new Frame(), "Drucken is toll!", null);
        if (pj != null) {
            Graphics g = pj.getGraphics();
            this.calcPane.paint(g);
            g.dispose();
            pj.end();
        }
    }

    public void berechneNeu() {
        int y_end = 0;
        if (this.berechnungsThreads.size() != 0) {
            this.berechnungStoppen();
            this.berechnungsThreads.removeAllElements();
        }
        System.out.println("Verwende " + this.prozZahl + " Threads.");
        int y_delta = this.calcPane.getHeight() / this.prozZahl;
        for (int i = 0; i < this.prozZahl; ++i) {
            int y_start = y_end + 1;
            y_end += y_delta;
            if (i == this.prozZahl - 1) {
                y_end = this.calcPane.getHeight();
            }
            CalcBassins berechnungsThread = new CalcBassins(this.calcPane, y_start, y_end);
            berechnungsThread.setValues(this.XMin, this.XMax, this.YMin, this.YMax, this.ReibKoeff, this.GravConst, this.MagAbst, this.MagAnz, this.MagX, this.MagY, this.MagPar, this.MagnetFarben, this.Genauigkeit, this.AnfangsSchrittweite, this.MagEntf);
            this.berechnungsThreads.add(berechnungsThread);
        }
        if (this.berechnungsThreads.size() != this.prozZahl) {
            new AutoDialog().display("Fehler:", "Konnte nicht gen\u00fcgend Threads initialisieren!!!", "OK");
            return;
        }
        this.startZeitCal = Calendar.getInstance();
        this.berechnungStarten();
    }

    private boolean berechnungLaeuft() {
        for (CalcBassins berechnungsThread : this.berechnungsThreads) {
            if (!berechnungsThread.stillrunning) continue;
            return true;
        }
        return false;
    }

    private boolean berechnungFertig() {
        for (CalcBassins berechnungsThread : this.berechnungsThreads) {
            if (berechnungsThread.PixelStaerkeAnfang <= 0) continue;
            return false;
        }
        this.setTitle(this.fensterTitel + " - fertig");
        return true;
    }

    private void berechnungStarten() {
        this.threadListe.removeAllElements();
        for (CalcBassins berechnungsThread : this.berechnungsThreads) {
            berechnungsThread.stop = false;
            this.threadListe.add(new Thread(berechnungsThread));
        }
        Iterator j = this.threadListe.iterator();
        while (j.hasNext()) {
            ((Thread)j.next()).start();
        }
        this.setTitle(this.fensterTitel + " - rechne");
        this.bassinMenu.getItem(0).setText("Berechnung anhalten");
        this.bassinMenu.getItem(0).setEnabled(true);
        this.isSaved = false;
    }

    private void berechnungStoppen() {
        this.setTitle(this.fensterTitel + " - stoppe");
        this.bassinMenu.getItem(0).setEnabled(false);
        for (CalcBassins berechnungsThread : this.berechnungsThreads) {
            berechnungsThread.stop = true;
        }
        try {
            Iterator j = this.threadListe.iterator();
            while (j.hasNext()) {
                ((Thread)j.next()).join();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.threadListe.removeAllElements();
        this.bassinMenu.getItem(0).setText("Berechnung fortsetzen");
        this.bassinMenu.getItem(0).setEnabled(true);
        this.setTitle(this.fensterTitel + " - gestoppt");
    }

    class calcPaneClass
    extends JPanel
    implements MouseListener,
    MouseMotionListener {
        private int i;
        private Point point;
        private double XVersch;
        private double YVersch;
        private double XFaktor;
        private double YFaktor;
        int x3 = -1;
        int y3 = -1;
        int x1 = -1;
        int x2 = -1;
        int y1;
        int y2;
        boolean mouseGedrueckt = false;

        public calcPaneClass() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    calcPaneClass.this.keyEventHandler((KeyEvent)event);
                }
            }, 8L);
        }

        protected void CalcFakVersch() {
            this.XFaktor = (Bassins.this.XMax - Bassins.this.XMin) / (double)Bassins.this.calcPane.getWidth();
            this.YFaktor = -(Bassins.this.YMax - Bassins.this.YMin) / (double)Bassins.this.calcPane.getHeight();
            this.XVersch = Bassins.this.XMin;
            this.YVersch = Bassins.this.YMax;
        }

        protected Point XyToScreen(double x, double y) {
            Point point = new Point();
            point.x = (int)((x - this.XVersch) / this.XFaktor);
            point.y = (int)((y - this.YVersch) / this.YFaktor);
            return point;
        }

        protected double[] ScreenToXy(int xscreen, int yscreen) {
            double[] v = new double[]{(double)xscreen * this.XFaktor + this.XVersch, (double)yscreen * this.YFaktor + this.YVersch};
            return v;
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this.CalcFakVersch();
            if (Bassins.this.berechnungsThreads.size() != 0) {
                for (CalcBassins berechnungsThread : Bassins.this.berechnungsThreads) {
                    if (berechnungsThread.bild == null) continue;
                    g.drawImage(berechnungsThread.bild, 0, berechnungsThread.yko_start - 1, berechnungsThread.bild.getWidth(), berechnungsThread.bild.getHeight(), this);
                    g.setColor(Color.white);
                    if (!Bassins.this.zeichneMagnete) continue;
                    g.setColor(Color.black);
                    this.i = 0;
                    while (this.i < Bassins.this.MagAnz) {
                        this.point = this.XyToScreen(Bassins.this.MagX[this.i], Bassins.this.MagY[this.i]);
                        if (Bassins.this.MagPar[this.i] != 0.0) {
                            g.fillOval(this.point.x - 2, this.point.y - 2, 5, 5);
                        }
                        ++this.i;
                    }
                }
                if (Bassins.this.berechnungFertig() && Bassins.this.bassinMenu.getItem(0).isEnabled()) {
                    Bassins.this.bassinMenu.getItem(0).setEnabled(false);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (Bassins.this.whatToDo != 0 && Bassins.this.whatToDo != 4) {
                Graphics gra = this.getGraphics();
                gra.setXORMode(Color.white);
                if (e.getX() != this.x2 && e.getY() != this.y2) {
                    if (this.x3 != -1) {
                        gra.drawLine(0, this.y3, this.getWidth(), this.y3);
                        gra.drawLine(this.x3, 0, this.x3, this.getHeight());
                    }
                    gra.drawLine(0, e.getY(), this.getWidth(), e.getY());
                    gra.drawLine(e.getX(), 0, e.getX(), this.getHeight());
                    this.x3 = e.getX();
                    this.y3 = e.getY();
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (Bassins.this.whatToDo == 0) {
                return;
            }
            Graphics gra = this.getGraphics();
            gra.setXORMode(Color.white);
            if (e.getX() != this.x2 && e.getY() != this.y2) {
                if (Bassins.this.whatToDo != 4) {
                    if (this.x3 != -1) {
                        gra.drawLine(0, this.y3, this.getWidth(), this.y3);
                        gra.drawLine(this.x3, 0, this.x3, this.getHeight());
                        this.x3 = -1;
                    }
                    gra.drawLine(0, e.getY(), this.getWidth(), e.getY());
                    gra.drawLine(e.getX(), 0, e.getX(), this.getHeight());
                    this.x3 = e.getX();
                    this.y3 = e.getY();
                }
                switch (Bassins.this.whatToDo) {
                    case 1: 
                    case 2: {
                        if (this.x2 >= 0) {
                            gra.drawLine(this.x1, this.y1, this.x2, this.y1);
                            gra.drawLine(this.x1, this.y1, this.x1, this.y2);
                        }
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        gra.drawLine(this.x1, this.y1, this.x2, this.y1);
                        gra.drawLine(this.x1, this.y1, this.x1, this.y2);
                        break;
                    }
                    case 3: {
                        if (this.x2 >= 0) {
                            gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                        }
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                        break;
                    }
                    case 4: {
                        if (Bassins.this.ausgewaehlterMagnet < 0) break;
                        if (this.x2 >= 0) {
                            gra.fillOval(this.x2 - 3, this.y2 - 3, 5, 5);
                        }
                        this.x2 = e.getX();
                        this.y2 = e.getY();
                        gra.fillOval(this.x2 - 3, this.y2 - 3, 5, 5);
                    }
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Graphics gra = this.getGraphics();
            this.x1 = e.getX();
            this.y1 = e.getY();
            this.x2 = -1;
            this.y2 = -1;
            this.mouseGedrueckt = true;
            if (Bassins.this.whatToDo == 4) {
                Bassins.this.ausgewaehlterMagnet = -1;
                for (int i = 0; i < Bassins.this.MagAnz; ++i) {
                    Point point = this.XyToScreen(Bassins.this.MagX[i], Bassins.this.MagY[i]);
                    if (Math.abs(e.getX() - point.x) >= 5 || Math.abs(e.getY() - point.y) >= 5) continue;
                    gra.setXORMode(Color.white);
                    gra.fillOval(point.x - 3, point.y - 3, 5, 5);
                    Bassins.this.ausgewaehlterMagnet = i;
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseGedrueckt = false;
            if (Bassins.this.whatToDo == 0) {
                return;
            }
            Graphics gra = this.getGraphics();
            gra.setXORMode(Color.white);
            this.x2 = e.getX();
            this.y2 = e.getY();
            switch (Bassins.this.whatToDo) {
                case 1: {
                    gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    break;
                }
                case 2: {
                    gra.drawRect(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
                    break;
                }
                case 3: {
                    gra.drawLine(this.x1, this.y1, this.x2, this.y2);
                }
            }
            if (Math.abs(this.x1 - this.x2) < 5 && Math.abs(this.y1 - this.y2) < 5) {
                return;
            }
            double[] vect1 = this.ScreenToXy(this.x1, this.y1);
            double[] vect2 = this.ScreenToXy(this.x2, this.y2);
            switch (Bassins.this.whatToDo) {
                case 1: {
                    if (vect1[0] < vect2[0]) {
                        Bassins.this.XMin = vect1[0];
                        Bassins.this.XMax = vect2[0];
                    } else {
                        Bassins.this.XMin = vect2[0];
                        Bassins.this.XMax = vect1[0];
                    }
                    if (vect1[1] < vect2[1]) {
                        Bassins.this.YMin = vect1[1];
                        Bassins.this.YMax = vect2[1];
                        break;
                    }
                    Bassins.this.YMin = vect2[1];
                    Bassins.this.YMax = vect1[1];
                    break;
                }
                case 2: {
                    double help;
                    if (vect1[0] > vect2[0]) {
                        help = vect1[0];
                        vect1[0] = vect2[0];
                        vect2[0] = help;
                    }
                    if (vect1[1] > vect2[1]) {
                        help = vect1[1];
                        vect1[1] = vect2[1];
                        vect2[1] = help;
                    }
                    double fakt = (Bassins.this.XMax - Bassins.this.XMin) / (vect2[0] - vect1[0]);
                    help = Bassins.this.XMax - Bassins.this.XMin;
                    Bassins.this.XMin -= fakt * (vect1[0] - Bassins.this.XMin);
                    Bassins.this.XMax = Bassins.this.XMin + fakt * help;
                    fakt = (Bassins.this.YMax - Bassins.this.YMin) / (vect2[1] - vect1[1]);
                    help = Bassins.this.YMax - Bassins.this.YMin;
                    Bassins.this.YMin -= fakt * (vect1[1] - Bassins.this.YMin);
                    Bassins.this.YMax = Bassins.this.YMin + fakt * help;
                    break;
                }
                case 3: {
                    Bassins.this.XMin -= vect2[0] - vect1[0];
                    Bassins.this.XMax -= vect2[0] - vect1[0];
                    Bassins.this.YMin -= vect2[1] - vect1[1];
                    Bassins.this.YMax -= vect2[1] - vect1[1];
                    break;
                }
                case 4: {
                    if (Bassins.this.ausgewaehlterMagnet >= 0) {
                        Bassins.this.MagX[Bassins.this.ausgewaehlterMagnet] = vect2[0];
                        Bassins.this.MagY[Bassins.this.ausgewaehlterMagnet] = vect2[1];
                        break;
                    }
                    return;
                }
            }
            Bassins.this.whatToDo = 0;
            this.x1 = -1;
            this.x2 = -1;
            this.x3 = -1;
            Bassins.this.berechneNeu();
            Bassins.this.calcPane.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        public void keyEventHandler(KeyEvent event) {
            if (event.getID() == 401) {
                if (event.getKeyCode() == 27 && Bassins.this.whatToDo != 0) {
                    Bassins.this.whatToDo = 0;
                    this.x1 = -1;
                    this.x2 = -1;
                    this.x3 = -1;
                    Bassins.this.calcPane.setCursor(Cursor.getDefaultCursor());
                    this.repaint();
                    if (Bassins.this.bassinMenu.getItem(0).getText().equals("Berechnung anhalten")) {
                        Bassins.this.berechnungStarten();
                    }
                }
            }
        }
    }

    public class showBassinsActionClass
    extends AbstractAction {
        Bassins parent;

        public showBassinsActionClass(String text, KeyStroke shortcut, Bassins p) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
            this.parent = p;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.parent.setVisible(true);
        }
    }

    public class groesseActionClass
    extends AbstractAction {
        public groesseActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            GroesseEingabe eingabe = new GroesseEingabe(Bassins.this.ich, true, Bassins.this.calcPane.getWidth(), Bassins.this.calcPane.getHeight());
            eingabe.showEingabe();
            if (!eingabe.canceled) {
                JFrame window = (JFrame)Bassins.this.calcPane.getTopLevelAncestor();
                int deltaX = window.getWidth() - Bassins.this.calcPane.getWidth();
                int deltaY = window.getHeight() - Bassins.this.calcPane.getHeight();
                window.setSize(eingabe.breite + deltaX, eingabe.hoehe + deltaY);
                window.setResizable(false);
                Bassins.this.calcPane.setSize(eingabe.breite, eingabe.hoehe);
                Bassins.this.berechneNeu();
                return;
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class transferActionClass
    extends AbstractAction {
        public transferActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            Bassins.this.Main.trajektorie.XMin = Bassins.this.XMin;
            Bassins.this.Main.trajektorie.XMax = Bassins.this.XMax;
            Bassins.this.Main.trajektorie.YMin = Bassins.this.YMin;
            Bassins.this.Main.trajektorie.YMax = Bassins.this.YMax;
            Bassins.this.Main.trajektorie.ReibKoeff = Bassins.this.ReibKoeff;
            Bassins.this.Main.trajektorie.GravConst = Bassins.this.GravConst;
            Bassins.this.Main.trajektorie.MagAbst = Bassins.this.MagAbst;
            Bassins.this.Main.trajektorie.Genauigkeit = Bassins.this.Genauigkeit;
            Bassins.this.Main.trajektorie.AnfangsSchrittweite = Bassins.this.AnfangsSchrittweite;
            Bassins.this.Main.trajektorie.MagEntf = Bassins.this.MagEntf;
            Bassins.this.Main.trajektorie.MagAnz = Bassins.this.MagAnz;
            for (i = 0; i < Bassins.this.MagAnz; ++i) {
                Bassins.this.Main.trajektorie.MagX[i] = Bassins.this.MagX[i];
            }
            for (i = 0; i < Bassins.this.MagAnz; ++i) {
                Bassins.this.Main.trajektorie.MagY[i] = Bassins.this.MagY[i];
            }
            for (i = 0; i < Bassins.this.MagAnz; ++i) {
                Bassins.this.Main.trajektorie.MagPar[i] = Bassins.this.MagPar[i];
            }
            for (i = 0; i < Bassins.this.MagAnz + 1; ++i) {
                Bassins.this.Main.trajektorie.MagnetFarben[i] = Bassins.this.MagnetFarben[i];
            }
            Bassins.this.Main.buttonLeiste.update();
            Bassins.this.Main.trajektorie.CalcBackground(Bassins.this.Main.trajektorie.hintergrundBild, Bassins.this.Main.trajektorie);
        }
    }

    public class parameterActionClass
    extends AbstractAction {
        public parameterActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            ParameterEingabe eingabe = new ParameterEingabe(Bassins.this.ich, true);
            eingabe.setValues(Bassins.this.XMin, Bassins.this.XMax, Bassins.this.YMin, Bassins.this.YMax, Bassins.this.ReibKoeff, Bassins.this.GravConst, Bassins.this.MagAbst, Bassins.this.Genauigkeit, Bassins.this.AnfangsSchrittweite, Bassins.this.MagEntf, Bassins.this.MagAnz, Bassins.this.MagX, Bassins.this.MagY, Bassins.this.MagPar, Bassins.this.MagnetFarben);
            eingabe.setVisible(true);
            if (eingabe.okButtonPressed) {
                Bassins.this.XMin = eingabe.xmin;
                Bassins.this.XMax = eingabe.xmax;
                Bassins.this.YMin = eingabe.ymin;
                Bassins.this.YMax = eingabe.ymax;
                Bassins.this.ReibKoeff = eingabe.reibKoeff;
                Bassins.this.GravConst = eingabe.gravKonst;
                Bassins.this.MagAbst = eingabe.magAbst;
                Bassins.this.Genauigkeit = eingabe.genauigkeit;
                Bassins.this.AnfangsSchrittweite = eingabe.schrittweite;
                Bassins.this.MagEntf = eingabe.endeEntf;
                if (eingabe.magnetsChanged) {
                    int i;
                    Bassins.this.MagAnz = eingabe.magAnz;
                    for (i = 0; i < Bassins.this.MagAnz; ++i) {
                        Bassins.this.MagX[i] = eingabe.magX[i];
                    }
                    for (i = 0; i < Bassins.this.MagAnz; ++i) {
                        Bassins.this.MagY[i] = eingabe.magY[i];
                    }
                    for (i = 0; i < Bassins.this.MagAnz; ++i) {
                        Bassins.this.MagPar[i] = eingabe.magSt[i];
                    }
                    for (i = 0; i < Bassins.this.MagAnz + 1; ++i) {
                        Bassins.this.MagnetFarben[i] = eingabe.magFarbe[i];
                    }
                }
                Bassins.this.berechneNeu();
                return;
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class stopContActionClass
    extends AbstractAction {
        public stopContActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Bassins.this.berechnungLaeuft()) {
                Bassins.this.berechnungStoppen();
            } else {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class magnetEinstellenActionClass
    extends AbstractAction {
        public magnetEinstellenActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            MagneteEinstellen magEinstellen = new MagneteEinstellen((JFrame)Bassins.this.calcPane.getTopLevelAncestor(), true);
            magEinstellen.setValues(Bassins.this.MagAnz, Bassins.this.MagX, Bassins.this.MagY, Bassins.this.MagPar, Bassins.this.MagnetFarben);
            magEinstellen.setVisible(true);
            if (magEinstellen.okButtonPressed) {
                int i;
                for (i = 0; i < Bassins.this.MagAnz; ++i) {
                    Bassins.this.MagX[i] = magEinstellen.magX[i];
                }
                for (i = 0; i < Bassins.this.MagAnz; ++i) {
                    Bassins.this.MagY[i] = magEinstellen.magY[i];
                }
                for (i = 0; i < Bassins.this.MagAnz; ++i) {
                    Bassins.this.MagPar[i] = magEinstellen.magSt[i];
                }
                for (i = 0; i < Bassins.this.MagAnz + 1; ++i) {
                    Bassins.this.MagnetFarben[i] = magEinstellen.magFarbe[i];
                }
                Bassins.this.berechneNeu();
                return;
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class verschMagnetActionClass
    extends AbstractAction {
        public verschMagnetActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.berechnungStoppen();
            Bassins.this.whatToDo = 4;
            Bassins.this.calcPane.setCursor(new Cursor(12));
        }
    }

    public class resetAusschnittActionClass
    extends AbstractAction {
        public resetAusschnittActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.whatToDo = 0;
            Bassins.this.XMin = -7.0;
            Bassins.this.XMax = 7.0;
            Bassins.this.YMin = -4.9;
            Bassins.this.YMax = 4.9;
            Bassins.this.berechneNeu();
        }
    }

    public class verklActionClass
    extends AbstractAction {
        public verklActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.berechnungStoppen();
            Bassins.this.whatToDo = 2;
        }
    }

    public class vergrActionClass
    extends AbstractAction {
        public vergrActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.berechnungStoppen();
            Bassins.this.whatToDo = 1;
        }
    }

    public class verschActionClass
    extends AbstractAction {
        public verschActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.berechnungStoppen();
            Bassins.this.whatToDo = 3;
        }
    }

    public class quitActionClass
    extends AbstractAction {
        public quitActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    public class printActionClass
    extends AbstractAction {
        public printActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.doPrint();
        }
    }

    public class pageSetupActionClass
    extends AbstractAction {
        public pageSetupActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.pageFormat = Bassins.this.printJob.pageDialog(Bassins.this.printJob.defaultPage());
            Bassins.this.printJob.defaultPage(Bassins.this.pageFormat);
        }
    }

    public class exportActionClass
    extends AbstractAction {
        public exportActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            FileDialog fileSaveDialog = new FileDialog((Frame)((JFrame)Bassins.this.Main.trajektorie.getTopLevelAncestor()), "Geben Sie Name und Ort der Bilddatei an...", 1);
            fileSaveDialog.setFile(Bassins.this.fensterTitel + ".png");
            fileSaveDialog.setVisible(true);
            if (fileSaveDialog.getFile() != null) {
                try {
                    File file = new File(fileSaveDialog.getDirectory(), fileSaveDialog.getFile());
                    BufferedImage bild = new BufferedImage(Bassins.this.calcPane.getWidth(), Bassins.this.calcPane.getHeight(), 1);
                    Graphics2D gra = bild.createGraphics();
                    Bassins.this.calcPane.paint(gra);
                    ImageIO.write((RenderedImage)bild, "png", file);
                }
                catch (Exception ex) {
                    new AutoDialog().display("Fehler!", "Kann die Datei nicht schreiben.");
                }
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class saveAsActionClass
    extends AbstractAction {
        public saveAsActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            FileDialog fileSaveDialog = new FileDialog((Frame)((JFrame)Bassins.this.calcPane.getTopLevelAncestor()), "Geben Sie Name und Ort der Datei an...", 1);
            fileSaveDialog.setFile(Bassins.this.fensterTitel + ".mpendb");
            fileSaveDialog.setVisible(true);
            if (fileSaveDialog.getFile() != null) {
                try {
                    File file = new File(fileSaveDialog.getDirectory(), fileSaveDialog.getFile());
                    Bassins.this.save(file);
                    Bassins.this.fensterTitelAendern(fileSaveDialog.getFile());
                }
                catch (Exception ex) {
                    new AutoDialog().display("Fehler!", "Kann die Datei nicht schreiben.", "OK");
                    Bassins.this.file = null;
                }
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class saveActionClass
    extends AbstractAction {
        public saveActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean wasrunning = false;
            if (Bassins.this.berechnungLaeuft()) {
                wasrunning = true;
                Bassins.this.berechnungStoppen();
            }
            if (Bassins.this.file == null) {
                FileDialog fileSaveDialog = new FileDialog((Frame)((JFrame)Bassins.this.calcPane.getTopLevelAncestor()), "Geben Sie Name und Ort der Datei an...", 1);
                fileSaveDialog.setFile(Bassins.this.fensterTitel + ".mpendb");
                fileSaveDialog.setVisible(true);
                if (fileSaveDialog.getFile() != null) {
                    try {
                        Bassins.this.file = new File(fileSaveDialog.getDirectory(), fileSaveDialog.getFile());
                        Bassins.this.save(Bassins.this.file);
                        Bassins.this.fensterTitelAendern(fileSaveDialog.getFile());
                    }
                    catch (Exception ex) {
                        new AutoDialog().display("Fehler!", "Kann die Datei nicht schreiben.", "OK");
                        Bassins.this.file = null;
                    }
                }
            } else {
                Bassins.this.save(Bassins.this.file);
            }
            if (wasrunning) {
                Bassins.this.berechnungStarten();
            }
        }
    }

    public class openActionClass
    extends AbstractAction {
        public openActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block6: {
                FileDialog fileOpenDialog = new FileDialog((Frame)((JFrame)Bassins.this.calcPane.getTopLevelAncestor()), "Geben Sie Name und Ort der Datei an...", 0);
                fileOpenDialog.setVisible(true);
                if (fileOpenDialog.getFile() != null) {
                    try {
                        File file = new File(fileOpenDialog.getDirectory(), fileOpenDialog.getFile());
                        FileInputStream fis = new FileInputStream(file);
                        ObjectInputStream stream = new ObjectInputStream(fis);
                        String ID = (String)stream.readObject();
                        if (ID.equals("traj")) {
                            if (new AutoDialog().display("Es handelt sich um eine Trajektorien-Datei.", "Die aktuellen Trajektorien werden beim Laden gel\u00f6scht.", "Fortfahren", "Abbrechen")) {
                                Bassins.this.Main.trajektorie.open(file);
                            }
                            break block6;
                        }
                        if (ID.equals("bass")) {
                            ++Bassins.this.Main.bassinsNumber;
                            new Bassins(Bassins.this.Main, fileOpenDialog.getFile()).readFile(file);
                            break block6;
                        }
                        throw new Exception();
                    }
                    catch (Exception ex) {
                        new AutoDialog().display("Fehler beim \u00d6ffnen der Datei!", "Die Datei ist nicht lesbar.", "OK");
                        Bassins.this.file = null;
                    }
                }
            }
        }
    }

    public class closeActionClass
    extends AbstractAction {
        public closeActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Bassins.this.askCloseWindow();
        }
    }

    public class newBassinsActionClass
    extends AbstractAction {
        public newBassinsActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new Bassins(Bassins.this.Main, null).berechnungStarten();
        }
    }
}

