/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.djep;

import com.singularsys.extensions.djep.DEquationExtractor;
import com.singularsys.extensions.djep.DJepComponents;
import com.singularsys.extensions.djep.Diff;
import com.singularsys.extensions.djep.DiffRulesI;
import com.singularsys.extensions.djep.DifferentiationVisitor;
import com.singularsys.extensions.djep.diffRules.DivideDiffRule;
import com.singularsys.extensions.djep.diffRules.IfDiffRule;
import com.singularsys.extensions.djep.diffRules.MacroDiffRules;
import com.singularsys.extensions.djep.diffRules.MultiplyDiffRule;
import com.singularsys.extensions.djep.diffRules.PassThroughDiffRule;
import com.singularsys.extensions.djep.diffRules.PowerDiffRule;
import com.singularsys.extensions.djep.diffRules.ZeroDiffRule;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.ComponentSet;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.Node;

public class DJep
extends XJep {
    private static final long serialVersionUID = 340L;
    protected DifferentiationVisitor dv;

    public DJep() {
        this(new DJepComponents());
    }

    public DJep(JepComponent ... jepComponentArray) {
        this(new DJepComponents(jepComponentArray));
    }

    public DJep(ComponentSet componentSet) {
        super(componentSet);
        this.addFunction("diff", new Diff());
        this.reinitializeComponents();
    }

    @Override
    protected void setXComponentInternal(JepComponent jepComponent) {
        if (jepComponent instanceof DifferentiationVisitor) {
            this.dv = (DifferentiationVisitor)jepComponent;
        } else {
            super.setXComponentInternal(jepComponent);
        }
    }

    public DifferentiationVisitor getDifferentationVisitor() {
        return this.dv;
    }

    public boolean addStandardDiffRules() {
        try {
            this.addDiffRule(new PassThroughDiffRule(this, this.getOperatorTable().getAdd()));
            this.addDiffRule(new PassThroughDiffRule(this, this.getOperatorTable().getSubtract()));
            this.addDiffRule(new PassThroughDiffRule(this, this.getOperatorTable().getUMinus()));
            this.addDiffRule(new MultiplyDiffRule(this, this.getOperatorTable().getMultiply()));
            this.addDiffRule(new DivideDiffRule(this, this.getOperatorTable().getDivide()));
            this.addDiffRule(new PowerDiffRule(this, this.getOperatorTable().getPower()));
            this.addDiffRule(new PassThroughDiffRule(this, this.getOperatorTable().getList()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getEQ()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getNE()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getLT()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getLE()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getGT()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getGE()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getAnd()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getOr()));
            this.addDiffRule(new ZeroDiffRule(this, this.getOperatorTable().getNot()));
            if (this.funTab.getFunction("sin") != null) {
                this.addDiffRule(new MacroDiffRules(this, "sin", "cos(x)"));
            }
            if (this.funTab.getFunction("cos") != null) {
                this.addDiffRule(new MacroDiffRules(this, "cos", "-sin(x)"));
            }
            if (this.funTab.getFunction("tan") != null) {
                this.addDiffRule(new MacroDiffRules(this, "tan", "1/((cos(x))^2)"));
            }
            if (this.funTab.getFunction("sec") != null) {
                this.addDiffRule(new MacroDiffRules(this, "sec", "sec(x) * tan(x)"));
            }
            if (this.funTab.getFunction("cosec") != null) {
                this.addDiffRule(new MacroDiffRules(this, "cosec", "-cosec(x) * cot(x)"));
            }
            if (this.funTab.getFunction("cot") != null) {
                this.addDiffRule(new MacroDiffRules(this, "cot", "-(cosec(x))^2"));
            }
            if (this.funTab.getFunction("asin") != null) {
                this.addDiffRule(new MacroDiffRules(this, "asin", "1/(sqrt(1-x^2))"));
            }
            if (this.funTab.getFunction("acos") != null) {
                this.addDiffRule(new MacroDiffRules(this, "acos", "-1/(sqrt(1-x^2))"));
            }
            if (this.funTab.getFunction("atan") != null) {
                this.addDiffRule(new MacroDiffRules(this, "atan", "1/(1+x^2)"));
            }
            if (this.funTab.getFunction("sinh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "sinh", "cosh(x)"));
            }
            if (this.funTab.getFunction("cosh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "cosh", "sinh(x)"));
            }
            if (this.funTab.getFunction("tanh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "tanh", "1-(tanh(x))^2"));
            }
            if (this.funTab.getFunction("asinh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "asinh", "1/(sqrt(1+x^2))"));
            }
            if (this.funTab.getFunction("acosh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "acosh", "1/(sqrt(x^2-1))"));
            }
            if (this.funTab.getFunction("atanh") != null) {
                this.addDiffRule(new MacroDiffRules(this, "atanh", "1/(1-x^2)"));
            }
            if (this.funTab.getFunction("sqrt") != null) {
                this.addDiffRule(new MacroDiffRules(this, "sqrt", "1/(2*sqrt(x))"));
            }
            if (this.funTab.getFunction("pow") != null) {
                this.addDiffRule(new MacroDiffRules(this, "pow", "y*pow(x,(y-1))", "pow(x,y)*ln(x)"));
            }
            if (this.funTab.getFunction("exp") != null) {
                this.addDiffRule(new MacroDiffRules(this, "exp", "exp(x)"));
            }
            if (this.funTab.getFunction("ln") != null) {
                this.addDiffRule(new MacroDiffRules(this, "ln", "1/x"));
            }
            if (this.funTab.getFunction("log") != null) {
                this.addDiffRule(new MacroDiffRules(this, "log", this.getNodeFactory().buildOperatorNode(this.getOperatorTable().getDivide(), this.getNodeFactory().buildConstantNode(this.getNumberFactory().createNumber(1.0 / Math.log(10.0))), this.getNodeFactory().buildVariableNode(this.getVariableTable().addVariable("x")))));
            }
            if (this.funTab.getFunction("abs") != null) {
                this.addDiffRule(new MacroDiffRules(this, "abs", "abs(x)/x"));
            }
            if (this.funTab.getFunction("atan2") != null) {
                this.addDiffRule(new MacroDiffRules(this, "atan2", "-y/(x^2+y^2)", "x/(x^2+y^2)"));
            }
            if (this.funTab.getFunction("mod") != null) {
                this.addDiffRule(new MacroDiffRules(this, "mod", "1", "0"));
            }
            if (this.funTab.getFunction("sum") != null) {
                this.addDiffRule(new PassThroughDiffRule(this, "sum"));
            }
            if (this.funTab.getFunction("re") != null) {
                this.addDiffRule(new PassThroughDiffRule(this, "re"));
            }
            if (this.funTab.getFunction("im") != null) {
                this.addDiffRule(new PassThroughDiffRule(this, "im"));
            }
            if (this.funTab.getFunction("if") != null) {
                this.addDiffRule(new IfDiffRule(this, "if"));
            }
            return true;
        }
        catch (ParseException parseException) {
            System.err.println(parseException.getMessage());
            return false;
        }
    }

    public void addDiffRule(DiffRulesI diffRulesI) {
        this.dv.addDiffRule(diffRulesI);
    }

    public Node differentiate(Node node, String string) throws ParseException {
        return this.dv.differentiate(node, string);
    }

    public Node replacePartialDerivativeByExpressions(Node node) throws JepException {
        return ((DEquationExtractor)this.extractor).replacePartialDerivativeByExpressions(node);
    }
}

