/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastmatrix;

import com.singularsys.extensions.fastmatrix.MObjStore;
import com.singularsys.extensions.fastmatrix.MrpEval;
import com.singularsys.extensions.fastmatrix.MrpRes;
import com.singularsys.extensions.fastmatrix.ScalerObj;
import com.singularsys.extensions.matrix.Dimensions;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.Variable;
import java.util.Stack;

final class MScalerStore
extends MObjStore {
    private static final long serialVersionUID = 330L;
    private double[] stack = new double[0];
    double[] vars = new double[0];
    private double[] cnst = new double[0];

    public MScalerStore(MrpEval mrpEval) {
        super(mrpEval);
    }

    @Override
    final void decStack() throws ParseException {
        --this.sp;
        if (this.sp < -1) {
            throw new ParseException("RPEval: stack error");
        }
    }

    @Override
    final void alloc() {
        this.stack = new double[this.stackMax + 1];
    }

    @Override
    final int expandVarArray(Dimensions dimensions) {
        double[] dArray = new double[this.vars.length + 1];
        System.arraycopy(this.vars, 0, dArray, 0, this.vars.length);
        this.vars = dArray;
        return this.vars.length - 1;
    }

    @Override
    void cleanUp() {
        this.jepVarIndex.clear();
        this.vars = new double[0];
        this.cnst = new double[0];
        this.stackMax = 0;
        this.heapMax = 0;
        this.stack = null;
    }

    @Override
    void updateToJepVariables() {
        int n = this.jepVarIndex.size();
        for (int i = 0; i < n; ++i) {
            Variable variable = (Variable)this.jepVarIndex.get(i);
            Object object = variable.getValue();
            double d = this.vars[i];
            if (object != null && object instanceof Number && ((Number)object).doubleValue() == d) continue;
            variable.setValue(d);
        }
    }

    @Override
    final void copyFromJepVar(int n, Variable variable) throws EvaluationException {
        if (variable.hasValidValue()) {
            Object object = variable.getValue();
            if (object instanceof Number) {
                this.vars[n] = ((Number)object).doubleValue();
            } else {
                throw new EvaluationException("Variable value cannot be converted to a double " + object);
            }
        }
    }

    public final void pushDouble(double d) {
        this.stack[++this.sp] = d;
    }

    final double popDouble() {
        return this.stack[this.sp--];
    }

    @Override
    final void pushVariable(int n) {
        this.stack[++this.sp] = this.vars[n];
    }

    @Override
    public final void pushConstant(int n) {
        this.stack[++this.sp] = this.cnst[n];
    }

    final void add() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] + d;
    }

    final void sub() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] - d;
    }

    final void neg() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = -d;
    }

    final void recroprical() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = 1.0 / d;
    }

    protected final void mulS() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] * d;
    }

    void divS() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] / d;
    }

    final void mod() {
        double d = this.stack[this.sp--];
        int n = this.sp;
        this.stack[n] = this.stack[n] % d;
    }

    final void pow() {
        double d;
        short s = (short)d;
        if ((d = this.stack[this.sp--]) == (double)s) {
            if (d >= 0.0) {
                this.powN(s);
                return;
            }
            this.powN(-s);
            this.recroprical();
            return;
        }
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = Math.pow(d2, d);
    }

    final void powN(short s) {
        double d = this.stack[this.sp];
        switch (s) {
            case 0: {
                d = 1.0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                d *= d;
                break;
            }
            case 3: {
                d *= d * d;
                break;
            }
            case 4: {
                double d2 = d * d;
                d = d2 * d2;
                break;
            }
            case 5: {
                double d3 = d * d;
                d *= d3 * d3;
                break;
            }
            case 6: {
                double d4 = d * d;
                double d5 = d4 * d4;
                d = d4 * d5;
                break;
            }
            case 7: {
                double d6 = d * d;
                double d7 = d6 * d6;
                d *= d6 * d7;
                break;
            }
            case 8: {
                double d8 = d * d;
                double d9 = d8 * d8;
                d = d9 * d9;
                break;
            }
            default: {
                short s2 = s;
                double d10 = d;
                double d11 = (s2 & 1) != 0 ? d : 1.0;
                for (s2 = (short)(s2 >>> 1); s2 != 0; s2 = (short)(s2 >>> 1)) {
                    d10 *= d10;
                    if ((s2 & 1) == 0) continue;
                    d11 *= d10;
                }
                d = d11;
            }
        }
        this.stack[this.sp] = d;
    }

    @Override
    final void assign(int n) {
        this.vars[n] = this.stack[this.sp];
    }

    final void and() {
        double d = this.stack[this.sp--];
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != 0.0 && d != 0.0 ? 1.0 : 0.0;
    }

    final void or() {
        double d = this.stack[this.sp--];
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != 0.0 || d != 0.0 ? 1.0 : 0.0;
    }

    final void not() {
        double d = this.stack[this.sp];
        this.stack[this.sp] = d == 0.0 ? 1.0 : 0.0;
    }

    final void lt() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 < (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    final void gt() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 > (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    final void le() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 <= (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    final void ge() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 >= (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    final void eq() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 == (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    @Override
    final void ne() {
        double d;
        double d2 = this.stack[this.sp];
        this.stack[this.sp] = d2 != (d = this.stack[this.sp--]) ? 1.0 : 0.0;
    }

    short addConstant(double d) {
        for (short s = 0; s < this.cnst.length; s = (short)(s + 1)) {
            if (d != this.cnst[s]) continue;
            return s;
        }
        double[] dArray = new double[this.cnst.length + 1];
        System.arraycopy(this.cnst, 0, dArray, 0, this.cnst.length);
        dArray[this.cnst.length] = d;
        this.cnst = dArray;
        return (short)(this.cnst.length - 1);
    }

    double getConstant(int n) {
        return this.cnst[n];
    }

    void setVarValue(int n, double d) {
        this.vars[n] = d;
    }

    @Override
    void removeVarAt(int n) {
        this.vars[n] = Double.NaN;
    }

    @Override
    MrpRes getVarValue(int n) {
        if (this.getJepVariable(n) == null) {
            return null;
        }
        return new ScalerObj(this.vars[n]);
    }

    @Override
    void modifyVarDim(int n, Dimensions dimensions) {
    }

    int getNConst() {
        return this.cnst.length;
    }

    @Override
    int getNVars() {
        return this.vars.length;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("Constants");
        stringBuilder.append(ls);
        int n = this.getNConst();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(i);
            stringBuilder.append('\t');
            stringBuilder.append(this.getConstant((short)i));
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    void popN(int n, Stack<Object> stack) {
        this.sp -= n;
        for (int i = 1; i <= n; ++i) {
            stack.push(this.stack[this.sp + i]);
        }
    }

    @Override
    Dimensions getStoreDimensions() {
        return Dimensions.ONE;
    }
}

