/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.fastreal;

import com.singularsys.extensions.fastreal.AbstractEval;
import com.singularsys.extensions.fastreal.RpCommand;
import com.singularsys.extensions.fastreal.RpCommandList;
import com.singularsys.extensions.fastreal.RpConstants;
import com.singularsys.extensions.fastreal.ScalerStore;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.reals.RealBinaryFunction;
import com.singularsys.jep.reals.RealNaryFunction;
import com.singularsys.jep.reals.RealNullaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import java.util.Map;
import java.util.Stack;

public final class RpEval
extends AbstractEval {
    private static final long serialVersionUID = 330L;
    private ScalerStore scalerStore = null;
    private RpCommandList curCommandList;
    static final double[] nullaryArgs = new double[0];
    static final Double[] nullArgsD = new Double[0];
    private final Stack<Object> pfmcStack = new Stack();
    final double[] unaryArgs = new double[1];
    final Double[] unaryArgsD = new Double[1];
    final double[] binaryArgs = new double[2];
    final Double[] binaryArgsD = new Double[2];
    final double[] triArgs = new double[3];
    final Double[] triArgsD = new Double[3];
    final double[] quartArgs = new double[4];
    final Double[] quartArgsD = new Double[4];

    public RpEval(Jep jep) {
        super(jep);
        this.scalerStore = new ScalerStore();
    }

    public final RpCommandList compile(Node node) throws JepException {
        this.scalerStore.reset();
        this.curCommandList = new RpCommandList();
        node.jjtAccept(this, null);
        this.scalerStore.alloc();
        return this.curCommandList;
    }

    @Override
    public final Object visit(ASTConstant aSTConstant, Object object) throws JepException {
        Object object2 = aSTConstant.getValue();
        this.scalerStore.incStack();
        short s = this.scalerStore.addConstant(object2);
        this.curCommandList.addCommand((short)0, s);
        return null;
    }

    @Override
    public final Object visit(ASTVarNode aSTVarNode, Object object) throws JepException {
        Variable variable = aSTVarNode.getVar();
        short s = (short)this.scalerStore.addVar(variable);
        this.scalerStore.incStack();
        this.curCommandList.addCommand((short)1, s);
        return null;
    }

    @Override
    public final Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        Operator operator = aSTOpNode.getOperator();
        if (operator != this.opSet.getAssign() && operator != this.opSet.getPower()) {
            aSTOpNode.childrenAccept(this, null);
        }
        if (operator == this.opSet.getAdd()) {
            this.curCommandList.addCommand((short)2);
            this.scalerStore.decStack();
            return null;
        }
        if (operator == this.opSet.getSubtract()) {
            this.curCommandList.addCommand((short)3);
            this.scalerStore.decStack();
            return null;
        }
        if (operator == this.opSet.getUMinus()) {
            this.curCommandList.addCommand((short)21);
            return null;
        }
        if (operator == this.opSet.getMultiply()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)4);
            return null;
        }
        if (operator == this.opSet.getAssign()) {
            Node node = aSTOpNode.jjtGetChild(1);
            node.jjtAccept(this, null);
            Variable variable = ((ASTVarNode)aSTOpNode.jjtGetChild(0)).getVar();
            short s = (short)this.scalerStore.addVar(variable);
            if (!this.opSet.getAssign().equals(node.getOperator())) {
                this.scalerStore.decStack();
            }
            this.curCommandList.addCommand((short)20, s);
            return null;
        }
        if (operator == this.opSet.getEQ()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)16);
            return null;
        }
        if (operator == this.opSet.getNE()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)15);
            return null;
        }
        if (operator == this.opSet.getLT()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)11);
            return null;
        }
        if (operator == this.opSet.getGT()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)13);
            return null;
        }
        if (operator == this.opSet.getLE()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)12);
            return null;
        }
        if (operator == this.opSet.getGE()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)14);
            return null;
        }
        if (operator == this.opSet.getAnd()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)8);
            return null;
        }
        if (operator == this.opSet.getOr()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)9);
            return null;
        }
        if (operator == this.opSet.getNot()) {
            this.curCommandList.addCommand((short)10);
            return null;
        }
        if (operator == this.opSet.getDivide()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)5);
            return null;
        }
        if (operator == this.opSet.getMod()) {
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)6);
            return null;
        }
        if (operator == this.opSet.getPower()) {
            Object object2;
            Node node = aSTOpNode.jjtGetChild(0);
            Node node2 = aSTOpNode.jjtGetChild(1);
            node.jjtAccept(this, null);
            if (node2 instanceof ASTConstant && (object2 = ((ASTConstant)node2).getValue()) instanceof Number) {
                double d = ((Number)object2).doubleValue();
                short s = ((Number)object2).shortValue();
                if (d >= 0.0 && d == (double)s) {
                    this.curCommandList.addCommand((short)22, s);
                    return null;
                }
                if (d == (double)s) {
                    this.curCommandList.addCommand((short)22, -s);
                    this.curCommandList.addCommand((short)23);
                    return null;
                }
            }
            node2.jjtAccept(this, null);
            this.scalerStore.decStack();
            this.curCommandList.addCommand((short)7);
            return null;
        }
        throw new ParseException("RpeEval: Sorry unsupported operator: " + aSTOpNode.getName());
    }

    @Override
    public final Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        int n = aSTFunNode.jjtGetNumChildren();
        aSTFunNode.childrenAccept(this, null);
        short s = this.getUserFunction(aSTFunNode.getName(), aSTFunNode.getPFMC());
        this.curCommandList.addCommand((short)(50 + n), s);
        if (n == 0) {
            this.scalerStore.incStack();
        } else if (n != 1) {
            if (n == 2) {
                this.scalerStore.decStack();
            } else {
                for (int i = 2; i < n; ++i) {
                    this.scalerStore.decStack();
                }
            }
        }
        return null;
    }

    public final double evaluate(RpCommandList rpCommandList) throws EvaluationException {
        this.scalerStore.reset();
        int n = rpCommandList.getNumCommands();
        block28: for (int n2 = 0; n2 < n; n2 = (int)((short)(n2 + 1))) {
            RpCommand rpCommand = rpCommandList.commands[n2];
            short s = rpCommand.aux1;
            switch (rpCommand.command) {
                case 0: {
                    this.scalerStore.pushConstant(s);
                    continue block28;
                }
                case 1: {
                    this.scalerStore.pushVariable(s);
                    continue block28;
                }
                case 2: {
                    this.scalerStore.add();
                    continue block28;
                }
                case 3: {
                    this.scalerStore.sub();
                    continue block28;
                }
                case 4: {
                    this.scalerStore.mul();
                    continue block28;
                }
                case 5: {
                    this.scalerStore.div();
                    continue block28;
                }
                case 6: {
                    this.scalerStore.mod();
                    continue block28;
                }
                case 7: {
                    this.scalerStore.pow();
                    continue block28;
                }
                case 8: {
                    this.scalerStore.and();
                    continue block28;
                }
                case 9: {
                    this.scalerStore.or();
                    continue block28;
                }
                case 10: {
                    this.scalerStore.not();
                    continue block28;
                }
                case 11: {
                    this.scalerStore.lt();
                    continue block28;
                }
                case 12: {
                    this.scalerStore.le();
                    continue block28;
                }
                case 13: {
                    this.scalerStore.gt();
                    continue block28;
                }
                case 14: {
                    this.scalerStore.ge();
                    continue block28;
                }
                case 15: {
                    this.scalerStore.ne();
                    continue block28;
                }
                case 16: {
                    this.scalerStore.eq();
                    continue block28;
                }
                case 20: {
                    this.scalerStore.assign(s);
                    continue block28;
                }
                case 21: {
                    this.scalerStore.neg();
                    continue block28;
                }
                case 22: {
                    this.scalerStore.powN(s);
                    continue block28;
                }
                case 23: {
                    this.scalerStore.recroprical();
                    continue block28;
                }
                case 50: {
                    this.nullaryFunction(s);
                    continue block28;
                }
                case 51: {
                    this.unitaryFunction(s);
                    continue block28;
                }
                case 52: {
                    this.binaryFunction(s);
                    continue block28;
                }
                case 53: {
                    this.trianaryFunction(s);
                    continue block28;
                }
                case 54: {
                    this.quarteraryFunction(s);
                    continue block28;
                }
                default: {
                    this.naryFunction(s, rpCommand.command - 50);
                }
            }
        }
        return this.scalerStore.popDouble();
    }

    private final void nullaryFunction(short s) throws EvaluationException {
        double d;
        int n = s - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
        if (postfixMathCommandI instanceof RealNullaryFunction) {
            d = ((RealNullaryFunction)((Object)postfixMathCommandI)).evaluate();
        } else if (postfixMathCommandI instanceof RealNaryFunction) {
            double[] dArray = new double[]{};
            d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(dArray);
        } else if (postfixMathCommandI instanceof NaryFunction) {
            d = (Double)((NaryFunction)postfixMathCommandI).eval(nullArgsD);
        } else {
            postfixMathCommandI.setCurNumberOfParameters(0);
            postfixMathCommandI.run(this.pfmcStack);
            d = ((Number)this.pfmcStack.pop()).doubleValue();
        }
        this.scalerStore.pushDouble(d);
    }

    private final void unitaryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        switch (s) {
            case 1: {
                d = Math.sin(d);
                break;
            }
            case 2: {
                d = Math.cos(d);
                break;
            }
            case 3: {
                d = Math.tan(d);
                break;
            }
            case 4: {
                d = Math.asin(d);
                break;
            }
            case 5: {
                d = Math.acos(d);
                break;
            }
            case 6: {
                d = Math.atan(d);
                break;
            }
            case 7: {
                d = (Math.exp(d) - Math.exp(-d)) / 2.0;
                break;
            }
            case 8: {
                d = (Math.exp(d) + Math.exp(-d)) / 2.0;
                break;
            }
            case 9: {
                double d2 = Math.exp(d * 2.0);
                d = (d2 - 1.0) / (d2 + 1.0);
                break;
            }
            case 10: {
                d = Math.log(d + Math.sqrt(1.0 + d * d));
                break;
            }
            case 11: {
                d = Math.log(d + Math.sqrt(d * d - 1.0));
                break;
            }
            case 12: {
                d = Math.log((1.0 + d) / (1.0 - d)) / 2.0;
                break;
            }
            case 13: {
                d = Math.abs(d);
                break;
            }
            case 14: {
                d = Math.exp(d);
                break;
            }
            case 15: {
                d = Math.log(d) / RpConstants.LOG10;
                break;
            }
            case 16: {
                d = Math.log(d);
                break;
            }
            case 17: {
                d = Math.sqrt(d);
                break;
            }
            case 18: {
                d = 1.0 / Math.cos(d);
                break;
            }
            case 19: {
                d = 1.0 / Math.sin(d);
                break;
            }
            case 20: {
                d = 1.0 / Math.tan(d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealUnaryFunction) {
                    d = ((RealUnaryFunction)((Object)postfixMathCommandI)).evaluate(d);
                    break;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.unaryArgs[0] = d;
                    d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.unaryArgs);
                    break;
                }
                if (postfixMathCommandI instanceof UnaryFunction) {
                    d = (Double)((UnaryFunction)postfixMathCommandI).eval(d);
                    break;
                }
                if (postfixMathCommandI instanceof NaryBinaryFunction) break;
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.unaryArgsD[0] = d;
                    d = (Double)((NaryFunction)postfixMathCommandI).eval(this.unaryArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(1);
                this.pfmcStack.push(new Double(d));
                postfixMathCommandI.run(this.pfmcStack);
                d = ((Number)this.pfmcStack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d);
    }

    private final void binaryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        switch (s) {
            case 21: {
                d = Math.atan2(d2, d);
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealBinaryFunction) {
                    d = ((RealBinaryFunction)((Object)postfixMathCommandI)).evaluate(d2, d);
                    break;
                }
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.binaryArgs[0] = d2;
                    this.binaryArgs[1] = d;
                    d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.binaryArgs);
                    break;
                }
                if (postfixMathCommandI instanceof BinaryFunction) {
                    d = ((Number)((BinaryFunction)postfixMathCommandI).eval(d2, d)).doubleValue();
                    break;
                }
                if (postfixMathCommandI instanceof NaryBinaryFunction) {
                    d = ((Number)((NaryBinaryFunction)postfixMathCommandI).eval(d2, d)).doubleValue();
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.binaryArgsD[0] = d2;
                    this.binaryArgsD[1] = d;
                    d = ((Number)((NaryFunction)postfixMathCommandI).eval(this.binaryArgsD)).doubleValue();
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(2);
                this.pfmcStack.push(new Double(d2));
                this.pfmcStack.push(new Double(d));
                postfixMathCommandI.run(this.pfmcStack);
                d = ((Number)this.pfmcStack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d);
    }

    private final void trianaryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        double d3 = this.scalerStore.popDouble();
        switch (s) {
            case 22: {
                d2 = !Double.isNaN(d3) ? (d3 > 0.0 ? d2 : d) : d3;
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.triArgs[0] = d3;
                    this.triArgs[1] = d2;
                    this.triArgs[2] = d;
                    d2 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.triArgs);
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.triArgsD[0] = d3;
                    this.triArgsD[1] = d2;
                    this.triArgsD[2] = d;
                    d2 = (Double)((NaryFunction)postfixMathCommandI).eval(this.triArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(3);
                this.pfmcStack.push(new Double(d3));
                this.pfmcStack.push(new Double(d2));
                this.pfmcStack.push(new Double(d));
                postfixMathCommandI.run(this.pfmcStack);
                d2 = ((Number)this.pfmcStack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d2);
    }

    private final void quarteraryFunction(short s) throws EvaluationException {
        double d = this.scalerStore.popDouble();
        double d2 = this.scalerStore.popDouble();
        double d3 = this.scalerStore.popDouble();
        double d4 = this.scalerStore.popDouble();
        switch (s) {
            case 22: {
                d3 = !Double.isNaN(d4) ? (d4 > 0.0 ? d3 : (d4 < 0.0 ? d2 : d)) : d4;
                break;
            }
            default: {
                int n = s - 23;
                PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n);
                if (postfixMathCommandI instanceof RealNaryFunction) {
                    this.quartArgs[0] = d4;
                    this.quartArgs[1] = d3;
                    this.quartArgs[2] = d2;
                    this.quartArgs[3] = d;
                    d3 = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(this.quartArgs);
                    break;
                }
                if (postfixMathCommandI instanceof NaryFunction) {
                    this.quartArgsD[0] = d4;
                    this.quartArgsD[1] = d3;
                    this.quartArgsD[2] = d2;
                    this.quartArgsD[3] = d;
                    d3 = (Double)((NaryFunction)postfixMathCommandI).eval(this.quartArgsD);
                    break;
                }
                postfixMathCommandI.setCurNumberOfParameters(4);
                this.pfmcStack.push(new Double(d4));
                this.pfmcStack.push(new Double(d3));
                this.pfmcStack.push(new Double(d2));
                this.pfmcStack.push(new Double(d));
                postfixMathCommandI.run(this.pfmcStack);
                d3 = ((Number)this.pfmcStack.pop()).doubleValue();
            }
        }
        this.scalerStore.pushDouble(d3);
    }

    private final void naryFunction(short s, int n) throws EvaluationException {
        int n2 = s - 23;
        PostfixMathCommandI postfixMathCommandI = (PostfixMathCommandI)this.customFunctionCommands.get(n2);
        if (postfixMathCommandI instanceof RealNaryFunction) {
            double[] dArray = new double[n];
            for (int i = n - 1; i >= 0; --i) {
                dArray[i] = this.scalerStore.popDouble();
            }
            double d = ((RealNaryFunction)((Object)postfixMathCommandI)).evaluate(dArray);
            this.scalerStore.pushDouble(d);
        } else if (postfixMathCommandI instanceof NaryFunction) {
            Object[] objectArray = new Double[n];
            for (int i = n - 1; i >= 0; --i) {
                objectArray[i] = this.scalerStore.popDouble();
            }
            double d = (Double)((NaryFunction)postfixMathCommandI).eval(objectArray);
            this.scalerStore.pushDouble(d);
        } else {
            if (postfixMathCommandI instanceof CallbackEvaluationI) {
                throw new EvaluationException("Cannot use CallbackEvaluationI function " + postfixMathCommandI.getName() + " using rpe evaluation");
            }
            postfixMathCommandI.setCurNumberOfParameters(n);
            this.scalerStore.popN(n, this.pfmcStack);
            postfixMathCommandI.run(this.pfmcStack);
            double d = ((Number)this.pfmcStack.pop()).doubleValue();
            this.scalerStore.pushDouble(d);
        }
    }

    public void cleanUp() {
        this.scalerStore.cleanUp();
    }

    public Variable getVariable(int n) {
        return this.scalerStore.getJepVariable(n);
    }

    public int getVarRef(Variable variable) throws JepException {
        short s = (short)this.scalerStore.addVar(variable);
        return s;
    }

    public int getVarRef(String string) throws JepException {
        Variable variable = this.jep.getVariable(string);
        return this.getVarRef(variable);
    }

    public void setVarValue(int n, double d) {
        this.scalerStore.setVarValue(n, d);
    }

    public double getVarValue(int n) {
        return this.scalerStore.getVarValue(n);
    }

    public RpEval duplicate() {
        RpEval rpEval = null;
        rpEval = new RpEval(this.jep);
        rpEval.opSet = this.opSet;
        rpEval.scalerStore = this.scalerStore.duplicate();
        return rpEval;
    }

    public void updateJepVariables() {
        this.scalerStore.updateJepVariables();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("RpEval");
        stringBuilder.append(ls);
        stringBuilder.append(this.scalerStore.toString());
        stringBuilder.append("Functions");
        stringBuilder.append(ls);
        for (Map.Entry entry : this.functionHash.entrySet()) {
            stringBuilder.append(entry.getValue());
            stringBuilder.append('\t');
            stringBuilder.append((String)entry.getKey());
            stringBuilder.append(ls);
        }
        return stringBuilder.toString();
    }

    @Override
    protected Object getConstantValue(short s) {
        return this.scalerStore.getConstant(s);
    }

    static String staticToString(RpCommand rpCommand) {
        switch (rpCommand.command) {
            case 0: {
                return "Constant\tnum " + rpCommand.aux1;
            }
            case 1: {
                return "Variable\tnum " + rpCommand.aux1;
            }
            case 2: {
                return "ADD";
            }
            case 3: {
                return "SUB";
            }
            case 4: {
                return "MUL";
            }
            case 5: {
                return "DIV";
            }
            case 6: {
                return "MOD";
            }
            case 7: {
                return "POW";
            }
            case 8: {
                return "AND";
            }
            case 9: {
                return "OR";
            }
            case 10: {
                return "NOT";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "LE";
            }
            case 13: {
                return "GT";
            }
            case 14: {
                return "GE";
            }
            case 16: {
                return "EQ";
            }
            case 15: {
                return "NE";
            }
            case 20: {
                return "Assign\t\tnum " + rpCommand.aux1;
            }
            case 21: {
                return "Unitary minus";
            }
            case 22: {
                return "POWN\t\t" + rpCommand.aux1;
            }
            case 23: {
                return "1/x";
            }
            case 50: {
                return "Nullary Function\tnum " + rpCommand.aux1;
            }
            case 51: {
                return "Function\tnum " + rpCommand.aux1;
            }
            case 52: {
                return "Binary function\tnum " + rpCommand.aux1;
            }
            case 53: {
                return "Trianary function\tnum " + rpCommand.aux1;
            }
            case 54: {
                return "Quaternary function\tnum " + rpCommand.aux1;
            }
        }
        return "Nary function\tnum " + rpCommand.aux1;
    }

    public String toString(RpCommand rpCommand) {
        switch (rpCommand.command) {
            case 0: {
                return "Constant\tnum " + rpCommand.aux1 + "\tval " + this.getConstantValue(rpCommand.getRef());
            }
            case 1: {
                return "Variable\tnum " + rpCommand.aux1 + "\t" + this.getVariable(rpCommand.aux1).getName();
            }
            case 2: {
                return "ADD";
            }
            case 3: {
                return "SUB";
            }
            case 4: {
                return "MUL";
            }
            case 5: {
                return "DIV";
            }
            case 6: {
                return "MOD";
            }
            case 7: {
                return "POW";
            }
            case 8: {
                return "AND";
            }
            case 9: {
                return "OR";
            }
            case 10: {
                return "NOT";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "LE";
            }
            case 13: {
                return "GT";
            }
            case 14: {
                return "GE";
            }
            case 16: {
                return "EQ";
            }
            case 15: {
                return "NE";
            }
            case 20: {
                return "Assign\t\tnum " + rpCommand.aux1 + "\t" + this.getVariable(rpCommand.aux1).getName();
            }
            case 21: {
                return "Unitary minus";
            }
            case 22: {
                return "POWN\t\t" + rpCommand.aux1;
            }
            case 23: {
                return "1/x";
            }
            case 50: {
                return "Nullary Function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
            }
            case 51: {
                return "Function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
            }
            case 52: {
                return "Binary function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
            }
            case 53: {
                return "Trianary function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
            }
            case 54: {
                return "Nary function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
            }
        }
        return "Nary function\tnum " + rpCommand.aux1 + "\t" + this.getFunction(rpCommand.getRef());
    }
}

