/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.functions;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.functions.FieldPower;
import com.singularsys.extensions.field.functions.FieldSqrt;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.functions.Abs;
import com.singularsys.jep.functions.ArcCosine;
import com.singularsys.jep.functions.ArcCosineH;
import com.singularsys.jep.functions.ArcSine;
import com.singularsys.jep.functions.ArcSineH;
import com.singularsys.jep.functions.ArcTanH;
import com.singularsys.jep.functions.ArcTangent;
import com.singularsys.jep.functions.Arg;
import com.singularsys.jep.functions.ComplexPFMC;
import com.singularsys.jep.functions.Conjugate;
import com.singularsys.jep.functions.Cosecant;
import com.singularsys.jep.functions.Cosine;
import com.singularsys.jep.functions.CosineH;
import com.singularsys.jep.functions.Cotangent;
import com.singularsys.jep.functions.Exp;
import com.singularsys.jep.functions.If;
import com.singularsys.jep.functions.Imaginary;
import com.singularsys.jep.functions.LogBase2;
import com.singularsys.jep.functions.Logarithm;
import com.singularsys.jep.functions.NaturalLogarithm;
import com.singularsys.jep.functions.Polar;
import com.singularsys.jep.functions.Real;
import com.singularsys.jep.functions.Secant;
import com.singularsys.jep.functions.Sine;
import com.singularsys.jep.functions.SineH;
import com.singularsys.jep.functions.SquareRoot;
import com.singularsys.jep.functions.TanH;
import com.singularsys.jep.functions.Tangent;

public class ComplexFunctionTable
extends FunctionTable {
    private static final long serialVersionUID = 350L;

    public ComplexFunctionTable(boolean bl, FieldI fieldI) {
        this.addFunction("sin", new Sine());
        this.addFunction("cos", new Cosine());
        this.addFunction("tan", new Tangent());
        this.addFunction("asin", new ArcSine());
        this.addFunction("acos", new ArcCosine());
        this.addFunction("atan", new ArcTangent());
        this.addFunction("cosec", new Cosecant());
        this.addFunction("sec", new Secant());
        this.addFunction("cot", new Cotangent());
        this.addFunction("sinh", new SineH());
        this.addFunction("cosh", new CosineH());
        this.addFunction("tanh", new TanH());
        this.addFunction("asinh", new ArcSineH());
        this.addFunction("acosh", new ArcCosineH());
        this.addFunction("atanh", new ArcTanH());
        this.addFunction("log", new Logarithm());
        this.addFunction("ln", new NaturalLogarithm());
        this.addFunction("lg", new LogBase2());
        this.addFunction("exp", new Exp());
        this.addFunction("sqrt", new FieldSqrt(fieldI, 10));
        this.addFunction("pow", new FieldPower(fieldI));
        if (!bl) {
            this.addFunction("re", new Real());
            this.addFunction("im", new Imaginary());
            this.addFunction("arg", new Arg());
            this.addFunction("cmod", new Abs());
            this.addFunction("complex", new ComplexPFMC());
            this.addFunction("polar", new Polar());
        }
        this.addFunction("conj", new Conjugate());
        this.addFunction("sqrt", new SquareRoot());
        this.addFunction("if", new If());
    }
}

