/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.extensions.field.implementations.GenericPowerField;
import com.singularsys.extensions.field.implementations.PowerImplementations;
import com.singularsys.jep.EvaluationException;

public class ExactIntegerField
extends GenericPowerField<Integer> {
    private static final long serialVersionUID = 350L;
    boolean checkDivide;

    public ExactIntegerField(boolean bl) {
        super(0, 1);
        this.checkDivide = bl;
    }

    @Override
    public Integer cast(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return null;
    }

    @Override
    public Integer addG(Integer n, Integer n2) throws EvaluationException {
        try {
            int n3 = Math.addExact(n, n2);
            return n3;
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public Integer subG(Integer n, Integer n2) throws EvaluationException {
        try {
            int n3 = Math.subtractExact(n, n2);
            return n3;
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public Integer negG(Integer n) throws EvaluationException {
        try {
            int n2 = Math.negateExact(n);
            return n2;
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public Integer mulG(Integer n, Integer n2) throws EvaluationException {
        try {
            int n3 = Math.multiplyExact(n, (int)n2);
            return n3;
        }
        catch (ArithmeticException arithmeticException) {
            throw new EvaluationException(arithmeticException);
        }
    }

    @Override
    public Integer divG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n;
        int n4 = n2;
        if (n4 == 0) {
            throw new EvaluationException(new ArithmeticException("div: division by zero"));
        }
        if (n3 == Integer.MIN_VALUE && n4 == -1) {
            throw new EvaluationException(new ArithmeticException("div: overflow " + n3 + "/" + n4));
        }
        if (this.checkDivide && n3 % n4 != 0) {
            throw new EvaluationException("Inexact division " + n3 + "/" + n4);
        }
        return n3 / n4;
    }

    @Override
    public Integer modG(Integer n, Integer n2) throws EvaluationException {
        int n3 = n;
        int n4 = n2;
        if (n4 == 0) {
            throw new EvaluationException(new ArithmeticException("mod: division by zero"));
        }
        return n3 % n4;
    }

    @Override
    public Integer powG(Integer n, Integer n2) throws EvaluationException {
        int n3;
        int n4 = n;
        int n5 = n2;
        if (n4 == 0 && n5 > 0) {
            return 0;
        }
        if (n4 == 0 && n5 <= 0) {
            throw new EvaluationException(new ArithmeticException("Pow: Overflow: " + n4 + "^" + n5));
        }
        if (n5 == 0) {
            return 1;
        }
        if (n5 == 1) {
            return n;
        }
        if (n4 == 1) {
            return 1;
        }
        if (n4 == -1) {
            boolean bl = (n5 & 1) == 0;
            return bl ? 1 : -1;
        }
        if (n5 < 0) {
            return 0;
        }
        int n6 = 31 - Integer.numberOfLeadingZeros(n4 > 0 ? n4 : -n4);
        int n7 = n6 * n5;
        if (n7 > 32 || n7 < 0) {
            throw new EvaluationException(new ArithmeticException("Pow: Overflow: " + n4 + "^" + n5));
        }
        if (n7 + n5 <= 30) {
            int n8 = PowerImplementations.intpower(n4, n5);
            return n8;
        }
        long l = PowerImplementations.longpower(n4, n5);
        if (l == (long)(n3 = (int)l)) {
            return n3;
        }
        throw new EvaluationException(new ArithmeticException("Pow: Overflow: " + n4 + "^" + n5 + "=" + l + " " + Long.toHexString(l)));
    }

    @Override
    public Integer cmpG(Integer n, Integer n2) throws EvaluationException {
        return n.compareTo(n2);
    }

    @Override
    public Integer powNonInt(Integer n, Integer n2) throws EvaluationException {
        return this.powG(n, n2);
    }

    @Override
    protected Integer powI(Integer n, Integer n2) throws EvaluationException {
        return this.powG(n, n2);
    }

    @Override
    public Integer getOne() {
        return 1;
    }

    @Override
    public Integer getZero() {
        return 0;
    }

    @Override
    public Integer convertToIntE(Integer n) throws EvaluationException {
        return n;
    }

    @Override
    public Integer convertFromInt(Integer n) throws EvaluationException {
        return n;
    }
}

