/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.field.implementations;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.standard.Complex;

public class IntegerNumberFactory
implements NumberFactory {
    private static final long serialVersionUID = 330L;
    public static final Integer MINUS_ONE = -1;
    public static final Integer ONE = 1;
    public static final Integer TWO = 2;
    public static final Integer ZERO = 0;

    @Override
    public Object createNumber(String string) throws ParseException {
        Integer n;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException);
        }
        return n;
    }

    @Override
    public Object createNumber(double d) throws ParseException {
        int n = (int)d;
        if ((double)n == d) {
            return n;
        }
        throw new ParseException(new NumberFormatException("Cannot convert " + d + " to an integer"));
    }

    @Override
    public Object createNumber(int n) throws ParseException {
        return n;
    }

    @Override
    public Object createNumber(short s) throws ParseException {
        return (int)s;
    }

    @Override
    public Object createNumber(long l) throws ParseException {
        int n = (int)l;
        if ((long)n == l) {
            return n;
        }
        throw new ParseException(new NumberFormatException("Cannot convert " + l + " to an integer"));
    }

    @Override
    public Object createNumber(float f) throws ParseException {
        return this.createNumber((double)f);
    }

    @Override
    public Object createNumber(boolean bl) throws ParseException {
        return bl;
    }

    @Override
    public Object createNumber(Number number) throws ParseException {
        if (number instanceof Integer) {
            return number;
        }
        if (number instanceof Short) {
            return this.createNumber((Short)number);
        }
        if (number instanceof Long) {
            return this.createNumber((Long)number);
        }
        if (number instanceof Double) {
            return this.createNumber((Double)number);
        }
        if (number instanceof Float) {
            return this.createNumber(((Float)number).floatValue());
        }
        throw new ParseException(new NumberFormatException("Cannot convert " + number + " to an integer"));
    }

    @Override
    public Object createNumber(Complex complex) throws ParseException {
        return complex;
    }

    @Override
    public Object getMinusOne() {
        return MINUS_ONE;
    }

    @Override
    public Object getOne() {
        return ONE;
    }

    @Override
    public Object getTwo() {
        return TWO;
    }

    @Override
    public Object getZero() {
        return ZERO;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }

    @Override
    public void init(Jep jep) {
    }
}

