/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.matrix.genericmat;

import com.singularsys.extensions.matrix.MatrixFieldI;
import com.singularsys.extensions.matrix.MatrixI;
import com.singularsys.extensions.matrix.VectorI;
import com.singularsys.extensions.matrix.genericmat.GenericMatrix;
import com.singularsys.extensions.matrix.genericmat.GenericMatrixFactory;
import com.singularsys.extensions.matrix.genericmat.GenericVector;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;

public abstract class GenericMatrixField<E>
implements MatrixFieldI {
    private static final long serialVersionUID = 330L;
    protected GenericMatrixFactory<E> mf;
    final boolean skipElements;

    public GenericMatrixField(GenericMatrixFactory<E> genericMatrixFactory) {
        this.mf = genericMatrixFactory;
        this.skipElements = false;
    }

    public GenericMatrixField(GenericMatrixFactory<E> genericMatrixFactory, boolean bl) {
        this.mf = genericMatrixFactory;
        this.skipElements = bl;
    }

    protected abstract E addEle(E var1, E var2) throws EvaluationException;

    protected abstract E subEle(E var1, E var2) throws EvaluationException;

    protected abstract E negEle(E var1) throws EvaluationException;

    protected abstract E mulEle(E var1, E var2) throws EvaluationException;

    protected abstract E modEle(E var1, E var2) throws EvaluationException;

    protected abstract E divEle(E var1, E var2) throws EvaluationException;

    protected abstract E powEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean eqEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean neEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean ltEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean leEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean gtEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean geEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean andEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean orEle(E var1, E var2) throws EvaluationException;

    protected abstract Boolean notEle(E var1) throws EvaluationException;

    @Override
    public Object add(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
            if (genericVector.getNEles() != genericVector2.getNEles()) {
                throw new EvaluationException("Add: Vector sizes do not match " + genericVector + " " + genericVector2);
            }
            return this.add(genericVector, genericVector2);
        }
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object2);
            if (genericMatrix.getNRows() != genericMatrix2.getNRows() || genericMatrix.getNCols() != genericMatrix2.getNCols()) {
                throw new EvaluationException("Add: Matrix sizes do not match " + genericMatrix + " " + genericMatrix2);
            }
            return this.add(genericMatrix, genericMatrix2);
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.addEle(e, e2);
    }

    protected GenericVector<E> add(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericVector.getNEles());
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i] = this.addEle(genericVector.getEle(i), genericVector2.getEle(i));
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    protected GenericMatrix<E> add(GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix.getNCols());
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                objectArray[i][j] = this.addEle(genericMatrix.getEle(i, j), genericMatrix2.getEle(i, j));
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    @Override
    public Object sub(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object2);
            if (genericMatrix.getNRows() != genericMatrix2.getNRows() || genericMatrix.getNCols() != genericMatrix2.getNCols()) {
                throw new EvaluationException("Sub: Matrix sizes do not match " + genericMatrix + " " + genericMatrix2);
            }
            return this.sub(genericMatrix, genericMatrix2);
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
            if (genericVector.getNEles() != genericVector2.getNEles()) {
                throw new EvaluationException("Sub: Vector sizes do not match " + genericVector + " " + genericVector2);
            }
            return this.sub(genericVector, genericVector2);
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.subEle(e, e2);
    }

    protected GenericMatrix<E> sub(GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix.getNCols());
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                objectArray[i][j] = this.subEle(genericMatrix.getEle(i, j), genericMatrix2.getEle(i, j));
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    protected GenericVector<E> sub(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericVector.getNEles());
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i] = this.subEle(genericVector.getEle(i), genericVector2.getEle(i));
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    @Override
    public Object neg(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.neg(genericMatrix);
        }
        if (object instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            return this.neg(genericVector);
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        if (e == null) {
            return null;
        }
        return this.negEle(e);
    }

    protected GenericMatrix<E> neg(GenericMatrix<E> genericMatrix) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix.getNCols());
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                objectArray[i][j] = this.negEle(genericMatrix.getEle(i, j));
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    protected GenericVector<E> neg(GenericVector<E> genericVector) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericVector.getNEles());
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i] = this.negEle(genericVector.getEle(i));
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    @Override
    public Object mul(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI && object2 instanceof VectorI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            GenericVector<E> genericVector = this.mf.cast((VectorI)object2);
            if (genericMatrix.getNCols() != genericVector.getNEles()) {
                throw new EvaluationException("Mul: Matrix sizes do not match " + genericMatrix + " " + genericVector);
            }
            return this.mul(genericMatrix, genericVector);
        }
        if (object instanceof VectorI && object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object2);
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            if (genericVector.getNEles() != genericMatrix.getNRows()) {
                throw new EvaluationException("Mul: Matrix sizes do not match " + genericVector + " " + genericMatrix);
            }
            return this.mul(genericVector, genericMatrix);
        }
        if (object instanceof MatrixI && object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object2);
            if (genericMatrix.getNCols() != genericMatrix2.getNRows()) {
                throw new EvaluationException("Matrix *, sizes do not match " + genericMatrix + " " + genericMatrix2);
            }
            return this.mul(genericMatrix, genericMatrix2);
        }
        if (object instanceof VectorI && object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
            if (genericVector.getNEles() != genericVector2.getNEles()) {
                throw new EvaluationException("Matrix *, sizes do not match " + genericVector + " " + genericVector2);
            }
            return this.mul(genericVector, genericVector2);
        }
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.mul(genericMatrix, object2);
        }
        if (object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object2);
            return this.mul(genericMatrix, object);
        }
        if (object instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            return this.mul(genericVector, object2);
        }
        if (object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object2);
            return this.mul(genericVector, object);
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.mulEle(e, e2);
    }

    protected GenericMatrix<E> mul(GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix2.getNCols());
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix2.getNCols(); ++j) {
                E e = this.mf.zeroEement();
                for (int k = 0; k < genericMatrix.getNCols(); ++k) {
                    e = this.addEle(e, this.mulEle(genericMatrix.getEle(i, k), genericMatrix2.getEle(k, j)));
                }
                objectArray[i][j] = e;
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    protected GenericVector<E> mul(GenericMatrix<E> genericMatrix, GenericVector<E> genericVector) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericMatrix.getNRows());
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            E e = this.mf.zeroEement();
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                e = this.addEle(e, this.mulEle(genericMatrix.getEle(i, j), genericVector.getEle(j)));
            }
            objectArray[i] = e;
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    protected GenericVector<E> mul(GenericVector<E> genericVector, GenericMatrix<E> genericMatrix) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericMatrix.getNCols());
        for (int i = 0; i < genericMatrix.getNCols(); ++i) {
            E e = this.mf.zeroEement();
            for (int j = 0; j < genericMatrix.getNRows(); ++j) {
                e = this.addEle(e, this.mulEle(genericVector.getEle(j), genericMatrix.getEle(j, i)));
            }
            objectArray[i] = e;
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    protected GenericMatrix<E> mul(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericVector.getNEles(), genericVector2.getNEles());
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            for (int j = 0; j < genericVector2.getNEles(); ++j) {
                objectArray[i][j] = this.mulEle(genericVector.getEle(i), genericVector2.getEle(j));
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    protected GenericMatrix<E> mul(GenericMatrix<E> genericMatrix, Object object) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix.getNCols());
        E e = this.mf.elementValue(object);
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                objectArray[i][j] = this.mulEle(genericMatrix.getEle(i, j), e);
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    protected GenericVector<E> mul(GenericVector<E> genericVector, Object object) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericVector.getNEles());
        E e = this.mf.elementValue(object);
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i] = this.mulEle(genericVector.getEle(i), e);
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    @Override
    public Object div(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            return this.div(genericVector, object2);
        }
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.div(genericMatrix, object2);
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.divEle(e, e2);
    }

    protected GenericVector<E> div(GenericVector<E> genericVector, Object object) throws EvaluationException {
        Object[] objectArray = this.mf.buildDataArray(genericVector.getNEles());
        E e = this.mf.elementValue(object);
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i] = this.divEle(genericVector.getEle(i), e);
        }
        return this.mf.newVectorUnchecked(objectArray);
    }

    protected GenericMatrix<E> div(GenericMatrix<E> genericMatrix, Object object) throws EvaluationException {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNRows(), genericMatrix.getNCols());
        E e = this.mf.elementValue(object);
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                objectArray[i][j] = this.divEle(genericMatrix.getEle(i, j), e);
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    @Override
    public Object mod(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.modEle(e, e2);
    }

    @Override
    public Object pow(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.powEle(e, e2);
    }

    @Override
    public Boolean eq(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI) {
            if (object2 instanceof MatrixI) {
                GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
                GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object2);
                boolean bl = this.eq(genericMatrix, genericMatrix2);
                return bl;
            }
            return false;
        }
        if (object instanceof VectorI) {
            if (object2 instanceof VectorI) {
                GenericVector<E> genericVector = this.mf.cast((VectorI)object);
                GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
                boolean bl = this.eq(genericVector, genericVector2);
                return bl;
            }
            return false;
        }
        if (object2 instanceof MatrixI || object2 instanceof VectorI) {
            return false;
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.eqEle(e, e2);
    }

    @Override
    public Boolean ne(Object object, Object object2) throws EvaluationException {
        if (object instanceof MatrixI) {
            if (object2 instanceof MatrixI) {
                GenericMatrix<E> genericMatrix;
                GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object);
                boolean bl = !this.eq(genericMatrix2, genericMatrix = this.mf.cast((MatrixI)object2));
                return bl;
            }
            return true;
        }
        if (object instanceof VectorI) {
            if (object2 instanceof VectorI) {
                GenericVector<E> genericVector;
                GenericVector<E> genericVector2 = this.mf.cast((VectorI)object);
                boolean bl = !this.eq(genericVector2, genericVector = this.mf.cast((VectorI)object2));
                return bl;
            }
            return true;
        }
        if (object2 instanceof MatrixI || object2 instanceof VectorI) {
            return true;
        }
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        Boolean bl = this.eqEle(e, e2);
        if (bl == null) {
            return null;
        }
        return bl == false;
    }

    protected boolean eq(GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        for (int i = 0; i < genericMatrix.getNRows(); ++i) {
            for (int j = 0; j < genericMatrix.getNCols(); ++j) {
                E e;
                E e2 = genericMatrix.getEle(i, j);
                Boolean bl = this.eqEle(e2, e = genericMatrix2.getEle(i, j));
                if (bl == null) {
                    throw new EvaluationException("Matrix cannot compare elements " + e2 + " " + e);
                }
                if (bl.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean eq(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            E e;
            E e2 = genericVector.getEle(i);
            Boolean bl = this.eqEle(e2, e = genericVector2.getEle(i));
            if (bl == null) {
                throw new EvaluationException("Matrix cannot compare elements " + e2 + " " + e);
            }
            if (bl.booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Boolean gt(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.gtEle(e, e2);
    }

    @Override
    public Boolean ge(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.geEle(e, e2);
    }

    @Override
    public Boolean lt(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.ltEle(e, e2);
    }

    @Override
    public Boolean le(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.leEle(e, e2);
    }

    @Override
    public Boolean and(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.andEle(e, e2);
    }

    @Override
    public Boolean or(Object object, Object object2) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        E e2 = this.mf.elementValue(object2);
        if (e == null || e2 == null) {
            return null;
        }
        return this.orEle(e, e2);
    }

    @Override
    public Boolean not(Object object) throws EvaluationException {
        if (this.skipElements) {
            return null;
        }
        E e = this.mf.elementValue(object);
        if (e == null) {
            return null;
        }
        return this.notEle(e);
    }

    @Override
    public Object det(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            if (genericMatrix.getNRows() != genericMatrix.getNCols()) {
                throw new EvaluationException("det: must be a square matrix " + genericMatrix);
            }
            return this.det(genericMatrix);
        }
        return null;
    }

    protected E det(GenericMatrix<E> genericMatrix) throws EvaluationException {
        if (genericMatrix.getNRows() == 2) {
            E e = this.subEle(this.mulEle(genericMatrix.getEle(0, 0), genericMatrix.getEle(1, 1)), this.mulEle(genericMatrix.getEle(0, 1), genericMatrix.getEle(1, 0)));
            return e;
        }
        E e = this.mf.zeroEement();
        for (int i = 0; i < genericMatrix.getNCols(); ++i) {
            GenericMatrix<E> genericMatrix2 = this.minor(genericMatrix, 0, i);
            e = i % 2 == 0 ? this.addEle(e, this.mulEle(genericMatrix.getEle(0, i), this.det(genericMatrix2))) : this.subEle(e, this.mulEle(genericMatrix.getEle(0, i), this.det(genericMatrix2)));
        }
        return e;
    }

    @Override
    public Object trace(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.trace(genericMatrix);
        }
        return null;
    }

    public Object trace(GenericMatrix<E> genericMatrix) throws EvaluationException {
        int n;
        int n2 = genericMatrix.getNRows();
        int n3 = n2 < (n = genericMatrix.getNCols()) ? n2 : n;
        E e = genericMatrix.getEle(0, 0);
        for (int i = 1; i < n3; ++i) {
            e = this.addEle(e, genericMatrix.getEle(i, i));
        }
        return e;
    }

    protected GenericMatrix<E> minor(GenericMatrix<E> genericMatrix, int n, int n2) throws EvaluationException {
        int n3;
        int n4;
        int n5 = genericMatrix.getNCols();
        int n6 = genericMatrix.getNRows();
        Object[][] objectArray = this.mf.buildDataArray(n6 - 1, n5 - 1);
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n4][n3] = genericMatrix.getEle(n4, n3);
            }
            for (n3 = n2 + 1; n3 < n5; ++n3) {
                objectArray[n4][n3 - 1] = genericMatrix.getEle(n4, n3);
            }
        }
        for (n4 = n + 1; n4 < n6; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                objectArray[n4 - 1][n3] = genericMatrix.getEle(n4, n3);
            }
            for (n3 = n2 + 1; n3 < n5; ++n3) {
                objectArray[n4 - 1][n3 - 1] = genericMatrix.getEle(n4, n3);
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    @Override
    public Object trans(Object object) throws EvaluationException {
        if (object instanceof MatrixI) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.trans(genericMatrix);
        }
        return null;
    }

    protected GenericMatrix<E> trans(GenericMatrix<E> genericMatrix) {
        Object[][] objectArray = this.mf.buildDataArray(genericMatrix.getNCols(), genericMatrix.getNRows());
        for (int i = 0; i < genericMatrix.getNCols(); ++i) {
            for (int j = 0; j < genericMatrix.getNRows(); ++j) {
                objectArray[i][j] = genericMatrix.getEle(j, i);
            }
        }
        return this.mf.newMatrixUnchecked(objectArray);
    }

    @Override
    public Object dot(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
            if (genericVector.getNEles() != genericVector2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + genericVector + " " + genericVector2);
            }
            return this.dot(genericVector, genericVector2);
        }
        return null;
    }

    protected E dot(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        E e = this.mulEle(genericVector.getEle(0), genericVector2.getEle(0));
        for (int i = 1; i < genericVector.getNEles(); ++i) {
            e = this.addEle(e, this.mulEle(genericVector.getEle(i), genericVector2.getEle(i)));
        }
        return e;
    }

    @Override
    public Object cross(Object object, Object object2) throws EvaluationException {
        if (object instanceof VectorI && object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object);
            GenericVector<E> genericVector2 = this.mf.cast((VectorI)object2);
            if (genericVector.getNEles() != genericVector2.getNEles()) {
                throw new EvaluationException("Vector sizes do not match " + genericVector + " " + genericVector2);
            }
            if (genericVector.getNEles() != 3) {
                throw new EvaluationException("Cross product can only be performed for vectors of length 3, have " + genericVector + " " + genericVector2);
            }
            return this.cross(genericVector, genericVector2);
        }
        return null;
    }

    public Object cross(GenericVector<E> genericVector, GenericVector<E> genericVector2) throws EvaluationException {
        if (genericVector.getNEles() == 3) {
            Object[] objectArray = this.mf.buildDataArray(3);
            objectArray[0] = this.subEle(this.mulEle(genericVector.getEle(1), genericVector2.getEle(2)), this.mulEle(genericVector2.getEle(1), genericVector.getEle(2)));
            objectArray[1] = this.subEle(this.mulEle(genericVector.getEle(2), genericVector2.getEle(0)), this.mulEle(genericVector2.getEle(2), genericVector.getEle(0)));
            objectArray[2] = this.subEle(this.mulEle(genericVector.getEle(0), genericVector2.getEle(1)), this.mulEle(genericVector2.getEle(0), genericVector.getEle(1)));
            return this.mf.newVectorUnchecked(objectArray);
        }
        return null;
    }

    protected void swapRows(MatrixI matrixI, int n, int n2) throws EvaluationException {
        int n3 = matrixI.getNCols();
        for (int i = 0; i < n3; ++i) {
            Object object = matrixI.getEle(n, i);
            Object object2 = matrixI.getEle(n2, i);
            matrixI.setEle(n, i, object2);
            matrixI.setEle(n2, i, object);
        }
    }

    void mulRow(GenericMatrix<E> genericMatrix, int n, E e) throws EvaluationException {
        int n2 = genericMatrix.getNCols();
        for (int i = 0; i < n2; ++i) {
            genericMatrix.setEle(n, i, this.mulEle(genericMatrix.getEle(n, i), e));
        }
    }

    protected void subtractMul(GenericMatrix<E> genericMatrix, int n, int n2, E e) throws EvaluationException {
        int n3 = genericMatrix.getNCols();
        for (int i = 0; i < n3; ++i) {
            genericMatrix.setEle(n, i, this.subEle(genericMatrix.getEle(n, i), this.mulEle(genericMatrix.getEle(n2, i), e)));
        }
    }

    public abstract E getZero();

    public abstract E getOne();

    protected GenericMatrix<E> invMat(GenericMatrix<E> genericMatrix) throws EvaluationException {
        E e = this.det(genericMatrix);
        if (e == null) {
            throw new EvaluationException("Could not calculate the determinant of " + genericMatrix);
        }
        if (this.eqEle(e, this.getZero()).booleanValue()) {
            throw new EvaluationException("Cannot invert matrix with zero determinant " + genericMatrix);
        }
        int n = genericMatrix.getNRows();
        if (n == 2) {
            MatrixI matrixI = this.mf.identity(2);
            ((GenericMatrix)matrixI).setEle(0, 0, genericMatrix.getEle(1, 1));
            ((GenericMatrix)matrixI).setEle(0, 1, this.negEle(genericMatrix.getEle(0, 1)));
            ((GenericMatrix)matrixI).setEle(1, 0, this.negEle(genericMatrix.getEle(1, 0)));
            ((GenericMatrix)matrixI).setEle(1, 1, genericMatrix.getEle(0, 0));
            GenericMatrix<E> genericMatrix2 = this.div((GenericMatrix<E>)matrixI, (Object)e);
            return genericMatrix2;
        }
        if (n == 3) {
            E e2 = genericMatrix.getEle(0, 0);
            E e3 = genericMatrix.getEle(0, 1);
            E e4 = genericMatrix.getEle(0, 2);
            E e5 = genericMatrix.getEle(1, 0);
            E e6 = genericMatrix.getEle(1, 1);
            E e7 = genericMatrix.getEle(1, 2);
            E e8 = genericMatrix.getEle(2, 0);
            E e9 = genericMatrix.getEle(2, 1);
            E e10 = genericMatrix.getEle(2, 2);
            E e11 = this.subEle(this.mulEle(e6, e10), this.mulEle(e7, e9));
            E e12 = this.subEle(this.mulEle(e7, e8), this.mulEle(e5, e10));
            E e13 = this.subEle(this.mulEle(e5, e9), this.mulEle(e6, e8));
            E e14 = this.subEle(this.mulEle(e4, e9), this.mulEle(e3, e10));
            E e15 = this.subEle(this.mulEle(e2, e10), this.mulEle(e4, e8));
            E e16 = this.subEle(this.mulEle(e3, e8), this.mulEle(e2, e9));
            E e17 = this.subEle(this.mulEle(e3, e7), this.mulEle(e4, e6));
            E e18 = this.subEle(this.mulEle(e4, e5), this.mulEle(e2, e7));
            E e19 = this.subEle(this.mulEle(e2, e6), this.mulEle(e3, e5));
            MatrixI matrixI = this.mf.identity(3);
            ((GenericMatrix)matrixI).setEle(0, 0, e11);
            ((GenericMatrix)matrixI).setEle(0, 1, e14);
            ((GenericMatrix)matrixI).setEle(0, 2, e17);
            ((GenericMatrix)matrixI).setEle(1, 0, e12);
            ((GenericMatrix)matrixI).setEle(1, 1, e15);
            ((GenericMatrix)matrixI).setEle(1, 2, e18);
            ((GenericMatrix)matrixI).setEle(2, 0, e13);
            ((GenericMatrix)matrixI).setEle(2, 1, e16);
            ((GenericMatrix)matrixI).setEle(2, 2, e19);
            GenericMatrix<E> genericMatrix3 = this.div((GenericMatrix<E>)matrixI, (Object)e);
            return genericMatrix3;
        }
        MatrixI matrixI = this.mf.newMatrix(genericMatrix.toArray(new Object[n][n]));
        MatrixI matrixI2 = this.mf.identity(n);
        return this.gaussJordan(n, (GenericMatrix<E>)matrixI, (GenericMatrix<E>)matrixI2);
    }

    protected E calcSize(E e) throws EvaluationException {
        E e2 = this.mulEle(e, e);
        return e2;
    }

    protected boolean cmpSize(E e, E e2) throws EvaluationException {
        return this.gtEle(e, e2);
    }

    GenericMatrix<E> gaussJordan(int n, GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        for (int i = 0; i < n; ++i) {
            E e = genericMatrix.getEle(i, i);
            E e2 = this.calcSize(e);
            int n2 = i;
            for (int j = i + 1; j < n; ++j) {
                e = genericMatrix.getEle(j, i);
                E e3 = this.calcSize(e);
                if (!this.cmpSize(e3, e2)) continue;
                e2 = e3;
                n2 = j;
            }
            if (n2 != i) {
                this.swapRows(genericMatrix, i, n2);
                this.swapRows(genericMatrix2, i, n2);
            }
            e = genericMatrix.getEle(i, i);
            E e4 = this.divEle(this.getOne(), e);
            this.mulRow(genericMatrix, i, e4);
            this.mulRow(genericMatrix2, i, e4);
            for (int j = 0; j < n; ++j) {
                if (i == j) continue;
                e4 = genericMatrix.getEle(j, i);
                this.subtractMul(genericMatrix, j, i, e4);
                this.subtractMul(genericMatrix2, j, i, e4);
            }
        }
        return genericMatrix2;
    }

    @Override
    public Object inv(Object object) throws EvaluationException {
        if (object instanceof GenericMatrix) {
            GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
            return this.invMat(genericMatrix);
        }
        return null;
    }

    protected MatrixI solveMM(GenericMatrix<E> genericMatrix, GenericMatrix<E> genericMatrix2) throws EvaluationException {
        MatrixI matrixI = this.mf.newMatrix(genericMatrix.toArray(new Object[genericMatrix.getNRows()][genericMatrix.getNCols()]));
        MatrixI matrixI2 = this.mf.newMatrix(genericMatrix2.toArray(new Object[genericMatrix2.getNRows()][genericMatrix2.getNCols()]));
        return this.gaussJordan(genericMatrix.getNRows(), (GenericMatrix<E>)matrixI, (GenericMatrix<E>)matrixI2);
    }

    protected VectorI solveMV(GenericMatrix<E> genericMatrix, GenericVector<E> genericVector) throws EvaluationException {
        MatrixI matrixI = this.mf.newMatrix(genericMatrix.toArray(new Object[genericMatrix.getNRows()][genericMatrix.getNCols()]));
        Object[][] objectArray = new Object[genericVector.getNEles()][1];
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray[i][0] = genericVector.getEle(i);
        }
        MatrixI matrixI2 = this.mf.newMatrix(objectArray);
        GenericMatrix<E> genericMatrix2 = this.gaussJordan(genericMatrix.getNRows(), (GenericMatrix<E>)matrixI, (GenericMatrix<E>)matrixI2);
        Object[] objectArray2 = new Object[genericVector.getNEles()];
        for (int i = 0; i < genericVector.getNEles(); ++i) {
            objectArray2[i] = genericMatrix2.getEle(i, 0);
        }
        return this.mf.newVector(objectArray2);
    }

    @Override
    public Object solve(Object object, Object object2) throws EvaluationException {
        if (!(object instanceof GenericMatrix)) {
            throw new EvaluationException("Can only solve equations when lhs is a square matrix" + object);
        }
        GenericMatrix<E> genericMatrix = this.mf.cast((MatrixI)object);
        int n = genericMatrix.getNRows();
        if (n != genericMatrix.getNCols()) {
            throw new EvaluationException("Can only solve equations when lhs is a square matrix" + object);
        }
        if (object2 instanceof MatrixI) {
            GenericMatrix<E> genericMatrix2 = this.mf.cast((MatrixI)object2);
            if (n != genericMatrix2.getNRows()) {
                throw new EvaluationException("Can only solve equations when number of rows on left and right match" + object + " " + object2);
            }
            return this.solveMM(genericMatrix, genericMatrix2);
        }
        if (object2 instanceof VectorI) {
            GenericVector<E> genericVector = this.mf.cast((VectorI)object2);
            if (n != genericVector.getNEles()) {
                throw new EvaluationException("Can only solve equations when number of rows on left and right match" + object + " " + object2);
            }
            return this.solveMV(genericMatrix, genericVector);
        }
        return null;
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return null;
    }
}

