/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.MutablePolynomial;
import com.singularsys.extensions.polynomials.PConstant;
import com.singularsys.extensions.polynomials.PFunction;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.POperator;
import com.singularsys.extensions.polynomials.PVariable;
import com.singularsys.extensions.polynomials.Polynomial;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.ParseException;
import java.util.Map;

public abstract class AbstractPNode
implements PNodeI {
    protected PolynomialCreator pc;

    public AbstractPNode(PolynomialCreator polynomialCreator) {
        this.pc = polynomialCreator;
    }

    @Override
    public PNodeI add(PNodeI pNodeI) throws ParseException {
        if (pNodeI.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return pNodeI;
        }
        if (pNodeI instanceof Polynomial) {
            return pNodeI.add(this);
        }
        MutablePolynomial mutablePolynomial = new MutablePolynomial(this.pc, new PNodeI[]{this});
        mutablePolynomial.add(pNodeI);
        return mutablePolynomial.toPNode();
    }

    @Override
    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        if (pNodeI.isZero()) {
            return this;
        }
        if (this.isZero()) {
            return pNodeI.negate();
        }
        if (this.equalsPNode(pNodeI)) {
            return this.pc.zeroConstant;
        }
        if (pNodeI instanceof Polynomial) {
            return pNodeI.negate().add(this);
        }
        if (pNodeI instanceof PConstant) {
            return this.add(pNodeI.negate());
        }
        if (pNodeI instanceof Monomial) {
            Monomial monomial = (Monomial)pNodeI.negate();
            return Polynomial.valueOf(this.pc, new PNodeI[]{this, monomial});
        }
        return Polynomial.valueOf(this.pc, new PNodeI[]{this, Monomial.valueOf(this.pc, this.pc.minusOneConstant, pNodeI)});
    }

    @Override
    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (pNodeI.isZero()) {
            return this.pc.zeroConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (this.equalsPNode(pNodeI)) {
            return Monomial.valueOf(this.pc, this.pc.oneConstant, this, this.pc.twoConstant);
        }
        if (pNodeI instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)pNodeI, this);
        }
        if (pNodeI instanceof Monomial) {
            return ((Monomial)pNodeI).mul(this);
        }
        if (this instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)this, pNodeI);
        }
        if (this.compareTo(pNodeI) > 0) {
            return Monomial.valueOf(this.pc, this.pc.oneConstant, new PNodeI[]{pNodeI, this}, new PNodeI[]{this.pc.oneConstant, this.pc.oneConstant});
        }
        return Monomial.valueOf(this.pc, this.pc.oneConstant, new PNodeI[]{this, pNodeI}, new PNodeI[]{this.pc.oneConstant, this.pc.oneConstant});
    }

    @Override
    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (this.equalsPNode(pNodeI)) {
            return this.pc.oneConstant;
        }
        if (pNodeI.isZero()) {
            return this.pc.infConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        if (pNodeI instanceof Monomial) {
            return ((Monomial)pNodeI).invert().mul(this);
        }
        if (this instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)this, pNodeI, this.pc.minusOneConstant);
        }
        if (pNodeI instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)pNodeI.invert(), this);
        }
        return Monomial.valueOf(this.pc, this.pc.oneConstant, new PNodeI[]{this, pNodeI}, new PNodeI[]{this.pc.oneConstant, this.pc.minusOneConstant});
    }

    @Override
    public PNodeI invert() throws ParseException {
        return this.pow(this.pc.minusOneConstant);
    }

    @Override
    public PNodeI pow(PNodeI pNodeI) throws ParseException {
        if (pNodeI.isZero()) {
            return this.pc.oneConstant;
        }
        if (pNodeI.isOne()) {
            return this;
        }
        return Monomial.valueOf(this.pc, this.pc.oneConstant, this, pNodeI);
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        return false;
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public int compareTo(PNodeI pNodeI) {
        if (this instanceof PConstant) {
            if (pNodeI instanceof PConstant) {
                return ((PConstant)this).compareToPConstant((PConstant)pNodeI);
            }
            return -1;
        }
        if (this instanceof PVariable) {
            if (pNodeI instanceof PConstant) {
                return 1;
            }
            if (pNodeI instanceof PVariable) {
                return ((PVariable)this).compareTo((PVariable)pNodeI);
            }
            if (pNodeI instanceof PFunction || pNodeI instanceof POperator) {
                return -1;
            }
        }
        if (this instanceof POperator) {
            if (pNodeI instanceof PConstant || pNodeI instanceof PVariable) {
                return 1;
            }
            if (pNodeI instanceof POperator) {
                return ((POperator)this).compareTo((POperator)pNodeI);
            }
            if (pNodeI instanceof PFunction) {
                return -1;
            }
        }
        if (this instanceof PFunction) {
            if (pNodeI instanceof PConstant || pNodeI instanceof PVariable || pNodeI instanceof POperator) {
                return 1;
            }
            if (pNodeI instanceof PFunction) {
                return ((PFunction)this).compareTo((PFunction)pNodeI);
            }
        }
        if (this instanceof Monomial || this instanceof Polynomial) {
            throw new IllegalStateException("Comparison failed " + this.getClass().getName() + " " + pNodeI.getClass().getName());
        }
        if (pNodeI instanceof Monomial) {
            return -((Monomial)pNodeI).compareTo(this);
        }
        if (pNodeI instanceof Polynomial) {
            return -((Polynomial)pNodeI).compareTo(this);
        }
        throw new IllegalArgumentException("Comparison failed " + this.getClass().getName() + " " + pNodeI.getClass().getName());
    }

    void addToMap(Map<Integer, PNodeI> map, int n, PNodeI pNodeI) throws ParseException {
        PNodeI pNodeI2 = map.get(n);
        if (pNodeI2 == null) {
            map.put(n, pNodeI);
        } else {
            PNodeI pNodeI3 = pNodeI2.add(pNodeI);
            map.put(n, pNodeI3);
        }
    }
}

