/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.extensions.xjep.CommandVisitorI;
import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;

public class Coeffs
extends PostfixMathCommand
implements CommandVisitorI {
    private static final long serialVersionUID = 1L;
    PolynomialCreator pc;
    NodeFactory nf;
    OperatorTableI ot;

    public Coeffs(XJep xJep) {
        super(-1);
        this.pc = xJep.getPolynomialCreator();
        this.nf = xJep.getNodeFactory();
        this.ot = xJep.getOperatorTable();
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 2;
    }

    Node buildArray(PNodeI pNodeI, String[] stringArray, int n) throws ParseException {
        if (n >= stringArray.length) {
            return pNodeI.toNode();
        }
        PNodeI[] pNodeIArray = this.pc.toCoefficientArray(pNodeI, stringArray[n]);
        Node[] nodeArray = new Node[pNodeIArray.length];
        for (int i = 0; i < pNodeIArray.length; ++i) {
            nodeArray[i] = this.buildArray(pNodeIArray[i], stringArray, n + 1);
        }
        ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getList(), nodeArray);
        return aSTOpNode;
    }

    @Override
    public Node process(Node node, Node[] nodeArray) throws ParseException {
        String[] stringArray = new String[nodeArray.length - 1];
        for (int i = 1; i < nodeArray.length; ++i) {
            stringArray[i - 1] = nodeArray[i].getName();
        }
        PNodeI pNodeI = this.pc.createPoly(nodeArray[0]);
        Node node2 = this.buildArray(pNodeI, stringArray, 0);
        return node2;
    }
}

