/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.polynomials.AbstractPNode;
import com.singularsys.extensions.polynomials.MutableMonomial;
import com.singularsys.extensions.polynomials.MutablePolynomial;
import com.singularsys.extensions.polynomials.PConstant;
import com.singularsys.extensions.polynomials.PFunction;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.PVariable;
import com.singularsys.extensions.polynomials.Polynomial;
import com.singularsys.extensions.polynomials.PolynomialCreator;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.Node;
import java.util.Map;

public class Monomial
extends AbstractPNode {
    final PConstant coeff;
    final PNodeI[] vars;
    final PNodeI[] powers;

    private Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI[] pNodeIArray, PNodeI[] pNodeIArray2) {
        super(polynomialCreator);
        if (pNodeIArray.length != pNodeIArray2.length) {
            throw new IllegalArgumentException("Monomial.valueOf length of variables and powers must be equal. they are " + pNodeIArray.length + " " + pNodeIArray2.length);
        }
        this.coeff = pConstant;
        this.vars = pNodeIArray;
        this.powers = pNodeIArray2;
    }

    private Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI) {
        super(polynomialCreator);
        this.coeff = pConstant;
        this.vars = new PNodeI[]{pNodeI};
        this.powers = new PNodeI[]{polynomialCreator.oneConstant};
    }

    private Monomial(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI, PNodeI pNodeI2) {
        super(polynomialCreator);
        this.coeff = pConstant;
        this.vars = new PNodeI[]{pNodeI};
        this.powers = new PNodeI[]{pNodeI2};
    }

    public static PNodeI valueOf(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI) {
        if (pConstant.isZero()) {
            return polynomialCreator.zeroConstant;
        }
        if (pConstant.isOne()) {
            return pNodeI;
        }
        return new Monomial(polynomialCreator, pConstant, pNodeI);
    }

    public static PNodeI valueOf(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI pNodeI, PNodeI pNodeI2) {
        if (pConstant.isZero()) {
            return polynomialCreator.zeroConstant;
        }
        if (pConstant.isOne() && pNodeI2.isOne()) {
            return pNodeI;
        }
        return new Monomial(polynomialCreator, pConstant, pNodeI, pNodeI2);
    }

    public static PNodeI valueOf(PolynomialCreator polynomialCreator, PConstant pConstant, PNodeI[] pNodeIArray, PNodeI[] pNodeIArray2) {
        if (pConstant.isZero()) {
            return polynomialCreator.zeroConstant;
        }
        if (pNodeIArray.length == 0) {
            return pConstant;
        }
        if (pConstant.isOne() && pNodeIArray2.length == 1 && pNodeIArray2[0].isOne()) {
            return pNodeIArray[0];
        }
        return new Monomial(polynomialCreator, pConstant, pNodeIArray, pNodeIArray2);
    }

    MutableMonomial toMutiableMonomial() {
        PNodeI[] pNodeIArray = new PNodeI[this.vars.length];
        PNodeI[] pNodeIArray2 = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            pNodeIArray[i] = this.vars[i];
            pNodeIArray2[i] = this.powers[i];
        }
        return new MutableMonomial(this.pc, this.coeff, pNodeIArray, pNodeIArray2);
    }

    @Override
    public PNodeI mul(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.mul(pNodeI), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial) {
            return this.mul((Monomial)pNodeI);
        }
        MutableMonomial mutableMonomial = this.toMutiableMonomial();
        mutableMonomial.mul(pNodeI, this.pc.oneConstant);
        return mutableMonomial.toPNode();
    }

    @Override
    public PNodeI div(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.div(pNodeI), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial) {
            return this.div((Monomial)pNodeI);
        }
        MutableMonomial mutableMonomial = this.toMutiableMonomial();
        mutableMonomial.mul(pNodeI, this.pc.minusOneConstant);
        return mutableMonomial.toPNode();
    }

    PNodeI mul(Monomial monomial) throws ParseException {
        MutableMonomial mutableMonomial = this.toMutiableMonomial();
        mutableMonomial.mul(monomial.coeff);
        for (int i = 0; i < monomial.vars.length; ++i) {
            mutableMonomial.mul(monomial.vars[i], monomial.powers[i]);
        }
        return mutableMonomial.toPNode();
    }

    PNodeI div(Monomial monomial) throws ParseException {
        MutableMonomial mutableMonomial = this.toMutiableMonomial();
        mutableMonomial.div(monomial.coeff);
        for (int i = 0; i < monomial.vars.length; ++i) {
            mutableMonomial.mul(monomial.vars[i], monomial.powers[i].negate());
        }
        return mutableMonomial.toPNode();
    }

    @Override
    public PNodeI pow(PNodeI pNodeI) throws ParseException {
        if (pNodeI instanceof PConstant) {
            MutableMonomial mutableMonomial = this.toMutiableMonomial();
            mutableMonomial.power((PConstant)pNodeI);
            return mutableMonomial.toPNode();
        }
        return super.pow(pNodeI);
    }

    @Override
    public PNodeI negate() throws ParseException {
        return new Monomial(this.pc, (PConstant)this.coeff.negate(), this.vars, this.powers);
    }

    @Override
    public PNodeI invert() throws ParseException {
        PNodeI[] pNodeIArray = new PNodeI[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            pNodeIArray[i] = this.powers[i].negate();
        }
        return new Monomial(this.pc, (PConstant)this.coeff.invert(), this.vars, pNodeIArray);
    }

    @Override
    public PNodeI add(PNodeI pNodeI) throws ParseException {
        Monomial monomial;
        if (pNodeI instanceof PVariable && this.equalsIgnoreConstant(pNodeI)) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.add(this.pc.oneConstant), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial && this.equalsIgnoreConstant(monomial = (Monomial)pNodeI)) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.add(monomial.coeff), this.vars, this.powers);
        }
        return super.add(pNodeI);
    }

    @Override
    public PNodeI sub(PNodeI pNodeI) throws ParseException {
        Monomial monomial;
        if (pNodeI instanceof PVariable && this.equalsIgnoreConstant(pNodeI)) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.sub(this.pc.oneConstant), this.vars, this.powers);
        }
        if (pNodeI instanceof Monomial && this.equalsIgnoreConstant(monomial = (Monomial)pNodeI)) {
            return Monomial.valueOf(this.pc, (PConstant)this.coeff.sub(monomial.coeff), this.vars, this.powers);
        }
        return super.sub(pNodeI);
    }

    PNodeI addConstant(PConstant pConstant) throws ParseException {
        return Monomial.valueOf(this.pc, (PConstant)this.coeff.add(pConstant), this.vars, this.powers);
    }

    @Override
    public boolean equalsPNode(PNodeI pNodeI) {
        if (!(pNodeI instanceof Monomial)) {
            return false;
        }
        if (!this.coeff.equalsPNode(((Monomial)pNodeI).coeff)) {
            return false;
        }
        return this.equalsIgnoreConstant((Monomial)pNodeI);
    }

    boolean equalsIgnoreConstant(Monomial monomial) {
        if (this.vars.length != monomial.vars.length) {
            return false;
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.vars[i].equalsPNode(monomial.vars[i])) {
                return false;
            }
            if (this.powers[i].equalsPNode(monomial.powers[i])) continue;
            return false;
        }
        return true;
    }

    boolean equalsIgnoreConstant(PNodeI pNodeI) {
        if (pNodeI instanceof Monomial) {
            return this.equalsIgnoreConstant((Monomial)pNodeI);
        }
        if (this.vars.length != 1) {
            return false;
        }
        if (!this.vars[0].equalsPNode(pNodeI)) {
            return false;
        }
        return this.powers[0].isOne();
    }

    @Override
    public int compareTo(PNodeI pNodeI) {
        if (pNodeI instanceof PConstant) {
            return 1;
        }
        if (pNodeI instanceof PVariable) {
            PVariable pVariable = (PVariable)pNodeI;
            if (this.vars.length == 0) {
                return -1;
            }
            int n = this.vars[0].compareTo(pVariable);
            if (n != 0) {
                return n;
            }
            n = this.powers[0].compareTo(this.pc.oneConstant);
            if (n != 0) {
                return n;
            }
            if (this.vars.length > 1) {
                return 1;
            }
            return this.coeff.compareToPConstant(this.pc.oneConstant);
        }
        if (pNodeI instanceof Monomial) {
            Monomial monomial = (Monomial)pNodeI;
            for (int i = 0; i < this.vars.length; ++i) {
                if (i >= monomial.vars.length) {
                    return 1;
                }
                int n = this.vars[i].compareTo(monomial.vars[i]);
                if (n != 0) {
                    return n;
                }
                n = this.powers[i].compareTo(monomial.powers[i]);
                if (n == 0) continue;
                return n;
            }
            if (this.vars.length > monomial.vars.length) {
                return 1;
            }
            if (this.vars.length < monomial.vars.length) {
                return -1;
            }
            return this.coeff.compareToPConstant(monomial.coeff);
        }
        if (pNodeI instanceof Polynomial) {
            Polynomial polynomial = (Polynomial)pNodeI;
            int n = polynomial.compareTo(this);
            return -n;
        }
        int n = this.vars[0].compareTo(pNodeI);
        if (n == 0) {
            n = this.powers[0].compareTo(this.pc.oneConstant);
        }
        return n;
    }

    private boolean isNegativePower(PNodeI pNodeI) {
        return pNodeI instanceof PConstant && ((PConstant)pNodeI).isNegative();
    }

    private void printPower(StringBuffer stringBuffer, PNodeI pNodeI) {
        if (pNodeI.isOne()) {
            return;
        }
        if (pNodeI instanceof PConstant || pNodeI instanceof PVariable || pNodeI instanceof PFunction) {
            stringBuffer.append('^');
            stringBuffer.append(pNodeI.toString());
        } else {
            stringBuffer.append("^(");
            stringBuffer.append(pNodeI.toString());
            stringBuffer.append(")");
        }
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if (this.coeff.isMinusOne()) {
            stringBuffer.append('-');
        } else if (!this.coeff.isOne()) {
            stringBuffer.append(this.coeff.toString());
            bl = true;
        }
        int n2 = 0;
        for (n = 0; n < this.vars.length; ++n) {
            if (this.isNegativePower(this.powers[n])) {
                ++n2;
                continue;
            }
            if (bl) {
                stringBuffer.append('*');
            }
            if (this.vars[n] instanceof Polynomial) {
                stringBuffer.append('(');
                stringBuffer.append(this.vars[n].toString());
                stringBuffer.append(')');
            } else {
                stringBuffer.append(this.vars[n].toString());
            }
            this.printPower(stringBuffer, this.powers[n]);
            bl = true;
        }
        if (n2 > 0) {
            if (!bl) {
                stringBuffer.append('1');
            }
            if (n2 > 1) {
                stringBuffer.append("/(");
            } else {
                stringBuffer.append("/");
            }
            bl = false;
            for (n = 0; n < this.vars.length; ++n) {
                if (!this.isNegativePower(this.powers[n])) continue;
                if (bl) {
                    stringBuffer.append('*');
                }
                if (this.vars[n] instanceof Polynomial) {
                    stringBuffer.append('(');
                    stringBuffer.append(this.vars[n].toString());
                    stringBuffer.append(')');
                } else {
                    stringBuffer.append(this.vars[n].toString());
                }
                try {
                    this.printPower(stringBuffer, this.powers[n].negate());
                }
                catch (ParseException parseException) {
                    throw new IllegalStateException(parseException);
                }
                bl = true;
            }
            if (n2 > 1) {
                stringBuffer.append(")");
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public Node toNode() throws ParseException {
        Node node;
        NodeFactory nodeFactory = this.pc.getNodeFactory();
        OperatorTableI operatorTableI = this.pc.getOperatorTable();
        boolean bl = this.coeff.isOne();
        boolean bl2 = this.coeff.isMinusOne();
        Node node2 = null;
        if (!bl && !bl2) {
            node2 = this.coeff.toNode();
        }
        Node node3 = null;
        for (int i = 0; i < this.vars.length; ++i) {
            Node node4;
            if (this.isNegativePower(this.powers[i])) {
                node4 = null;
                if (this.powers[i] instanceof PConstant && ((PConstant)this.powers[i]).isMinusOne()) {
                    node4 = this.vars[i].toNode();
                } else {
                    PNodeI pNodeI = this.powers[i].negate();
                    node4 = nodeFactory.buildOperatorNode(operatorTableI.getPower(), this.vars[i].toNode(), pNodeI.toNode());
                }
                if (node3 == null) {
                    node3 = node4;
                    continue;
                }
                node3 = nodeFactory.buildOperatorNode(operatorTableI.getMultiply(), node3, node4);
                continue;
            }
            node4 = this.powers[i] instanceof PConstant && ((PConstant)this.powers[i]).isOne() ? this.vars[i].toNode() : nodeFactory.buildOperatorNode(operatorTableI.getPower(), this.vars[i].toNode(), this.powers[i].toNode());
            node2 = node2 == null ? node4 : nodeFactory.buildOperatorNode(operatorTableI.getMultiply(), node2, node4);
        }
        if (node2 != null && node3 == null) {
            node = bl2 ? nodeFactory.buildOperatorNode(operatorTableI.getUMinus(), node2) : node2;
        } else if (node2 != null && node3 != null) {
            node = nodeFactory.buildOperatorNode(operatorTableI.getDivide(), node2, node3);
            node = bl2 ? nodeFactory.buildOperatorNode(operatorTableI.getDivide(), nodeFactory.buildOperatorNode(operatorTableI.getUMinus(), node2), node3) : nodeFactory.buildOperatorNode(operatorTableI.getDivide(), node2, node3);
        } else if (node2 == null && node3 != null) {
            node = nodeFactory.buildOperatorNode(operatorTableI.getDivide(), this.coeff.toNode(), node3);
        } else {
            throw new ParseException("no numerators or denominators in a monomial");
        }
        return node;
    }

    @Override
    public Node toCompactNode() throws ParseException {
        int n = this.coeff.isOne() || this.coeff.isMinusOne() ? 0 : 1;
        int n2 = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.isNegativePower(this.powers[i])) continue;
            ++n2;
        }
        Node[] nodeArray = new Node[n + this.vars.length - n2];
        int n3 = 0;
        if (n > 0) {
            nodeArray[n3++] = this.coeff.toNode();
        }
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.isNegativePower(this.powers[i])) continue;
            nodeArray[n3++] = this.powers[i].isOne() ? this.vars[i].toNode() : this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getPower(), this.vars[i].toNode(), this.powers[i].toNode());
        }
        Node node = nodeArray.length == 0 ? this.coeff.toNode() : (nodeArray.length == 1 ? nodeArray[0] : this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getMultiply(), nodeArray));
        if (this.coeff.isMinusOne() && nodeArray.length > 0) {
            node = this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getUMinus(), node);
        }
        if (n2 == 0) {
            return node;
        }
        Node[] nodeArray2 = new Node[n2];
        n3 = 0;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!this.isNegativePower(this.powers[i])) continue;
            PNodeI pNodeI = this.powers[i].negate();
            nodeArray2[n3++] = this.powers[i] instanceof PConstant && ((PConstant)this.powers[i]).isMinusOne() ? this.vars[i].toNode() : this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getPower(), this.vars[i].toNode(), pNodeI.toNode());
        }
        Node node2 = nodeArray2.length == 1 ? nodeArray2[0] : this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getMultiply(), nodeArray2);
        return this.pc.getNodeFactory().buildOperatorNode(this.pc.getOperatorTable().getDivide(), node, node2);
    }

    boolean negativeCoefficient() {
        return this.coeff.isNegative();
    }

    @Override
    public PNodeI expand() throws ParseException {
        MutablePolynomial mutablePolynomial = new MutablePolynomial(this.pc, new PNodeI[]{this.coeff});
        for (int i = 0; i < this.vars.length; ++i) {
            if (this.powers[i] instanceof PConstant) {
                PConstant pConstant = (PConstant)this.powers[i];
                if (pConstant.isZero()) continue;
                if (pConstant.isOne()) {
                    mutablePolynomial.expandMul(this.vars[i].expand());
                    continue;
                }
                if (!pConstant.isInteger()) continue;
                int n = pConstant.intValue();
                if (n > 0) {
                    PNodeI pNodeI = this.vars[i].expand();
                    for (int j = 1; j <= n; ++j) {
                        mutablePolynomial.expandMul(pNodeI);
                    }
                    continue;
                }
                mutablePolynomial.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
                continue;
            }
            mutablePolynomial.expandMul(new Monomial(this.pc, this.pc.oneConstant, this.vars[i].expand(), this.powers[i]));
        }
        return mutablePolynomial.toPNode();
    }

    public PConstant getCoeff() {
        return this.coeff;
    }

    public int getNVars() {
        return this.vars.length;
    }

    public PNodeI getVar(int n) {
        return this.vars[n];
    }

    public PNodeI getPower(int n) {
        return this.powers[n];
    }

    @Override
    public void convertToPolyArray(String string, Map<Integer, PNodeI> map) throws ParseException {
        Object object;
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.vars.length; ++i) {
            if (!(this.vars[i] instanceof PVariable) || !string.equals(((PVariable)this.vars[i]).getName())) continue;
            n = i;
            if (this.powers[i] instanceof PConstant) {
                object = (PConstant)this.powers[i];
                if (((PConstant)object).isInteger()) {
                    n2 = ((PConstant)object).intValue();
                    if (n2 >= 0) continue;
                    throw new ParseException("Power must be positive");
                }
                throw new ParseException("Power must be integral");
            }
            throw new ParseException("Power must be a constant");
        }
        if (n == -1) {
            super.addToMap(map, 0, this);
        } else if (this.vars.length == 1) {
            super.addToMap(map, n2, this.coeff);
        } else {
            PNodeI[] pNodeIArray = new PNodeI[this.vars.length - 1];
            object = new PNodeI[this.vars.length - 1];
            int n3 = 0;
            for (int i = 0; i < this.vars.length; ++i) {
                if (i == n) continue;
                pNodeIArray[n3] = this.vars[i];
                object[n3] = this.powers[i];
                ++n3;
            }
            MutableMonomial mutableMonomial = new MutableMonomial(this.pc, this.coeff, pNodeIArray, (PNodeI[])object);
            PNodeI pNodeI = mutableMonomial.toPNode();
            super.addToMap(map, n2, pNodeI);
        }
    }
}

