/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.polynomials;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.implementations.DoubleField;
import com.singularsys.extensions.polynomials.Monomial;
import com.singularsys.extensions.polynomials.PConstant;
import com.singularsys.extensions.polynomials.PFunction;
import com.singularsys.extensions.polynomials.PNodeI;
import com.singularsys.extensions.polynomials.POperator;
import com.singularsys.extensions.polynomials.PVariable;
import com.singularsys.extensions.polynomials.Polynomial;
import com.singularsys.extensions.xjep.FieldTreeUtils;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.FunctionTable;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.OperatorTableI;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.VariableTable;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class PolynomialCreator
implements ParserVisitor,
JepComponent {
    private static final long serialVersionUID = 340L;
    public PConstant zeroConstant;
    public PConstant oneConstant;
    public PConstant minusOneConstant;
    public PConstant twoConstant;
    public PConstant infConstant;
    public PConstant nanConstant;
    Monomial zeroMonomial;
    Monomial unitMonomial;
    Polynomial zeroPolynomial;
    Polynomial unitPolynomial;
    protected Jep jep;
    protected NumberFactory numf;
    protected TreeUtils tu;
    protected NodeFactory nf;
    protected VariableTable vt;
    protected FunctionTable ft;
    protected OperatorTableI ot;
    protected FieldI field;

    public PolynomialCreator() {
        this(new DoubleField());
    }

    public PolynomialCreator(FieldI fieldI) {
        this(fieldI, new FieldTreeUtils(fieldI));
    }

    public PolynomialCreator(Jep jep) {
        this(new DoubleField(), new TreeUtils(jep.getNumberFactory()));
        this.jep = jep;
        this.ft = jep.getFunctionTable();
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.vt = jep.getVariableTable();
    }

    public PolynomialCreator(Jep jep, FieldI fieldI) {
        this(fieldI, new FieldTreeUtils(fieldI));
        this.jep = jep;
        this.ft = jep.getFunctionTable();
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.vt = jep.getVariableTable();
    }

    protected PolynomialCreator(FieldI fieldI, TreeUtils treeUtils) {
        this.field = fieldI;
        this.tu = treeUtils;
        this.zeroConstant = new PConstant(this, treeUtils.getZero());
        this.oneConstant = new PConstant(this, treeUtils.getOne());
        this.twoConstant = new PConstant(this, treeUtils.getTwo());
        this.minusOneConstant = new PConstant(this, treeUtils.getMinusOne());
        if (treeUtils.hasInfinity()) {
            this.infConstant = new PConstant(this, treeUtils.getPositiveInfinity());
        }
        if (treeUtils.hasNaN()) {
            this.nanConstant = new PConstant(this, treeUtils.getNAN());
        }
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        this.ft = jep.getFunctionTable();
        this.nf = jep.getNodeFactory();
        this.ot = jep.getOperatorTable();
        this.vt = jep.getVariableTable();
        this.tu = (TreeUtils)jep.getAdditionalComponent(TreeUtils.class);
        if (this.zeroConstant == null && this.tu != null) {
            this.zeroConstant = new PConstant(this, this.tu.getZero());
            this.oneConstant = new PConstant(this, this.tu.getOne());
            this.twoConstant = new PConstant(this, this.tu.getTwo());
            this.minusOneConstant = new PConstant(this, this.tu.getMinusOne());
            if (this.tu.hasInfinity()) {
                this.infConstant = new PConstant(this, this.tu.getPositiveInfinity());
            }
            if (this.tu.hasNaN()) {
                this.nanConstant = new PConstant(this, this.tu.getNAN());
            }
        }
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    public PNodeI createPoly(Node node) throws ParseException {
        try {
            return (PNodeI)node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
    }

    public Node toNode(PNodeI pNodeI) throws ParseException {
        return pNodeI.toNode();
    }

    public Node simplify(Node node) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        return pNodeI.toNode();
    }

    public Node expand(Node node) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = pNodeI.expand();
        return pNodeI2.toNode();
    }

    public PNodeI expand(PNodeI pNodeI) throws ParseException {
        PNodeI pNodeI2 = pNodeI.expand();
        return pNodeI2;
    }

    public int compare(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = this.createPoly(node2);
        return pNodeI.compareTo(pNodeI2);
    }

    public int expandCompare(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = this.createPoly(node2);
        PNodeI pNodeI3 = pNodeI.expand();
        PNodeI pNodeI4 = pNodeI2.expand();
        return pNodeI3.compareTo(pNodeI4);
    }

    public boolean equals(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = this.createPoly(node2);
        return pNodeI.equalsPNode(pNodeI2);
    }

    public boolean expandEquals(Node node, Node node2) throws ParseException {
        PNodeI pNodeI = this.createPoly(node);
        PNodeI pNodeI2 = pNodeI.expand();
        PNodeI pNodeI3 = this.createPoly(node2);
        PNodeI pNodeI4 = pNodeI3.expand();
        return pNodeI2.equalsPNode(pNodeI4);
    }

    public PNodeI[] toCoefficientArray(PNodeI pNodeI, String string) throws ParseException {
        HashMap<Integer, PNodeI> hashMap = new HashMap<Integer, PNodeI>();
        pNodeI.convertToPolyArray(string, hashMap);
        int n = -1;
        for (Object object : hashMap.keySet()) {
            if ((Integer)object <= n) continue;
            n = (Integer)object;
        }
        PNodeI[] pNodeIArray = new PNodeI[n + 1];
        for (Map.Entry entry : hashMap.entrySet()) {
            pNodeIArray[((Integer)entry.getKey()).intValue()] = (PNodeI)entry.getValue();
        }
        for (int i = 0; i < pNodeIArray.length; ++i) {
            if (pNodeIArray[i] != null) continue;
            pNodeIArray[i] = this.zeroConstant;
        }
        return pNodeIArray;
    }

    Object buildArray(PNodeI pNodeI, String[] stringArray, int n) throws ParseException {
        PNodeI[] pNodeIArray = this.toCoefficientArray(pNodeI, stringArray[n]);
        if (n == stringArray.length - 1) {
            return pNodeIArray;
        }
        Object object = this.buildArray(pNodeIArray[0], stringArray, n + 1);
        Object object2 = Array.newInstance(object.getClass(), pNodeIArray.length);
        Array.set(object2, 0, object);
        for (int i = 1; i < pNodeIArray.length; ++i) {
            Array.set(object2, i, this.buildArray(pNodeIArray[i], stringArray, n + 1));
        }
        return object2;
    }

    public Object toPNodeArray(PNodeI pNodeI, String ... stringArray) throws ParseException {
        Object object = this.buildArray(pNodeI, stringArray, 0);
        return object;
    }

    public double[] toDoubleArray(PNodeI pNodeI, String string) throws ParseException {
        PNodeI[] pNodeIArray = this.toCoefficientArray(pNodeI, string);
        double[] dArray = new double[pNodeIArray.length];
        for (int i = 0; i < pNodeIArray.length; ++i) {
            Object object;
            if (pNodeIArray[i] instanceof PConstant) {
                object = ((PConstant)pNodeIArray[i]).value;
                if (!(object instanceof Double)) {
                    throw new ParseException("Coefficients should be doubles, found " + object.toString());
                }
            } else {
                throw new ParseException("Coefficients should be a constant, found " + pNodeIArray[i].toString());
            }
            dArray[i] = (Double)object;
        }
        return dArray;
    }

    public double[][] toDoubleArray(PNodeI pNodeI, String string, String string2) throws ParseException {
        int n;
        PNodeI[] pNodeIArray = this.toCoefficientArray(pNodeI, string);
        double[][] dArrayArray = new double[pNodeIArray.length][];
        int n2 = -1;
        for (n = 0; n < pNodeIArray.length; ++n) {
            dArrayArray[n] = this.toDoubleArray(pNodeIArray[n], string2);
            if (dArrayArray[n].length <= n2) continue;
            n2 = dArrayArray[n].length;
        }
        for (n = 0; n < pNodeIArray.length; ++n) {
            int n3 = dArrayArray[n].length;
            if (n3 >= n2) continue;
            double[] dArray = new double[n2];
            System.arraycopy(dArrayArray[n], 0, dArray, 0, n3);
            dArrayArray[n] = dArray;
        }
        return dArrayArray;
    }

    public double[][][] toDoubleArray(PNodeI pNodeI, String string, String string2, String string3) throws ParseException {
        int n;
        int n2;
        PNodeI[] pNodeIArray = this.toCoefficientArray(pNodeI, string);
        double[][][] dArrayArray = new double[pNodeIArray.length][][];
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < pNodeIArray.length; ++n2) {
            dArrayArray[n2] = this.toDoubleArray(pNodeIArray[n2], string2, string3);
            if (dArrayArray[n2].length > n3) {
                n3 = dArrayArray[n2].length;
            }
            if (dArrayArray[n2][0].length <= n4) continue;
            n4 = dArrayArray[n2][0].length;
        }
        for (n2 = 0; n2 < pNodeIArray.length; ++n2) {
            n = dArrayArray[n2].length;
            if (n >= n3) continue;
            double[][] dArray = new double[n3][n4];
            System.arraycopy(dArrayArray[n2], 0, dArray, 0, n);
            dArrayArray[n2] = dArray;
        }
        for (n2 = 0; n2 < dArrayArray.length; ++n2) {
            for (n = 0; n < dArrayArray[n2].length; ++n) {
                int n5 = dArrayArray[n2][n].length;
                if (n5 >= n4) continue;
                double[] dArray = new double[n4];
                System.arraycopy(dArrayArray[n2][n], 0, dArray, 0, n5);
                dArrayArray[n2][n] = dArray;
            }
        }
        return dArrayArray;
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws ParseException {
        return new PConstant(this, aSTConstant.getValue());
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws ParseException {
        return new PVariable(this, aSTVarNode.getVar());
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws JepException {
        int n = aSTFunNode.jjtGetNumChildren();
        PNodeI[] pNodeIArray = new PNodeI[n];
        for (int i = 0; i < n; ++i) {
            pNodeIArray[i] = (PNodeI)aSTFunNode.jjtGetChild(i).jjtAccept(this, object);
        }
        Operator operator = aSTFunNode.getOperator();
        if (operator == this.ot.getAdd()) {
            PNodeI pNodeI = pNodeIArray[0];
            for (int i = 1; i < n; ++i) {
                pNodeI = pNodeI.add(pNodeIArray[i]);
            }
            return pNodeI;
        }
        if (operator == this.ot.getSubtract()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Subtract must have two arguments it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].sub(pNodeIArray[1]);
        }
        if (operator == this.ot.getUMinus()) {
            PNodeI pNodeI = pNodeIArray[0];
            return pNodeI.negate();
        }
        if (operator == this.ot.getMultiply()) {
            PNodeI pNodeI = pNodeIArray[0];
            for (int i = 1; i < n; ++i) {
                pNodeI = pNodeI.mul(pNodeIArray[i]);
            }
            return pNodeI;
        }
        if (operator == this.ot.getDivide()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Divide must have two arguments it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].div(pNodeIArray[1]);
        }
        if (operator == this.ot.getPower()) {
            if (pNodeIArray.length != 2) {
                throw new ParseException("Power must have two arguments it has " + pNodeIArray.length);
            }
            return pNodeIArray[0].pow(pNodeIArray[1]);
        }
        boolean bl = true;
        for (int i = 0; i < pNodeIArray.length; ++i) {
            if (pNodeIArray[i] instanceof PConstant) continue;
            bl = false;
            break;
        }
        if (bl) {
            Object object2;
            Node[] nodeArray = new Node[pNodeIArray.length];
            for (int i = 0; i < pNodeIArray.length; ++i) {
                nodeArray[i] = pNodeIArray[i].toNode();
            }
            ASTFunNode aSTFunNode2 = operator != null ? this.nf.buildOperatorNode(operator, nodeArray) : this.nf.buildFunctionNode(aSTFunNode.getName(), aSTFunNode.getPFMC(), nodeArray);
            try {
                object2 = this.jep.evaluate(aSTFunNode2);
            }
            catch (Exception exception) {
                throw new ParseException(exception.getMessage());
            }
            return new PConstant(this, object2);
        }
        if (operator != null) {
            return new POperator(this, operator, pNodeIArray);
        }
        return new PFunction(this, aSTFunNode.getName(), aSTFunNode.getPFMC(), pNodeIArray);
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws JepException {
        return this.visit((ASTFunNode)aSTOpNode, object);
    }

    final Object add(Object object, Object object2) throws ParseException {
        try {
            return this.field.add(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    final Object sub(Object object, Object object2) throws ParseException {
        try {
            return this.field.sub(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    final Object mul(Object object, Object object2) throws ParseException {
        try {
            return this.field.mul(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    final Object div(Object object, Object object2) throws ParseException {
        try {
            return this.field.div(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    final Object pow(Object object, Object object2) throws ParseException {
        try {
            return this.field.pow(object, object2);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    final Object neg(Object object) throws ParseException {
        try {
            return this.field.neg(object);
        }
        catch (EvaluationException evaluationException) {
            throw new ParseException(evaluationException);
        }
    }

    public NodeFactory getNodeFactory() {
        return this.nf;
    }

    public OperatorTableI getOperatorTable() {
        return this.ot;
    }
}

