/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.statistical;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.statistical.ArgumentExpander;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.functions.PostfixMathCommand;
import java.util.Stack;

public class Mean
extends PostfixMathCommand
implements JepComponent {
    private static final long serialVersionUID = 330L;
    FieldI fm;
    Object zero;
    Object one;

    public Mean(FieldI fieldI) {
        super(-1);
        this.fm = fieldI;
        this.one = fieldI.getOne();
        this.zero = fieldI.getZero();
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n > 0;
    }

    @Override
    public void run(Stack<Object> stack) throws EvaluationException {
        Processor processor = new Processor();
        processor.doStack(stack, this.curNumberOfParameters);
        if (processor.total == null) {
            throw new EvaluationException(this.name + ": zero length array");
        }
        Object object = this.fm.div(processor.total, processor.count);
        stack.push(object);
    }

    @Override
    public void init(Jep jep) {
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return new Mean(this.fm);
    }

    class Processor
    extends ArgumentExpander {
        Object total;
        Object count;
        int neles = 0;

        public Processor() {
            this.count = Mean.this.zero;
        }

        @Override
        protected void doSingleArg(Object object) throws EvaluationException {
            if (this.neles++ == 0) {
                this.total = object;
            } else {
                this.total = Mean.this.fm.add(object, this.total);
                if (this.total == null) {
                    throw new EvaluationException(Mean.this.name + ": could not add " + object);
                }
            }
            this.count = Mean.this.fm.add(this.count, Mean.this.one);
        }
    }
}

