/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.functions.NaryBinaryFunction;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.walkers.DoNothingVisitor;

public class ExpressionCleaner
extends DoNothingVisitor {
    private static final long serialVersionUID = 330L;
    TreeUtils tu;

    public ExpressionCleaner() {
    }

    public ExpressionCleaner(Jep jep, TreeUtils treeUtils) {
        super(jep);
        this.tu = treeUtils;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    @Override
    public void init(Jep jep) {
        this.jep = jep;
        this.nf = this.jep.getNodeFactory();
        this.ot = this.jep.getOperatorTable();
        this.tu = (TreeUtils)this.jep.getAdditionalComponent(TreeUtils.class);
    }

    public Node clean(Node node) throws ParseException {
        Node node2;
        if (node == null) {
            return null;
        }
        try {
            node2 = (Node)node.jjtAccept(this, null);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        return node2;
    }

    public Node cleanBuildOperatorNode(Operator operator, Node node, Node node2) throws ParseException {
        Node node3 = this.cleanOp(operator, node, node2);
        if (node3 == null) {
            node3 = this.nf.buildOperatorNode(operator, node, node2);
        }
        return node3;
    }

    public Node cleanBuildOperatorNode(Operator operator, Node node) throws ParseException {
        Node node2 = this.cleanOp(operator, node);
        if (node2 == null) {
            node2 = this.nf.buildOperatorNode(operator, node);
        }
        return node2;
    }

    public Node cleanOp(Node node, Node ... nodeArray) throws ParseException {
        Operator operator = node.getOperator();
        Node node2 = this.cleanOp(operator, nodeArray);
        if (node2 == null) {
            node2 = node;
        }
        return node2;
    }

    public Node cleanOp(Operator operator, Node ... nodeArray) throws ParseException {
        boolean bl = true;
        int n = nodeArray.length;
        if (operator.equals(this.ot.getEQ()) && n == 2 && this.tu.isNaN(nodeArray[0]) && this.tu.isNaN(nodeArray[1])) {
            return this.nf.buildConstantNode(this.tu.getFalse());
        }
        if (operator.equals(this.ot.getNE()) && n == 2 && this.tu.isNaN(nodeArray[0]) && this.tu.isNaN(nodeArray[1])) {
            return this.nf.buildConstantNode(this.tu.getTrue());
        }
        for (int i = 0; i < n; ++i) {
            if (this.tu.isConstant(nodeArray[i])) continue;
            bl = false;
        }
        if (bl) {
            return this.nf.buildConstantNode(operator, nodeArray);
        }
        if (n == 1) {
            if (this.tu.isUnaryOperator(nodeArray[0]) && operator == nodeArray[0].getOperator() && operator.isSelfInverse()) {
                return nodeArray[0].jjtGetChild(0);
            }
            if (this.ot.getUMinus().equals(operator)) {
                return this.cleanUMinus(nodeArray[0]);
            }
        } else if (n == 2) {
            Node node = null;
            if (this.ot.getAdd() == operator) {
                node = this.cleanAdd(nodeArray[0], nodeArray[1]);
            }
            if (this.ot.getSubtract() == operator) {
                node = this.cleanSubtract(nodeArray[0], nodeArray[1]);
            }
            if (this.ot.getMultiply() == operator) {
                node = this.cleanMultiply(nodeArray[0], nodeArray[1]);
            }
            if (this.ot.getDivide() == operator) {
                node = this.cleanDivide(nodeArray[0], nodeArray[1]);
            }
            if (this.ot.getPower() == operator) {
                node = this.cleanPower(nodeArray[0], nodeArray[1]);
            }
            if (node != null) {
                if (this.tu.isConstant(node)) {
                    return node;
                }
                if (this.tu.isOperator(node)) {
                    Node node2 = this.cleanOp(node, TreeUtils.getChildrenAsArray(node));
                    return node2;
                }
                return node;
            }
            node = this.cleanTripple(operator, nodeArray[0], nodeArray[1]);
            if (node != null) {
                if (this.tu.isConstant(node)) {
                    return node;
                }
                if (this.tu.isOperator(node)) {
                    Node node3 = this.cleanOp(node, TreeUtils.getChildrenAsArray(node));
                    return node3;
                }
                return node;
            }
        } else if (operator.isBinary() && operator.isAssociative() && operator.getPFMC() instanceof NaryBinaryFunction) {
            Node[] nodeArray2 = new Node[2];
            Node node = nodeArray[0];
            for (int i = 1; i < n; ++i) {
                nodeArray2[0] = node;
                nodeArray2[1] = nodeArray[i];
                node = this.cleanOp(operator, nodeArray2);
                if (node != null) continue;
                node = this.nf.buildOperatorNode(operator, nodeArray2);
            }
            return node;
        }
        return null;
    }

    public Node cleanTripple(Operator operator, Node node, Node node2) throws ParseException {
        Object object;
        Object object2;
        Object object3;
        Node node3;
        Object object4;
        Operator operator2 = operator.isComposite() ? operator.getRootOp() : operator;
        if (operator.isCommutative() && this.tu.isConstant(node2)) {
            return this.cleanBuildOperatorNode(operator, node2, node);
        }
        if (this.tu.isConstant(node) && this.tu.isBinaryOperator(node2)) {
            object4 = node2.jjtGetChild(0);
            node3 = node2.jjtGetChild(1);
            object3 = ((ASTFunNode)node2).getOperator();
            object2 = ((Operator)object3).isComposite() ? ((Operator)object3).getRootOp() : object3;
            if (this.tu.isConstant((Node)object4)) {
                object = operator2;
                object = operator == object3 ? operator2 : operator2.getBinaryInverseOp();
                if (operator2 == object2 && operator2.isAssociative()) {
                    Node node4 = this.cleanBuildOperatorNode((Operator)object, this.nf.buildConstantNode(operator, new Node[]{node, object4}), node3);
                    return node4;
                }
                if (operator.isDistributiveOver((Operator)object2)) {
                    Node node5 = this.cleanBuildOperatorNode((Operator)object3, this.nf.buildConstantNode(operator, new Node[]{node, object4}), this.cleanBuildOperatorNode(operator, node, node3));
                    return node5;
                }
            }
            if (this.tu.isConstant(node3)) {
                object = operator2;
                object = operator == object3 ? operator2 : operator2.getBinaryInverseOp();
                if (operator2 == object2 && operator2.isCommutative() && operator2.isAssociative()) {
                    Node node6 = this.cleanBuildOperatorNode(operator, this.nf.buildConstantNode((Operator)object, node, node3), (Node)object4);
                    return node6;
                }
                if (operator.isDistributiveOver((Operator)object2)) {
                    Node node7 = this.cleanBuildOperatorNode((Operator)object3, this.cleanBuildOperatorNode(operator, node, (Node)object4), this.nf.buildConstantNode(operator, node, node3));
                    return node7;
                }
            }
        }
        if (this.tu.isBinaryOperator(node) && this.tu.isConstant(node2)) {
            object4 = node.jjtGetChild(0);
            node3 = node.jjtGetChild(1);
            object3 = node.getOperator();
            object2 = ((Operator)object3).isComposite() ? ((Operator)object3).getRootOp() : object3;
            if (this.tu.isConstant((Node)object4)) {
                if (operator2 == object2 && operator2.isAssociative() && operator2.isCommutative()) {
                    object = this.cleanBuildOperatorNode((Operator)object3, this.nf.buildConstantNode(operator, new Node[]{object4, node2}), node3);
                    return object;
                }
                if (operator.isDistributiveOver((Operator)object2)) {
                    object = this.cleanBuildOperatorNode((Operator)object3, this.nf.buildConstantNode(operator, new Node[]{object4, node2}), this.cleanBuildOperatorNode(operator, node3, node2));
                    return object;
                }
            }
            if (this.tu.isConstant(node3)) {
                if (operator2 == object2 && operator2.isAssociative()) {
                    object = operator2;
                    object = operator == object3 ? operator2 : operator2.getBinaryInverseOp();
                    Node node8 = this.cleanBuildOperatorNode((Operator)object3, (Node)object4, this.nf.buildConstantNode((Operator)object, node3, node2));
                    return node8;
                }
                if (operator.isDistributiveOver((Operator)object2)) {
                    object = this.cleanBuildOperatorNode((Operator)object3, this.cleanBuildOperatorNode(operator, (Node)object4, node2), this.nf.buildConstantNode(operator, node3, node2));
                    return object;
                }
            }
        }
        if (this.tu.isBinaryOperator(node2) && node2.getOperator().equals(operator) && operator.isAssociative() && operator.isLeftBinding()) {
            object4 = node2.jjtGetChild(0);
            node3 = node2.jjtGetChild(1);
            object3 = this.cleanBuildOperatorNode(operator, this.cleanBuildOperatorNode(operator, node, (Node)object4), node3);
            return object3;
        }
        if (this.tu.isBinaryOperator(node) && node.getOperator().equals(operator) && operator.isAssociative() && operator.isRightBinding()) {
            object4 = node.jjtGetChild(0);
            node3 = node.jjtGetChild(1);
            object3 = this.cleanBuildOperatorNode(operator, (Node)object4, this.cleanBuildOperatorNode(operator, node3, node2));
            return object3;
        }
        if (this.tu.isBinaryOperator(node) && node.getOperator().equals(operator) && operator.isAssociative() && operator.isCommutative() && operator.isLeftBinding() && this.tu.isConstant(node2)) {
            object4 = node.jjtGetChild(0);
            node3 = node.jjtGetChild(1);
            object3 = this.cleanBuildOperatorNode(operator, this.cleanBuildOperatorNode(operator, node2, (Node)object4), node3);
            return object3;
        }
        if (this.tu.isBinaryOperator(node) && operator.isCommutative() && (object4 = node.getOperator()) == operator.getBinaryInverseOp() && operator == ((Operator)object4).getRootOp()) {
            node3 = node.jjtGetChild(0);
            object3 = node.jjtGetChild(1);
            object2 = this.cleanBuildOperatorNode((Operator)object4, this.cleanBuildOperatorNode(operator, node3, node2), (Node)object3);
            return object2;
        }
        return null;
    }

    public Node cleanAdd(Node node, Node node2) throws ParseException {
        if (this.tu.isInfinity(node)) {
            if (this.tu.isInfinity(node2) && this.tu.isNegative(node2)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isInfinity(node2)) {
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isZero(node)) {
            return node2;
        }
        if (this.tu.isZero(node2)) {
            return node;
        }
        if (this.tu.isNegative(node)) {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getSubtract(), node2, this.nf.buildConstantNode(this.ot.getUMinus(), node));
            return aSTOpNode;
        }
        if (this.tu.isNegative(node2)) {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getSubtract(), node, this.nf.buildConstantNode(this.ot.getUMinus(), node2));
            return aSTOpNode;
        }
        return null;
    }

    public Node cleanSubtract(Node node, Node node2) throws ParseException {
        if (this.tu.isInfinity(node)) {
            if (this.tu.isInfinity(node2) && this.tu.isPositive(node2)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            return this.nf.buildConstantNode(node.getValue());
        }
        if (this.tu.isInfinity(node2)) {
            if (this.tu.isPositive(node2)) {
                if (this.tu.hasInfinity()) {
                    return this.nf.buildConstantNode(this.tu.getNegativeInfinity());
                }
                throw new ParseException("Attempt to clean expression with Infinite value.");
            }
            if (this.tu.isNegative(node2)) {
                if (this.tu.hasInfinity()) {
                    return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
                }
                throw new ParseException("Attempt to clean expression with Infinite value.");
            }
            return this.nf.buildConstantNode(node2.getValue());
        }
        if (this.tu.isZero(node2)) {
            return node;
        }
        if (this.tu.isZero(node)) {
            Node node3 = this.cleanBuildOperatorNode(this.ot.getUMinus(), node2);
            return node3;
        }
        if (this.tu.isNegative(node2)) {
            Node node4 = this.cleanBuildOperatorNode(this.ot.getAdd(), node, this.nf.buildConstantNode(this.ot.getUMinus(), node2));
            return node4;
        }
        if (node2.getOperator() == this.ot.getUMinus()) {
            Node node5 = this.cleanBuildOperatorNode(this.ot.getAdd(), node, node2.jjtGetChild(0));
            return node5;
        }
        return null;
    }

    public Node cleanMultiply(Node node, Node node2) throws ParseException {
        if (this.tu.isZero(node)) {
            if (this.tu.isInfinity(node2)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            return this.nf.buildConstantNode(this.tu.getZero());
        }
        if (this.tu.isZero(node2)) {
            if (this.tu.isInfinity(node)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            return this.nf.buildConstantNode(this.tu.getZero());
        }
        if (this.tu.isInfinity(node)) {
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isInfinity(node2)) {
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isOne(node)) {
            return node2;
        }
        if (this.tu.isOne(node2)) {
            return node;
        }
        if (this.tu.isMinusOne(node)) {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getUMinus(), node2);
            return aSTOpNode;
        }
        if (this.tu.isMinusOne(node2)) {
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.ot.getUMinus(), node);
            return aSTOpNode;
        }
        if (this.tu.isConstant(node) && this.ot.getUMinus() == node2.getOperator()) {
            Node node3 = node2.jjtGetChild(0);
            Node node4 = this.cleanBuildOperatorNode(this.ot.getMultiply(), this.nf.buildConstantNode(this.ot.getUMinus(), node), node3);
            return node4;
        }
        return null;
    }

    public Node cleanDivide(Node node, Node node2) throws ParseException {
        if (this.tu.isZero(node2)) {
            if (this.tu.isZero(node)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isZero(node)) {
            return node;
        }
        if (this.tu.isOne(node2)) {
            return node;
        }
        if (this.tu.isInfinity(node)) {
            if (this.tu.hasInfinity()) {
                return this.nf.buildConstantNode(this.tu.getPositiveInfinity());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (this.tu.isInfinity(node2)) {
            return this.nf.buildConstantNode(this.tu.getZero());
        }
        if (this.tu.isConstant(node) && this.ot.getUMinus() == node2.getOperator()) {
            Node node3 = node2.jjtGetChild(0);
            Node node4 = this.cleanBuildOperatorNode(this.ot.getDivide(), this.nf.buildConstantNode(this.ot.getUMinus(), node), node3);
            return node4;
        }
        return null;
    }

    public Node cleanPower(Node node, Node node2) throws ParseException {
        if (this.tu.isZero(node)) {
            if (this.tu.isZero(node2)) {
                if (this.tu.hasNaN()) {
                    return this.nf.buildConstantNode(this.tu.getNAN());
                }
                throw new ParseException("Attempt to clean expression with NaN value.");
            }
            return this.nf.buildConstantNode(this.tu.getZero());
        }
        if (this.tu.isZero(node2)) {
            return this.nf.buildConstantNode(this.tu.getOne());
        }
        if (this.tu.isOne(node)) {
            return this.nf.buildConstantNode(this.tu.getOne());
        }
        if (this.tu.isOne(node2)) {
            return node;
        }
        if (this.tu.isConstant(node2) && node.getOperator() == this.ot.getPower() && this.tu.isConstant(node.jjtGetChild(1))) {
            return this.nf.buildOperatorNode(this.ot.getPower(), node.jjtGetChild(0), this.nf.buildConstantNode(this.ot.getMultiply(), node.jjtGetChild(1), node2));
        }
        return null;
    }

    public Node cleanUMinus(Node node) throws ParseException {
        if (this.tu.isConstant(node)) {
            ASTConstant aSTConstant = this.nf.buildConstantNode(this.ot.getUMinus(), node);
            return aSTConstant;
        }
        if (this.tu.isOperator(node)) {
            Operator operator = node.getOperator();
            if (operator.equals(this.ot.getAdd())) {
                return this.cleanBuildOperatorNode(this.ot.getSubtract(), this.cleanBuildOperatorNode(this.ot.getUMinus(), node.jjtGetChild(0)), node.jjtGetChild(1));
            }
            if (operator.equals(this.ot.getSubtract())) {
                return this.cleanBuildOperatorNode(this.ot.getSubtract(), node.jjtGetChild(1), node.jjtGetChild(0));
            }
            if (operator.equals(this.ot.getMultiply())) {
                if (this.tu.isConstant(node.jjtGetChild(0))) {
                    return this.cleanBuildOperatorNode(this.ot.getMultiply(), this.nf.buildConstantNode(this.ot.getUMinus(), node.jjtGetChild(0)), node.jjtGetChild(1));
                }
                if (operator.isCommutative() && this.tu.isConstant(node.jjtGetChild(1))) {
                    return this.cleanBuildOperatorNode(this.ot.getMultiply(), this.nf.buildConstantNode(this.ot.getUMinus(), node.jjtGetChild(1)), node.jjtGetChild(0));
                }
            }
            if (operator.equals(this.ot.getDivide()) && this.tu.isConstant(node.jjtGetChild(0))) {
                return this.cleanBuildOperatorNode(this.ot.getDivide(), this.nf.buildConstantNode(this.ot.getUMinus(), node.jjtGetChild(0)), node.jjtGetChild(1));
            }
        }
        return null;
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws ParseException {
        Node[] nodeArray;
        int n = aSTOpNode.jjtGetNumChildren();
        Operator operator = aSTOpNode.getOperator();
        if (operator.isBinary() && operator.isAssociative() ? n == 0 : (operator.isBinary() && n != 2 || operator.isUnary() && n != 1) && !operator.getPFMC().checkNumberOfParameters(n)) {
            throw new ParseException("Wrong number of children for " + n + " for operator " + operator.getName());
        }
        try {
            nodeArray = this.visitChildren(aSTOpNode, object);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        TreeUtils.setChildrenIfNeeded(aSTOpNode, nodeArray);
        Node node = this.cleanOp(aSTOpNode, nodeArray);
        if (node == null) {
            throw new ParseException("null res from clean op");
        }
        return node;
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws ParseException {
        Node[] nodeArray;
        int n = aSTFunNode.jjtGetNumChildren();
        try {
            nodeArray = this.visitChildren(aSTFunNode, object);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (JepException jepException) {
            throw new ParseException(jepException);
        }
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!this.tu.isConstant(nodeArray[i])) {
                bl = false;
            }
            if (!this.tu.isNaN(nodeArray[i])) continue;
            if (this.tu.hasNaN()) {
                return this.nf.buildConstantNode(this.tu.getNAN());
            }
            throw new ParseException("Attempt to clean expression with Infinite value.");
        }
        if (bl) {
            return this.nf.buildConstantNode(aSTFunNode.getPFMC(), nodeArray);
        }
        return TreeUtils.setChildrenIfNeeded(aSTFunNode, nodeArray);
    }
}

