/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.extensions.field.FieldI;
import com.singularsys.extensions.field.implementations.IntegerConvertor;
import com.singularsys.extensions.xjep.TreeUtils;
import com.singularsys.jep.EvaluationException;

public class FieldTreeUtils
extends TreeUtils {
    private static final long serialVersionUID = 350L;
    FieldI field;

    private static Object calcMinusOne(FieldI fieldI) {
        Object object;
        try {
            object = fieldI.neg(fieldI.getOne());
        }
        catch (EvaluationException evaluationException) {
            object = null;
        }
        return object;
    }

    private static Object calcTwo(FieldI fieldI) {
        Object object;
        try {
            object = fieldI.add(fieldI.getOne(), fieldI.getOne());
        }
        catch (EvaluationException evaluationException) {
            object = null;
        }
        return object;
    }

    private static Object calcPInf(FieldI fieldI) {
        Object object;
        try {
            object = fieldI.div(fieldI.getOne(), fieldI.getZero());
        }
        catch (EvaluationException evaluationException) {
            object = null;
        }
        return object;
    }

    private static Object calcNInf(FieldI fieldI) {
        Object object;
        try {
            object = fieldI.div(fieldI.neg(fieldI.getOne()), fieldI.getZero());
        }
        catch (EvaluationException evaluationException) {
            object = null;
        }
        return object;
    }

    private static Object calcNaN(FieldI fieldI) {
        Object object;
        try {
            object = fieldI.div(fieldI.getZero(), fieldI.getZero());
        }
        catch (EvaluationException evaluationException) {
            object = null;
        }
        return object;
    }

    public FieldTreeUtils(FieldI fieldI) {
        super(fieldI.getZero(), fieldI.getOne(), FieldTreeUtils.calcMinusOne(fieldI), FieldTreeUtils.calcTwo(fieldI), FieldTreeUtils.calcPInf(fieldI), FieldTreeUtils.calcNInf(fieldI), FieldTreeUtils.calcNaN(fieldI));
        this.field = fieldI;
    }

    @Override
    public boolean isMinusOneVal(Object object) {
        try {
            Boolean bl = this.field.eq(object, this.getMinusOne());
            return bl == null ? false : bl;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isNegativeVal(Object object) {
        try {
            Boolean bl = this.field.lt(object, this.field.getZero());
            return bl == null ? false : bl;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isOneVal(Object object) {
        try {
            Boolean bl = this.field.eq(object, this.field.getOne());
            return bl == null ? false : bl;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isPositiveVal(Object object) {
        try {
            Boolean bl = this.field.gt(object, this.field.getZero());
            return bl == null ? false : bl;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isZeroVal(Object object) {
        try {
            Object object2 = this.field.getZero();
            Boolean bl = this.field.eq(object, object2);
            return bl == null ? false : bl;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isInfinityVal(Object object) {
        if (!this.hasInfinity()) {
            return false;
        }
        try {
            Boolean bl = this.field.eq(object, this.getPositiveInfinity());
            if (bl != null && bl.booleanValue()) {
                return bl;
            }
            Boolean bl2 = this.field.eq(object, this.getNegativeInfinity());
            if (bl2 != null && bl2.booleanValue()) {
                return bl2;
            }
            return false;
        }
        catch (EvaluationException evaluationException) {
            return false;
        }
    }

    @Override
    public boolean isNaNVal(Object object) {
        if (!this.hasNaN()) {
            return false;
        }
        return super.isNaNVal(object);
    }

    @Override
    public boolean isIntegerVal(Object object) {
        try {
            Integer n;
            if (this.field instanceof IntegerConvertor && (n = ((IntegerConvertor)((Object)this.field)).convertToInt(object)) != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public int getIntValue(Object object) throws EvaluationException {
        Integer n;
        if (this.field instanceof IntegerConvertor && (n = ((IntegerConvertor)((Object)this.field)).convertToInt(object)) != null) {
            return n;
        }
        throw new EvaluationException("Could not convert " + object + " to an integer value");
    }
}

