/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.extensions.xjep;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.NumberFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.standard.Complex;
import com.singularsys.jep.standard.DoubleNumberFactory;

public class TreeUtils
implements JepComponent {
    private static final long serialVersionUID = 330L;
    private static final Complex CZERO = new Complex(0.0, 0.0);
    private static final Complex CONE = new Complex(1.0, 0.0);
    private static final Complex CI = new Complex(0.0, 1.0);
    private static final Complex CMINUSONE = new Complex(-1.0, 0.0);
    private static final Complex CMINUSI = new Complex(0.0, -1.0);
    private final Object NAN;
    private final Object PosInf;
    private final Object NegInf;
    private Object ZERO;
    private Object ONE;
    private Object TWO;
    private Object MINUS_ONE;

    public TreeUtils(NumberFactory numberFactory) {
        this.ZERO = numberFactory.getZero();
        this.ONE = numberFactory.getOne();
        this.TWO = numberFactory.getTwo();
        this.MINUS_ONE = numberFactory.getMinusOne();
        this.NAN = Double.NaN;
        this.PosInf = Double.POSITIVE_INFINITY;
        this.NegInf = Double.NEGATIVE_INFINITY;
    }

    public TreeUtils() {
        this(new DoubleNumberFactory());
    }

    protected TreeUtils(Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        this.ZERO = object;
        this.ONE = object2;
        this.MINUS_ONE = object3;
        this.TWO = object4;
        this.PosInf = object5;
        this.NegInf = object6;
        this.NAN = object7;
    }

    public boolean isReal(Node node) {
        return node instanceof ASTConstant && this.isRealVal(node.getValue());
    }

    public boolean isRealVal(Object object) {
        return object instanceof Number;
    }

    public boolean isZero(Node node) {
        return node instanceof ASTConstant && this.isZeroVal(node.getValue());
    }

    public boolean isZeroVal(Object object) {
        if (this.isRealVal(object)) {
            double d = ((Number)object).doubleValue();
            return d == 0.0;
        }
        return this.isComplexVal(object) && ((Complex)object).equals(CZERO, 0.0);
    }

    public boolean isOne(Node node) {
        return node instanceof ASTConstant && this.isOneVal(node.getValue());
    }

    public boolean isOneVal(Object object) {
        return this.isRealVal(object) && object.equals(this.getOne()) || this.isComplexVal(object) && ((Complex)object).equals(CONE, 0.0);
    }

    public boolean isMinusOne(Node node) {
        return node instanceof ASTConstant && this.isMinusOneVal(node.getValue());
    }

    public boolean isMinusOneVal(Object object) {
        return this.isRealVal(object) && object.equals(this.getMinusOne()) || this.isComplexVal(object) && ((Complex)object).equals(CMINUSONE, 0.0);
    }

    public boolean isInfinity(Node node) {
        return node instanceof ASTConstant && this.isInfinityVal(node.getValue());
    }

    public boolean isInfinityVal(Object object) {
        if (this.isRealVal(object)) {
            Number number = (Number)object;
            if (number instanceof Double) {
                return ((Double)number).isInfinite();
            }
            if (number instanceof Float) {
                return ((Float)number).isInfinite();
            }
            return false;
        }
        if (this.isComplexVal(object)) {
            Complex complex = (Complex)object;
            return Double.isInfinite(complex.re()) || Double.isInfinite(complex.im());
        }
        return false;
    }

    public boolean isNaN(Node node) {
        return node instanceof ASTConstant && this.isNaNVal(node.getValue());
    }

    public boolean isNaNVal(Object object) {
        if (this.isRealVal(object)) {
            Number number = (Number)object;
            if (number instanceof Double) {
                return ((Double)number).isNaN();
            }
            if (number instanceof Float) {
                return ((Float)number).isNaN();
            }
            return false;
        }
        if (this.isComplexVal(object)) {
            Complex complex = (Complex)object;
            return Double.isNaN(complex.re()) || Double.isNaN(complex.im());
        }
        return false;
    }

    public boolean isNegative(Node node) {
        return node instanceof ASTConstant && this.isNegativeVal(node.getValue());
    }

    public boolean isNegativeVal(Object object) {
        return this.isRealVal(object) && ((Number)object).doubleValue() < 0.0;
    }

    public boolean isPositive(Node node) {
        return node instanceof ASTConstant && this.isPositiveVal(node.getValue());
    }

    public boolean isPositiveVal(Object object) {
        return this.isRealVal(object) && ((Number)object).doubleValue() > 0.0;
    }

    public boolean isComplex(Node node) {
        return node instanceof ASTConstant && this.isComplexVal(node.getValue());
    }

    public boolean isComplexVal(Object object) {
        return object instanceof Complex;
    }

    public boolean isInteger(Node node) {
        return node instanceof ASTConstant && this.isIntegerVal(node.getValue());
    }

    public boolean isIntegerVal(Object object) {
        if (!this.isRealVal(object)) {
            return false;
        }
        if (!(object instanceof Number)) {
            return false;
        }
        int n = ((Number)object).intValue();
        double d = ((Number)object).doubleValue();
        return d == (double)n;
    }

    public int intValue(Node node) throws EvaluationException {
        return this.getIntValue(node.getValue());
    }

    public int getIntValue(Object object) throws EvaluationException {
        int n = ((Number)object).intValue();
        return n;
    }

    public Object getTrue() {
        return true;
    }

    public Object getFalse() {
        return false;
    }

    public boolean isConstant(Node node) {
        return node instanceof ASTConstant;
    }

    public boolean isVariable(Node node) {
        return node instanceof ASTVarNode;
    }

    public boolean isConstantVariable(Node node) {
        return node instanceof ASTVarNode && node.getVar().isConstant();
    }

    public boolean isOperator(Node node) {
        return node instanceof ASTOpNode;
    }

    public boolean isBinaryOperator(Node node) {
        if (this.isOperator(node)) {
            return node.getOperator().isBinary();
        }
        return false;
    }

    public boolean isUnaryOperator(Node node) {
        if (this.isOperator(node)) {
            return node.getOperator().isUnary();
        }
        return false;
    }

    public boolean isFunction(Node node) {
        return node instanceof ASTFunNode;
    }

    public static Node setChildrenIfNeeded(Node node, Node[] nodeArray) throws ParseException {
        int n = node.jjtGetNumChildren();
        if (n != nodeArray.length) {
            throw new ParseException("setChildrenIfNeeded: number of children of node not the same as supplied children");
        }
        for (int i = 0; i < n; ++i) {
            if (node.jjtGetChild(i) == nodeArray[i]) continue;
            node.jjtAddChild(nodeArray[i], i);
            nodeArray[i].jjtSetParent(node);
        }
        return node;
    }

    public static Node[] getChildrenAsArray(Node node) {
        int n = node.jjtGetNumChildren();
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            nodeArray[i] = node.jjtGetChild(i);
        }
        return nodeArray;
    }

    public Object getCI() {
        return CI;
    }

    public Object getCMinusI() {
        return CMINUSI;
    }

    public Object getCMinusOne() {
        return CMINUSONE;
    }

    public Object getCOne() {
        return CONE;
    }

    public Object getCZero() {
        return CZERO;
    }

    public Object getZero() {
        return this.ZERO;
    }

    public Object getOne() {
        return this.ONE;
    }

    public Object getMinusOne() {
        return this.MINUS_ONE;
    }

    public Object getTwo() {
        return this.TWO;
    }

    public boolean hasNaN() {
        return this.NAN != null;
    }

    public boolean hasInfinity() {
        return this.PosInf != null;
    }

    public Object getNAN() {
        return this.NAN;
    }

    public Object getPositiveInfinity() {
        return this.PosInf;
    }

    public Object getNegativeInfinity() {
        return this.NegInf;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        return this;
    }

    @Override
    public void init(Jep jep) {
    }
}

