/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.bigdecimal.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.bigdecimal.BigDecNumberFactory;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.Signum;
import java.math.BigDecimal;

public class BigDecSignum
extends Signum {
    private static final long serialVersionUID = 350L;

    @Override
    public Object eval(Object object) throws EvaluationException {
        if (object instanceof BigDecimal) {
            switch (((BigDecimal)object).signum()) {
                case -1: {
                    return BigDecNumberFactory.MINUSONE;
                }
                case 0: {
                    return BigDecimal.ZERO;
                }
                case 1: {
                    return BigDecimal.ONE;
                }
            }
        }
        if (object instanceof Double) {
            return this.eval(BigDecimal.valueOf((Double)object));
        }
        if (object instanceof Integer) {
            return this.eval(BigDecimal.valueOf(((Integer)object).intValue()));
        }
        if (object instanceof Float) {
            return this.eval(BigDecimal.valueOf(((Float)object).floatValue()));
        }
        if (object instanceof Short) {
            return this.eval(BigDecimal.valueOf(((Short)object).shortValue()));
        }
        if (object instanceof Long) {
            return this.eval(BigDecimal.valueOf((Long)object));
        }
        throw new IllegalParameterException((PostfixMathCommandI)this, 0, BigDecimal.class, object);
    }
}

