/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.Operator;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.configurableparser.ConfigurableParser;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.GrammarParserFactory;
import com.singularsys.jep.configurableparser.Lookahead2Iterator;
import com.singularsys.jep.configurableparser.TernaryOperator;
import com.singularsys.jep.configurableparser.matchers.GrammarException;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.NumberToken;
import com.singularsys.jep.configurableparser.tokens.OperatorToken;
import com.singularsys.jep.configurableparser.tokens.StringToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ShuntingYard
implements GrammarParser {
    protected static final boolean DUMP = false;
    protected Stack<Operator> ops = new Stack();
    protected Stack<Node> nodes = new Stack();
    protected Lookahead2Iterator<Token> it;
    protected List<GrammarMatcher> matchers;
    protected Jep jep;
    protected static final Operator sentinel = new Operator("EOF", null, 0);
    protected static final Operator implicitMul = new Operator("ImplicitMul", null, 6);
    protected NodeFactory nf;

    public ShuntingYard(Jep jep, List<GrammarMatcher> list) {
        this.nf = jep.getNodeFactory();
        this.jep = jep;
        this.matchers = list;
        implicitMul.setPrecedence(jep.getOperatorTable().getMultiply().getPrecedence());
    }

    @Override
    public Node parse(Iterator<Token> iterator) throws ParseException {
        Node node;
        if (!iterator.hasNext()) {
            return null;
        }
        if (this.it == null) {
            this.it = new Lookahead2Iterator<Token>(iterator);
        } else {
            this.it.setInputIterator(iterator);
        }
        try {
            node = this.parseSubExpression();
        }
        catch (ParseException parseException) {
            Token token = this.it.peekNext();
            if (parseException.getColumnNumber() < 0) {
                if (token != null) {
                    parseException.setPosition(token.getLineNumber(), token.getColumnNumber());
                } else {
                    token = this.it.prev();
                    int n = token.getLineNumber();
                    int n2 = token.getColumnNumber() + token.getLength();
                    parseException.setPosition(n, n2);
                }
            }
            throw parseException;
        }
        Token token = this.it.peekNext();
        if (token != null) {
            String string = token.toString();
            if (this.it.nextnext() != null) {
                string = string + ", " + this.it.nextnext();
            }
            ParseException parseException = new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.ShuntingYard.TokensRemainAfterParsing"), string), token.getLineNumber(), token.getColumnNumber());
            throw parseException;
        }
        if (!this.nodes.empty()) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.ShuntingYard.OnlyOneOperatorShouldBeOnStack"), this.nodes.size()));
        }
        return node;
    }

    @Override
    public Node parseSubExpression() throws ParseException {
        this.ops.push(sentinel);
        this.expression();
        Operator operator = this.ops.pop();
        if (!sentinel.equals(operator)) {
            throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.ShuntingYard.TopOfOperatorStackShouldBeASentinel"), operator.toString()));
        }
        return this.nodes.pop();
    }

    protected void expression() throws ParseException {
        this.prefixSuffix();
        Token token = this.it.peekNext();
        while (token != null) {
            if (token.isBinary()) {
                this.pushOp(((OperatorToken)token).getBinaryOp(), token);
                this.it.consume();
                this.prefixSuffix();
            } else if (token.isTernary()) {
                OperatorToken operatorToken = (OperatorToken)token;
                Operator operator = operatorToken.getTernaryOp();
                this.pushOp(operator, operatorToken);
                this.it.consume();
                this.prefixSuffix();
            } else {
                if (!token.isImplicitMulRhs()) break;
                if (!this.jep.getImplicitMul()) {
                    throw new ParseException(JepMessages.getString("configurableparser.ShuntingYard.ImplicitMultiplicationNotEnabled"), token.getLineNumber(), token.getColumnNumber());
                }
                this.pushOp(implicitMul, token);
                this.prefixSuffix();
            }
            token = this.it.peekNext();
        }
        while (!sentinel.equals(this.ops.peek())) {
            this.popOp();
        }
    }

    @Override
    public Node parsePrefixSuffix() throws ParseException {
        this.ops.push(sentinel);
        PrefixRes prefixRes = this.prefixSuffixUnchecked();
        while (!sentinel.equals(this.ops.peek())) {
            this.popOp();
        }
        Operator operator = this.ops.pop();
        if (!sentinel.equals(operator)) {
            throw new ParseException(String.format(JepMessages.getString("configurableparser.ShuntingYard.TopOfOperatorStackShouldBeASentinel"), operator.toString()));
        }
        if (prefixRes == PrefixRes.OK) {
            return this.nodes.pop();
        }
        return null;
    }

    protected void prefixSuffix() throws ParseException {
        Token token;
        this.prefix();
        while ((token = this.it.peekNext()) != null && token.isSuffix()) {
            this.pushOp(((OperatorToken)token).getSuffixOp(), token);
            this.it.consume();
        }
    }

    protected PrefixRes prefixSuffixUnchecked() throws ParseException {
        Token token;
        PrefixRes prefixRes = this.prefixUnchecked();
        if (prefixRes != PrefixRes.OK) {
            return prefixRes;
        }
        while ((token = this.it.peekNext()) != null && token.isSuffix()) {
            this.pushOp(((OperatorToken)token).getSuffixOp(), token);
            this.it.consume();
        }
        return PrefixRes.OK;
    }

    protected PrefixRes prefixUnchecked() throws ParseException {
        Token token = this.it.peekNext();
        if (token == null) {
            return PrefixRes.EMPTY;
        }
        for (GrammarMatcher grammarMatcher : this.matchers) {
            Node node = grammarMatcher.match(this.it, this);
            if (node == null) continue;
            this.nodes.push(node);
            return PrefixRes.OK;
        }
        if (token.isIdentifier()) {
            this.it.consume();
            this.nodes.push(this.nf.buildVariableNodeCheckUndeclared(token.getSource()));
        } else if (token.isNumber()) {
            this.it.consume();
            this.nodes.push(this.nf.buildConstantNode(((NumberToken)token).getValue()));
        } else if (token.isString()) {
            this.it.consume();
            this.nodes.push(this.nf.buildConstantNode(((StringToken)token).getCompleteString()));
        } else if (token.isPrefix()) {
            this.pushOp(((OperatorToken)token).getPrefixOp(), token);
            this.it.consume();
            Object object = this.prefixUnchecked();
            if (object != PrefixRes.OK) {
                return object;
            }
        } else {
            return PrefixRes.UNEXPECTED;
        }
        return PrefixRes.OK;
    }

    protected void prefix() throws ParseException {
        PrefixRes prefixRes = this.prefixUnchecked();
        switch (prefixRes) {
            case OK: {
                return;
            }
            case EMPTY: {
                throw new ParseException(JepMessages.getString("configurableparser.ShuntingYard.UnexpectedEndOfInput"));
            }
            case UNEXPECTED: {
                Token token = this.it.peekNext();
                throw new GrammarException(JepMessages.getString("configurableparser.ShuntingYard.UnexpectedToken"), token);
            }
        }
    }

    protected void pushOp(Operator operator, Token token) throws ParseException {
        while (this.compareOps(this.ops.peek(), operator)) {
            this.popOp();
        }
        this.ops.push(operator);
    }

    protected boolean compareOps(Operator operator, Operator operator2) {
        if (operator.isTernary() && operator2.isTernary()) {
            return operator instanceof TernaryOperator.RhsTernaryOperator && operator2 instanceof TernaryOperator.RhsTernaryOperator;
        }
        if (operator == sentinel) {
            return false;
        }
        if (operator2 == sentinel) {
            return true;
        }
        if (operator2.isPrefix() && operator.isBinary()) {
            return false;
        }
        if (operator.getPrecedence() < operator2.getPrecedence()) {
            return true;
        }
        return operator.getPrecedence() == operator2.getPrecedence() && operator.isLeftBinding();
    }

    protected void popOp() throws ParseException {
        Operator operator = this.ops.pop();
        if (operator == implicitMul) {
            Node node = this.nodes.pop();
            Node node2 = this.nodes.pop();
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(this.jep.getOperatorTable().getMultiply(), node2, node);
            this.nodes.push(aSTOpNode);
        } else if (operator.isBinary()) {
            Node node = this.nodes.pop();
            Node node3 = this.nodes.pop();
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(operator, node3, node);
            this.nodes.push(aSTOpNode);
        } else if (operator.isUnary()) {
            Node node = this.nodes.pop();
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(operator, node);
            this.nodes.push(aSTOpNode);
        } else if (operator.isTernary() && operator instanceof TernaryOperator.RhsTernaryOperator) {
            Operator operator2 = this.ops.pop();
            if (!(operator2 instanceof TernaryOperator) || !((TernaryOperator)operator2).getRhsOperator().equals(operator)) {
                throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.ShuntingYard.NextOperatorShouldHaveBeenMatchingTernaryOp"), operator2.getName()));
            }
            Node node = this.nodes.pop();
            Node node4 = this.nodes.pop();
            Node node5 = this.nodes.pop();
            ASTOpNode aSTOpNode = this.nf.buildOperatorNode(operator2, node5, node4, node);
            this.nodes.push(aSTOpNode);
        } else {
            throw new ParseException(MessageFormat.format(JepMessages.getString("configurableparser.ShuntingYard.InvalidOperatorOnStack"), operator.getSymbol()));
        }
    }

    protected void dumpState(String string) {
        System.out.println(string + "\t" + this.it.peekNext() + "\t" + this.it.nextnext());
        System.out.println("Nodes: " + this.nodes.toString());
        System.out.print("Ops: [");
        for (Operator operator : this.ops) {
            System.out.print(operator.getName() + " ");
        }
        System.out.println("]");
        System.out.println();
    }

    public Lookahead2Iterator<Token> getIterator() {
        return this.it;
    }

    @Override
    public void setIterator(Lookahead2Iterator<Token> lookahead2Iterator) {
        this.it = lookahead2Iterator;
    }

    public static class ShuntingYardGrammarParserFactory
    implements GrammarParserFactory {
        private static final long serialVersionUID = 340L;

        @Override
        public GrammarParser newInstance(ConfigurableParser configurableParser) {
            return new ShuntingYard(configurableParser.getJep(), configurableParser.getGrammarMatchers());
        }

        @Override
        public void init(Jep jep) {
        }

        @Override
        public JepComponent getLightWeightInstance() {
            return this;
        }
    }

    protected static enum PrefixRes {
        OK,
        EMPTY,
        UNEXPECTED;

    }
}

