/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.configurableparser.matchers;

import com.singularsys.jep.Jep;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.NodeFactory;
import com.singularsys.jep.ParseException;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.configurableparser.GrammarParser;
import com.singularsys.jep.configurableparser.Lookahead2Iterator;
import com.singularsys.jep.configurableparser.matchers.GrammarException;
import com.singularsys.jep.configurableparser.matchers.GrammarMatcher;
import com.singularsys.jep.configurableparser.tokens.FunctionToken;
import com.singularsys.jep.configurableparser.tokens.TerminatorToken;
import com.singularsys.jep.configurableparser.tokens.Token;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.ArrayList;

public class FunctionGrammarMatcher
implements GrammarMatcher {
    private static final long serialVersionUID = 300L;
    private final Token open;
    private final Token close;
    private final Token comma;
    private transient NodeFactory nf;

    public FunctionGrammarMatcher(Token token, Token token2, Token token3) {
        this.open = token;
        this.close = token2;
        this.comma = token3;
    }

    @Override
    public void init(Jep jep) {
        this.nf = jep.getNodeFactory();
    }

    protected Token errorToken(Lookahead2Iterator<Token> lookahead2Iterator) {
        Token token = lookahead2Iterator.peekNext();
        if (token == null) {
            Token token2 = lookahead2Iterator.prev();
            token = new TerminatorToken(JepMessages.getString("configurableparser.matchers.FunctionGrammarMatcher.TerminatorTokenName"));
            token.setPosition(token2.getLineNumber(), token2.getColumnNumber());
        }
        return token;
    }

    @Override
    public Node match(Lookahead2Iterator<Token> lookahead2Iterator, GrammarParser grammarParser) throws ParseException {
        ArrayList<Node> arrayList;
        PostfixMathCommandI postfixMathCommandI;
        String string;
        block9: {
            Token token = lookahead2Iterator.peekNext();
            if (token == null) {
                return null;
            }
            if (!token.isFunction()) {
                return null;
            }
            string = token.getSource();
            postfixMathCommandI = ((FunctionToken)token).getPfmc();
            if (!this.open.equals(lookahead2Iterator.nextnext())) {
                return null;
            }
            lookahead2Iterator.consume();
            lookahead2Iterator.consume();
            if (this.close.equals(lookahead2Iterator.peekNext())) {
                if (!postfixMathCommandI.checkNumberOfParameters(0)) {
                    int n = postfixMathCommandI.getNumberOfParameters();
                    if (n >= 0) {
                        throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), postfixMathCommandI.getName(), n, 0), this.errorToken(lookahead2Iterator));
                    }
                    throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), postfixMathCommandI.getName(), 0), this.errorToken(lookahead2Iterator));
                }
                lookahead2Iterator.consume();
                return this.nf.buildFunctionNode(string, postfixMathCommandI, new Node[0]);
            }
            arrayList = new ArrayList<Node>();
            while (true) {
                Node node = grammarParser.parseSubExpression();
                arrayList.add(node);
                if (this.close.equals(lookahead2Iterator.peekNext())) break block9;
                if (!this.comma.equals(lookahead2Iterator.peekNext())) break;
                lookahead2Iterator.consume();
            }
            throw new GrammarException(MessageFormat.format(JepMessages.getString("configurableparser.matchers.FunctionGrammarMatcher.Function"), postfixMathCommandI.getName()), this.close, this.errorToken(lookahead2Iterator));
        }
        lookahead2Iterator.consume();
        if (!postfixMathCommandI.checkNumberOfParameters(arrayList.size())) {
            int n = postfixMathCommandI.getNumberOfParameters();
            if (n >= 0) {
                throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionRequiresNArgumentsFoundN"), postfixMathCommandI.getName(), n, arrayList.size()), this.errorToken(lookahead2Iterator));
            }
            throw new GrammarException(MessageFormat.format(JepMessages.getString("FunctionIllegalNumberOfArguments"), postfixMathCommandI.getName(), arrayList.size()), lookahead2Iterator.prev());
        }
        return this.nf.buildFunctionNode(string, postfixMathCommandI, arrayList.toArray(new Node[arrayList.size()]));
    }
}

