/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.standard.Complex;
import java.text.MessageFormat;

public class Comparative
extends BinaryFunction {
    private static final long serialVersionUID = 300L;
    private final int id;
    double tolerance;
    public static final int LT = 0;
    public static final int GT = 1;
    public static final int LE = 2;
    public static final int GE = 3;
    public static final int NE = 4;
    public static final int EQ = 5;

    public int getId() {
        return this.id;
    }

    public Comparative(int n) {
        this(n, 1.0E-6);
    }

    public Comparative(int n, double d) {
        this.id = n;
        this.tolerance = d;
        switch (n) {
            case 0: {
                this.setName("lt");
                break;
            }
            case 1: {
                this.setName("gt");
                break;
            }
            case 2: {
                this.setName("le");
                break;
            }
            case 3: {
                this.setName("ge");
                break;
            }
            case 4: {
                this.setName("ne");
                break;
            }
            case 5: {
                this.setName("eq");
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(n));
            }
        }
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        if (this.compare(object, object2)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public boolean compare(Object object, Object object2) throws EvaluationException {
        switch (this.id) {
            case 0: {
                return this.lt(object, object2);
            }
            case 1: {
                return this.gt(object, object2);
            }
            case 2: {
                return this.le(object, object2);
            }
            case 3: {
                return this.ge(object, object2);
            }
            case 4: {
                return this.ne(object, object2);
            }
            case 5: {
                return this.eq(object, object2);
            }
        }
        return false;
    }

    public boolean lt(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 < (d = ((Number)object2).doubleValue());
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareTo(string2) < 0;
        }
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Comparative.NotDefinedForComplexNumbers"), this.getName()));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
    }

    public boolean gt(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 > (d = ((Number)object2).doubleValue());
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareTo(string2) > 0;
        }
        if (object instanceof Complex || object2 instanceof Complex) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Comparative.NotDefinedForComplexNumbers"), this.getName()));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
    }

    public boolean le(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 <= (d = ((Number)object2).doubleValue());
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareTo(string2) <= 0;
        }
        if ((object instanceof Complex || object2 instanceof Complex) && (object instanceof Complex || object2 instanceof Complex)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Comparative.NotDefinedForComplexNumbers"), this.getName()));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
    }

    public boolean ge(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 >= (d = ((Number)object2).doubleValue());
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareTo(string2) >= 0;
        }
        if ((object instanceof Complex || object2 instanceof Complex) && (object instanceof Complex || object2 instanceof Complex)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Comparative.NotDefinedForComplexNumbers"), this.getName()));
        }
        throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
    }

    public boolean eq(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 == (d = ((Number)object2).doubleValue());
        }
        if (object instanceof Complex && object2 instanceof Complex) {
            return ((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return ((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return ((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 == (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d = ((Number)object).doubleValue();
            double d3 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d == d3;
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.equals(string2);
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d = (Boolean)object != false ? 1.0 : 0.0;
            double d4 = ((Number)object2).doubleValue();
            return d == d4;
        }
        if (object == null) {
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
        return object.equals(object2);
    }

    public boolean ne(Object object, Object object2) throws EvaluationException {
        if (object instanceof Number && object2 instanceof Number) {
            double d;
            double d2 = ((Number)object).doubleValue();
            return d2 != (d = ((Number)object2).doubleValue());
        }
        if (object instanceof Complex && object2 instanceof Complex) {
            return !((Complex)object).equals((Complex)object2, this.tolerance);
        }
        if (object instanceof Complex && object2 instanceof Number) {
            return !((Complex)object).equals(new Complex((Number)object2), this.tolerance);
        }
        if (object2 instanceof Complex && object instanceof Number) {
            return !((Complex)object2).equals(new Complex((Number)object), this.tolerance);
        }
        if (object instanceof Boolean && object2 instanceof Boolean) {
            boolean bl;
            boolean bl2 = (Boolean)object;
            return bl2 != (bl = ((Boolean)object2).booleanValue());
        }
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            String string2 = (String)object2;
            return !string.equals(string2);
        }
        if (object instanceof Number && object2 instanceof Boolean) {
            double d = ((Number)object).doubleValue();
            double d3 = (Boolean)object2 != false ? 1.0 : 0.0;
            return d != d3;
        }
        if (object instanceof Boolean && object2 instanceof Number) {
            double d = (Boolean)object != false ? 1.0 : 0.0;
            double d4 = ((Number)object2).doubleValue();
            return d != d4;
        }
        if (object == null) {
            throw new IllegalParameterException((PostfixMathCommand)this, object, object2);
        }
        return !object.equals(object2);
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }
}

