/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.LValueI;
import com.singularsys.jep.functions.NaryFunction;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Vector;

public class Ele
extends NaryFunction
implements LValueI {
    private static final long serialVersionUID = 340L;
    protected int indexShift = 1;

    public Ele() {
        this.numberOfParameters = -1;
    }

    public Ele(boolean bl) {
        this.numberOfParameters = -1;
        this.indexShift = bl ? 0 : 1;
    }

    @Override
    public boolean checkNumberOfParameters(int n) {
        return n >= 2;
    }

    @Override
    public void set(Evaluator evaluator, Node node, Object object) throws EvaluationException {
        Node node2 = node.jjtGetChild(0);
        if (!(node2 instanceof ASTVarNode)) {
            throw new EvaluationException(JepMessages.getString("functions.Ele.LhsMustBeAVariable"));
        }
        Variable variable = this.getVariable(evaluator, (ASTVarNode)node2);
        if (node.jjtGetNumChildren() == 2) {
            Object object2;
            Object object3 = evaluator.eval(node.jjtGetChild(1));
            int n = -1;
            if (object3 instanceof Number) {
                n = ((Number)object3).intValue() - 1;
            } else if (object3 instanceof Vector) {
                object2 = (Vector)object3;
                if (((Vector)object2).size() != 1) {
                    throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.OnlySingleDimArraysSupported"), object3.toString()));
                }
                if (!(((Vector)object2).firstElement() instanceof Number)) {
                    throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.RhsMustBeANumber"), object3.toString()));
                }
                n = ((Number)((Vector)object2).firstElement()).intValue() - this.indexShift;
            } else {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.RhsMustBeANumber"), object3));
            }
            object2 = variable.getValue();
            if (!(object2 instanceof Vector)) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.VariableMustBeAVector"), variable.getName(), object2.toString()));
            }
            Vector<Object> vector = new Vector<Object>((Vector)object2);
            if (n >= vector.size() || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            vector.set(n, object);
            variable.setValue(vector);
        } else {
            Object object4;
            int[] nArray = new int[node.jjtGetNumChildren() - 1];
            for (int i = 0; i < nArray.length; ++i) {
                object4 = evaluator.eval(node.jjtGetChild(i + 1));
                if (!(object4 instanceof Number)) {
                    throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexShouldBeAnInteger"), object4.toString()));
                }
                nArray[i] = ((Number)object4).intValue() - this.indexShift;
            }
            Object object5 = variable.getValue();
            if (!(object5 instanceof Vector)) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.VariableMustBeAVector"), variable.getName(), object5.toString()));
            }
            object4 = this.setEle(object5, nArray, 0, object);
            variable.setValue(object4);
        }
    }

    Object setEle(Object object, int[] nArray, int n, Object object2) throws EvaluationException {
        Vector<Object> vector = new Vector<Object>((Vector)object);
        int n2 = nArray[n];
        if (n2 < 0 || n2 >= vector.size()) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n2 + this.indexShift));
        }
        if (n == nArray.length - 1) {
            vector.set(n2, object2);
        } else {
            Object object3 = this.setEle(vector.get(n2), nArray, n + 1, object2);
            vector.set(n2, object3);
        }
        return vector;
    }

    @Override
    public Object eval(Object[] objectArray) throws EvaluationException {
        return this.ele(objectArray);
    }

    public Object ele(Object[] objectArray) throws EvaluationException {
        switch (objectArray.length) {
            case 2: {
                return this.ele(objectArray[0], objectArray[1]);
            }
            case 3: {
                return this.ele(objectArray[0], objectArray[1], objectArray[2]);
            }
        }
        Object[] objectArray2 = new Object[objectArray.length - 1];
        System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
        return this.ele(objectArray[0], objectArray2);
    }

    public Object ele(Object object, Object object2) throws EvaluationException {
        Vector vector;
        if (!(object instanceof Vector)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.LhsMustBeAVector"), object));
        }
        Vector vector2 = (Vector)object;
        int n = -1;
        if (object2 instanceof Vector) {
            vector = (Vector)object2;
            if (vector.size() != 1) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.OnlySingleDimArraysSupported"), object2.toString()));
            }
            n = ((Number)vector.firstElement()).intValue() - this.indexShift;
        } else {
            n = this.asStrictInt(2, object2) - this.indexShift;
        }
        if (n >= vector2.size() || n < 0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
        }
        vector = vector2.elementAt(n);
        return vector;
    }

    public Object ele(Object object, Object object2, Object object3) throws EvaluationException {
        if (!(object instanceof Vector)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.LhsMustBeAVector"), object.toString()));
        }
        int n = this.asStrictInt(1, object2) - this.indexShift;
        int n2 = this.asStrictInt(2, object3) - this.indexShift;
        if (n >= ((Vector)object).size() || n < 0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
        }
        Object e = ((Vector)object).elementAt(n);
        if (!(e instanceof Vector)) {
            throw new EvaluationException(JepMessages.getString("functions.Ele.LhsMustBeAVectorOfVectors"));
        }
        if (n2 >= ((Vector)e).size() || n2 < 0) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n2 + this.indexShift));
        }
        Object e2 = ((Vector)e).elementAt(n2);
        return e2;
    }

    public Object ele(Object object, Object[] objectArray) throws EvaluationException {
        Object object2 = object;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(object2 instanceof Vector)) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.MissMatchInDimensions"), object.toString(), Arrays.toString(objectArray)));
            }
            int n = this.asStrictInt(i + 1, objectArray[i]) - this.indexShift;
            Vector vector = (Vector)object2;
            if (vector.size() <= n || n < 0) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("functions.Ele.IndexOutOfRange"), n + this.indexShift));
            }
            object2 = vector.elementAt(n);
        }
        return object2;
    }

    protected Variable getVariable(Evaluator evaluator, ASTVarNode aSTVarNode) {
        return aSTVarNode.getVar();
    }
}

