/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.IllegalParameterException;
import com.singularsys.jep.functions.PostfixMathCommand;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.reals.RealUnaryFunction;
import com.singularsys.jep.standard.Complex;

public class LogBase2
extends UnaryFunction
implements RealUnaryFunction {
    private static final long serialVersionUID = 330L;
    boolean strict = false;
    private final double LOGN;
    private final Complex CLOGN;

    public LogBase2() {
        this.LOGN = Math.log(2.0);
        this.CLOGN = new Complex(this.LOGN, 0.0);
    }

    public LogBase2(boolean bl) {
        this();
        this.strict = bl;
    }

    public LogBase2(double d, boolean bl) {
        this.LOGN = Math.log(d);
        this.CLOGN = new Complex(this.LOGN, 0.0);
        this.strict = bl;
    }

    @Override
    public Object eval(Object object) throws EvaluationException {
        return this.logbase2(object);
    }

    public Object logbase2(Object object) throws EvaluationException {
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            if (d >= 0.0) {
                return Math.log(d) / this.LOGN;
            }
            if (Double.isNaN(d)) {
                return NaN;
            }
            if (this.strict) {
                return NaN;
            }
            Complex complex = new Complex(d);
            return complex.log().div(this.CLOGN);
        }
        if (object instanceof Complex) {
            return ((Complex)object).log().div(this.CLOGN);
        }
        throw new IllegalParameterException((PostfixMathCommand)this, 0, object);
    }

    @Override
    public double evaluate(double d) {
        return Math.log(d) / this.LOGN;
    }
}

