/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.misc.functions;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.functions.BinaryFunction;
import com.singularsys.jep.reals.RealBinaryFunction;

public class Remainder
extends BinaryFunction
implements RealBinaryFunction {
    private static final long serialVersionUID = 300L;
    Type type;

    public Remainder(Type type) {
        this.type = type;
    }

    @Override
    public Object eval(Object object, Object object2) throws EvaluationException {
        double d = this.asDouble(0, object);
        double d2 = this.asDouble(1, object2);
        return this.evaluate(d, d2);
    }

    @Override
    public double evaluate(double d, double d2) {
        double d3 = d % d2;
        switch (this.type) {
            case EUCLIDEAN: {
                if (!(d3 < 0.0)) break;
                if (d2 > 0.0) {
                    d3 += d2;
                    break;
                }
                d3 -= d2;
                break;
            }
            case FLOOR: {
                if (!(d3 > 0.0 && d2 < 0.0) && (!(d3 < 0.0) || !(d2 > 0.0))) break;
                d3 += d2;
                break;
            }
            case TRUNCATED: {
                break;
            }
            case EUCLIDEAN_QUOTIENT: {
                if (d3 < 0.0) {
                    d3 = d2 > 0.0 ? (d3 += d2) : (d3 -= d2);
                }
                d3 = (d - d3) / d2;
                break;
            }
            case FLOOR_QUOTIENT: {
                if (d3 > 0.0 && d2 < 0.0 || d3 < 0.0 && d2 > 0.0) {
                    d3 += d2;
                }
                d3 = (d - d3) / d2;
                break;
            }
            case TRUNCATED_QUOTIENT: {
                d3 = (d - d3) / d2;
            }
        }
        return d3;
    }

    public static enum Type {
        TRUNCATED,
        FLOOR,
        EUCLIDEAN,
        TRUNCATED_QUOTIENT,
        FLOOR_QUOTIENT,
        EUCLIDEAN_QUOTIENT;

    }
}

