/*
 * Decompiled with CFR 0.152.
 */
package com.singularsys.jep.standard;

import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.Evaluator;
import com.singularsys.jep.Jep;
import com.singularsys.jep.JepComponent;
import com.singularsys.jep.JepException;
import com.singularsys.jep.JepMessages;
import com.singularsys.jep.ParserVisitor;
import com.singularsys.jep.PostfixMathCommandI;
import com.singularsys.jep.Variable;
import com.singularsys.jep.functions.CallbackEvaluationI;
import com.singularsys.jep.parser.ASTConstant;
import com.singularsys.jep.parser.ASTFunNode;
import com.singularsys.jep.parser.ASTOpNode;
import com.singularsys.jep.parser.ASTVarNode;
import com.singularsys.jep.parser.Node;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.MessageFormat;
import java.util.Stack;

public final class StandardEvaluator
implements Evaluator,
ParserVisitor {
    private static final long serialVersionUID = 300L;
    protected transient Stack<Object> stack = new Stack();
    private boolean trapNullValues = true;
    private boolean trapNaN = false;
    private boolean trapInfinity = false;

    @Override
    public void init(Jep jep) {
    }

    @Override
    public Object eval(Node node) throws EvaluationException {
        try {
            node.jjtAccept(this, null);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
        Object object = this.stack.pop();
        return object;
    }

    @Override
    public Object evaluate(Node node) throws EvaluationException {
        this.stack.clear();
        try {
            node.jjtAccept(this, null);
        }
        catch (EvaluationException evaluationException) {
            throw evaluationException;
        }
        catch (JepException jepException) {
            throw new EvaluationException(jepException);
        }
        if (this.stack.size() != 1) {
            throw new EvaluationException(JepMessages.getString("standard.StandardEvaluator.StackCorrupted"));
        }
        Object object = this.stack.pop();
        return object;
    }

    void nodeAccept(Node node) throws EvaluationException {
        switch (node.getId()) {
            case 2: {
                this.visitFun(node);
                break;
            }
            case 3: {
                this.visitVar(node);
                break;
            }
            case 4: {
                this.visitFun(node);
                break;
            }
            case 5: {
                this.visitConstant(node);
            }
        }
    }

    @Override
    public Object visit(ASTConstant aSTConstant, Object object) throws EvaluationException {
        return this.visitConstant(aSTConstant);
    }

    public Object visitConstant(Node node) throws EvaluationException {
        Object object = node.getValue();
        if (this.trapNullValues && object == null) {
            throw new EvaluationException(JepMessages.getString("standard.StandardEvaluator.NullConstantValue"));
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(JepMessages.getString("standard.StandardEvaluator.NaNConstantValue"));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.InfiniteConstantValue"), object.toString()));
        }
        this.stack.push(object);
        return null;
    }

    @Override
    public Object visit(ASTFunNode aSTFunNode, Object object) throws EvaluationException {
        this.visitFun(aSTFunNode);
        return null;
    }

    @Override
    public Object visit(ASTVarNode aSTVarNode, Object object) throws EvaluationException {
        this.visitVar(aSTVarNode);
        return null;
    }

    public Object visitVar(Node node) throws EvaluationException {
        Variable variable = node.getVar();
        assert (variable != null);
        if (!variable.hasValidValue()) {
            String string = MessageFormat.format(JepMessages.getString("standard.FastEvaluator.CouldNotEvaluateVariableNoValueSet"), variable.getName());
            throw new EvaluationException(string);
        }
        Object object = variable.getValue();
        if (this.trapNullValues && object == null) {
            String string = MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.CouldNotEvaluateVariableNullValue"), variable.getName());
            throw new EvaluationException(string);
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NaNValueForVariable"), variable.getName()));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.InfiniteValueForVariable"), object.toString(), variable.getName()));
        }
        this.stack.push(object);
        return null;
    }

    @Override
    public Object visit(ASTOpNode aSTOpNode, Object object) throws EvaluationException {
        this.visitFun(aSTOpNode);
        return null;
    }

    protected void visitFun(Node node) throws EvaluationException {
        Object object;
        int n;
        PostfixMathCommandI postfixMathCommandI = node.getPFMC();
        if (postfixMathCommandI == null) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NoFunctionClass"), node.getName()));
        }
        if (postfixMathCommandI instanceof CallbackEvaluationI) {
            Object object2 = ((CallbackEvaluationI)((Object)postfixMathCommandI)).evaluate(node, this);
            if (this.trapNullValues && object2 == null) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NullFunctionValue"), node.getName()));
            }
            if (this.trapNaN && (object2 instanceof Double && ((Double)object2).isNaN() || object2 instanceof Float && ((Float)object2).isNaN())) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NaNValueForFunction"), node.getName()));
            }
            if (this.trapInfinity && (object2 instanceof Double && ((Double)object2).isInfinite() || object2 instanceof Float && ((Float)object2).isInfinite())) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.InfiniteValueForFunction"), node.getName(), object2.toString()));
            }
            this.stack.push(object2);
            return;
        }
        int n2 = node.jjtGetNumChildren();
        for (n = 0; n < n2; ++n) {
            object = node.jjtGetChild(n);
            try {
                object.jjtAccept(this, null);
                continue;
            }
            catch (EvaluationException evaluationException) {
                throw evaluationException;
            }
            catch (JepException jepException) {
                throw new EvaluationException(jepException);
            }
        }
        n = postfixMathCommandI.getNumberOfParameters();
        if (n != -1) {
            if (n != n2) {
                throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.IncorrectNumberOfArgumentsExpected"), node.getName(), n2, n));
            }
        } else if (!postfixMathCommandI.checkNumberOfParameters(n2)) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.IncorrectNumberOfArguments"), node.getName(), n2));
        }
        postfixMathCommandI.setCurNumberOfParameters(n2);
        postfixMathCommandI.run(this.stack);
        object = this.stack.peek();
        if (this.trapNullValues && object == null) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NullFunctionValue"), node.getName()));
        }
        if (this.trapNaN && (object instanceof Double && ((Double)object).isNaN() || object instanceof Float && ((Float)object).isNaN())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.NaNValueForFunction"), node.getName()));
        }
        if (this.trapInfinity && (object instanceof Double && ((Double)object).isInfinite() || object instanceof Float && ((Float)object).isInfinite())) {
            throw new EvaluationException(MessageFormat.format(JepMessages.getString("standard.StandardEvaluator.InfiniteValueForFunction"), node.getName(), object.toString()));
        }
    }

    public boolean isTrapNullValues() {
        return this.trapNullValues;
    }

    public void setTrapNullValues(boolean bl) {
        this.trapNullValues = bl;
    }

    public boolean isTrapNaN() {
        return this.trapNaN;
    }

    public void setTrapNaN(boolean bl) {
        this.trapNaN = bl;
    }

    public boolean isTrapInfinity() {
        return this.trapInfinity;
    }

    public void setTrapInfinity(boolean bl) {
        this.trapInfinity = bl;
    }

    @Override
    public JepComponent getLightWeightInstance() {
        StandardEvaluator standardEvaluator = new StandardEvaluator();
        standardEvaluator.trapNullValues = this.trapNullValues;
        return standardEvaluator;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.stack = new Stack();
    }
}

