/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.base;

import com.singularsys.extensions.xjep.XJep;
import com.singularsys.jep.EvaluationException;
import com.singularsys.jep.JepException;
import com.singularsys.jep.functions.UnaryFunction;
import com.singularsys.jep.parser.Node;
import com.singularsys.jep.parser.TokenMgrError;
import de.didappslib.base.Document;
import de.didappslib.base.Statics;
import de.didappslib.base.ZusatzDefsAnzeige;
import de.didappslib.calculation.Interpolation;
import de.didappslib.guitools.AutoDialog;
import de.didappslib.guitools.GreekLetterConstPanel;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ZusatzDef {
    public static final ResourceBundle RBUNDLE = ResourceBundle.getBundle("de/didappslib/base/resources/ZusatzDefs", Statics.locale);
    public String name;
    public String art;
    public String definition = "";
    public double xmin = -10.0;
    public double xmax = 10.0;
    public List<Double> xDat = new ArrayList<Double>();
    public List<Double> yDat = new ArrayList<Double>();
    public int interpolation = 0;
    public String bedingung = "t<5";
    public String positiv = "0";
    public String negativ = "1";

    public ZusatzDef() {
        this.name = RBUNDLE.getString("neueVar");
        this.art = RBUNDLE.getString("Variable");
    }

    public void writeDef(ObjectOutputStream objstr) throws Exception {
        objstr.writeUTF(this.name);
        if (this.art.equals(RBUNDLE.getString("Konstante"))) {
            objstr.writeUTF("Konstante");
        }
        if (this.art.equals(RBUNDLE.getString("Variable"))) {
            objstr.writeUTF("Variable");
        }
        if (this.art.equals(RBUNDLE.getString("Funktion"))) {
            objstr.writeUTF("Funktion");
        }
        if (this.art.equals(RBUNDLE.getString("Tabellenfkt"))) {
            objstr.writeUTF("Tabellenfkt.");
        }
        if (this.art.equals(RBUNDLE.getString("Bedingte_Var"))) {
            objstr.writeUTF("Bedingte Var.");
        }
        objstr.writeUTF(this.definition);
        objstr.writeDouble(this.xmin);
        objstr.writeDouble(this.xmax);
        objstr.writeInt(this.xDat.size());
        for (Double xDat1 : this.xDat) {
            objstr.writeDouble(xDat1);
        }
        objstr.writeInt(this.yDat.size());
        for (Double yDat1 : this.yDat) {
            objstr.writeDouble(yDat1);
        }
        objstr.writeInt(this.interpolation);
        objstr.writeUTF(this.bedingung);
        objstr.writeUTF(this.positiv);
        objstr.writeUTF(this.negativ);
    }

    public static ZusatzDef readDef(ObjectInputStream objstr) throws Exception {
        int i;
        ZusatzDef def = new ZusatzDef();
        def.name = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        def.art = objstr.readUTF();
        if (def.art.equals("Konstante")) {
            def.art = RBUNDLE.getString("Konstante");
        }
        if (def.art.equals("Variable")) {
            def.art = RBUNDLE.getString("Variable");
        }
        if (def.art.equals("Funktion")) {
            def.art = RBUNDLE.getString("Funktion");
        }
        if (def.art.equals("Tabellenfkt.")) {
            def.art = RBUNDLE.getString("Tabellenfkt");
        }
        if (def.art.equals("Bedingte Var.")) {
            def.art = RBUNDLE.getString("Bedingte_Var");
        }
        def.definition = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        def.definition = def.definition.replaceAll("x'", "var");
        def.xmin = objstr.readDouble();
        def.xmax = objstr.readDouble();
        int size = objstr.readInt();
        for (i = 0; i < size; ++i) {
            def.xDat.add(objstr.readDouble());
        }
        size = objstr.readInt();
        for (i = 0; i < size; ++i) {
            def.yDat.add(objstr.readDouble());
        }
        def.interpolation = objstr.readInt();
        def.bedingung = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        def.positiv = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        def.negativ = GreekLetterConstPanel.applySmartInputOnLoad(objstr.readUTF());
        return def;
    }

    public boolean parse(Document document, XJep parser, ZusatzDefsAnzeige zdefs, boolean verbose) {
        block31: {
            Object s;
            ZusatzDef zd;
            block30: {
                block29: {
                    block28: {
                        Node node;
                        block27: {
                            zd = this;
                            s = GreekLetterConstPanel.refactorStr(zd.definition);
                            if (((String)s).contains("#")) {
                                s = ((String)s).substring(0, ((String)s).indexOf("#")).replace("\n", "").trim();
                            }
                            if (zd.art.equals(RBUNDLE.getString("Konstante"))) {
                                try {
                                    node = parser.parse((String)s);
                                    parser.preprocess(node);
                                    parser.addConstant(GreekLetterConstPanel.refactorStr(zd.name), parser.evaluate(node));
                                }
                                catch (StackOverflowError e) {
                                    document.errorMsg("", "", null, false);
                                }
                                catch (TokenMgrError | Exception e) {
                                    document.errorMsg(RBUNDLE.getString("Fehler_bei_den_weiteren_Definitionen!"), e.toString(), null, verbose);
                                    if (!verbose) break block27;
                                    return false;
                                }
                            }
                        }
                        if (zd.art.equals(RBUNDLE.getString("Variable"))) {
                            s = GreekLetterConstPanel.refactorStr(zd.name) + "=" + (String)s;
                            try {
                                node = parser.parse((String)s);
                                parser.preprocess(node);
                            }
                            catch (StackOverflowError e) {
                                document.errorMsg("", "", null, false);
                            }
                            catch (TokenMgrError | Exception e) {
                                document.errorMsg(RBUNDLE.getString("Fehler_bei_den_weiteren_Definitionen!"), e.toString(), null, verbose);
                                if (!verbose) break block28;
                                return false;
                            }
                        }
                    }
                    if (zd.art.equals("Funktion")) {
                        try {
                            Funktion fkt = new Funktion("\u01b6", ((String)s).replaceAll("var", "\u01b6"), parser);
                            parser.addFunction(GreekLetterConstPanel.refactorStr(zd.name), fkt);
                        }
                        catch (StackOverflowError ex) {
                            document.errorMsg("", ex.toString(), null, false);
                        }
                        catch (TokenMgrError | Exception ex) {
                            document.errorMsg(RBUNDLE.getString("Fehler_bei_der_Zusatzdefinition_von") + zd.name + "'!", ex.toString(), null, verbose);
                            if (!verbose) break block29;
                            return false;
                        }
                    }
                }
                if (zd.art.equals(RBUNDLE.getString("Tabellenfkt"))) {
                    if (document.getModel().verfahren == 3) {
                        document.getModel().verfahren = 2;
                        new AutoDialog(document.getViewer().getWindow()).display(RBUNDLE.getString("Achtung,_Sie_verwenden_eine_Tabellenfunktion!"), RBUNDLE.getString("Die_Schrittweitensteuerung_des_Runge-Kutta-Verfahrens_wird_ausgeschaltet"), Statics.rBundle.getString("OK"));
                        document.getModel().verfahren = 2;
                    }
                    double[] xd = new double[zd.xDat.size()];
                    double[] yd = new double[zd.xDat.size()];
                    try {
                        for (int ii = 0; ii < zd.xDat.size(); ++ii) {
                            xd[ii] = zd.xDat.get(ii);
                            yd[ii] = zd.yDat.get(ii);
                        }
                        TabFunktion fkt = new TabFunktion(xd, yd, zd.interpolation);
                        parser.addFunction(GreekLetterConstPanel.refactorStr(zd.name), fkt);
                    }
                    catch (StackOverflowError ex) {
                        document.errorMsg("", ex.toString(), null, false);
                    }
                    catch (TokenMgrError | Exception ex) {
                        document.errorMsg(RBUNDLE.getString("Fehler_bei_der_Zusatzdefinition_von") + zd.name + "'!", ex.toString(), null, verbose);
                        if (!verbose) break block30;
                        return false;
                    }
                }
            }
            if (zd.art.equals(RBUNDLE.getString("Bedingte_Var"))) {
                if (document.getModel().verfahren == 3) {
                    document.getModel().verfahren = 2;
                    document.documentPrefs.updateElements();
                    new AutoDialog(document.getViewer().getWindow()).display(RBUNDLE.getString("Achtung,_Sie_verwenden_eine_bedingte_Variable!"), RBUNDLE.getString("Die_Schrittweitensteuerung_des_Runge-Kutta-Verfahrens_wird_ausgeschaltet"), Statics.rBundle.getString("OK"));
                }
                try {
                    String sneg;
                    String spos;
                    String sbed = GreekLetterConstPanel.refactorStr(zd.bedingung);
                    if (sbed.contains("#")) {
                        sbed = sbed.substring(0, ((String)s).indexOf("#")).trim();
                    }
                    if ((spos = GreekLetterConstPanel.refactorStr(zd.positiv)).contains("#")) {
                        spos = spos.substring(0, ((String)s).indexOf("#")).trim();
                    }
                    if ((sneg = GreekLetterConstPanel.refactorStr(zd.negativ)).contains("#")) {
                        sneg = sneg.substring(0, ((String)s).indexOf("#")).trim();
                    }
                    s = GreekLetterConstPanel.refactorStr(zd.name) + "=if(" + sbed + "," + spos.replace(',', '.') + "," + sneg.replace(',', '.') + ")";
                    parser.preprocess(parser.parse((String)s));
                }
                catch (StackOverflowError e) {
                    document.errorMsg("", "", null, false);
                }
                catch (TokenMgrError | Exception ex) {
                    document.errorMsg(RBUNDLE.getString("Fehler_bei_der_Bedingung_von") + zd.name + "'!", ex.toString(), null, verbose);
                    if (!verbose) break block31;
                    return false;
                }
            }
        }
        return true;
    }

    class TabFunktion
    extends UnaryFunction {
        private final int interpolationType;
        private final Interpolation interpol = new Interpolation();

        public TabFunktion(double[] dataX, double[] dataY, int interp) {
            this.interpolationType = interp;
            switch (this.interpolationType) {
                case 0: {
                    this.interpol.calcLinearCoefficients(dataX, dataY, dataX.length - 1);
                    break;
                }
                case 1: {
                    this.interpol.calcPolynomCoefficients(dataX, dataY, dataX.length - 1);
                    break;
                }
                case 2: {
                    this.interpol.calcSplinesCoefficients(dataX, dataY, dataX.length - 1);
                }
            }
        }

        @Override
        public Object eval(Object l) throws EvaluationException {
            double x = this.asDouble(0, l);
            switch (this.interpolationType) {
                case 0: {
                    x = this.interpol.interpolateLinear(x);
                    break;
                }
                case 1: {
                    x = this.interpol.interpolatePolynom(x);
                    break;
                }
                case 2: {
                    x = this.interpol.interpolateSplines(x);
                }
            }
            return x;
        }
    }

    class Funktion
    extends UnaryFunction {
        private final XJep parser;
        private final Node node;
        private final String variableName;

        public Funktion(String var, String term, XJep p) throws JepException {
            this.variableName = var;
            this.parser = p;
            this.node = this.parser.parse(term);
        }

        @Override
        public Object eval(Object l) throws EvaluationException {
            double x = this.asDouble(0, l);
            try {
                this.parser.addVariable(this.variableName, x);
                return (Double)this.parser.evaluate(this.node);
            }
            catch (JepException ex) {
                return Double.NaN;
            }
        }
    }
}

