/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Statics;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class AutoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    ResourceBundle rbundle;
    JLabel typeLabel = new JLabel("");
    JTextArea textLabel = new JTextArea("");
    Icon programIcon;
    JButton cancelButton;
    JButton okButton;
    boolean okPressed = false;
    JPanel winPane = (JPanel)this.getContentPane();
    JPanel buttonPane = new JPanel();

    public AutoDialog(JFrame parent) {
        super((Frame)parent, true);
        this.createDialog();
    }

    public AutoDialog(JDialog d) {
        super((Dialog)d, true);
        this.createDialog();
    }

    private void createDialog() {
        this.rbundle = Statics.prg_Bundle;
        this.programIcon = Statics.splashScreen.getMultiResIcon("/images/ProgramIcon_100", 1.0f);
        this.okButton = new JButton(ResourceBundle.getBundle("de/didappslib/guitools/resources/AutoDialog").getString("OK"));
        this.cancelButton = new JButton(ResourceBundle.getBundle("de/didappslib/guitools/resources/AutoDialog").getString("Abbrechen"));
        Font hugeFont = new Font("Dialog", 1, 14);
        Font smallFont = new Font("Dialog", 0, 12);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.winPane.setLayout(gridbag);
        c.weightx = 1.0;
        c.gridheight = 3;
        c.anchor = 11;
        JLabel progIconLabel = new JLabel(this.programIcon);
        gridbag.setConstraints(progIconLabel, c);
        this.winPane.add(progIconLabel);
        c.anchor = 17;
        c.gridheight = 1;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.insets = new Insets(10, 15, 0, 10);
        this.typeLabel.setFont(hugeFont);
        gridbag.setConstraints(this.typeLabel, c);
        this.winPane.add(this.typeLabel);
        c.insets = new Insets(8, 15, 0, 10);
        this.textLabel.setFont(smallFont);
        this.textLabel.setOpaque(false);
        this.textLabel.setEditable(false);
        gridbag.setConstraints(this.textLabel, c);
        this.winPane.add(this.textLabel);
        KeyAdapter myKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    AutoDialog.this.dispose();
                }
            }
        };
        this.addKeyListener(myKeyListener);
        this.buttonPane.setLayout(new BoxLayout(this.buttonPane, 0));
        this.cancelButton.addKeyListener(myKeyListener);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoDialog.this.cancelButton_actionPerformed(e);
            }
        });
        this.buttonPane.add(this.cancelButton);
        this.buttonPane.add(Box.createRigidArea(new Dimension(15, 0)));
        this.okButton.addKeyListener(myKeyListener);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AutoDialog.this.okButton_actionPerformed(e);
            }
        });
        this.buttonPane.add(this.okButton);
        c.anchor = 13;
        c.insets = new Insets(30, 0, 0, 0);
        gridbag.setConstraints(this.buttonPane, c);
        this.winPane.add(this.buttonPane);
        this.winPane.setBorder(BorderFactory.createEmptyBorder(10, 20, 15, 20));
        this.winPane.getRootPane().setDefaultButton(this.okButton);
        this.setAlwaysOnTop(true);
        this.setResizable(false);
    }

    public void cancelButton_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void okButton_actionPerformed(ActionEvent e) {
        this.okPressed = true;
        this.dispose();
    }

    public boolean display(String type) {
        return this.display(type, "", ResourceBundle.getBundle("de/didappslib/guitools/resources/AutoDialog").getString("OK"), null);
    }

    public boolean display(String type, String text) {
        return this.display(type, text, ResourceBundle.getBundle("de/didappslib/guitools/resources/AutoDialog").getString("OK"), null);
    }

    public boolean display(String type, String text, String oktext) {
        return this.display(type, text, oktext, null);
    }

    public boolean display(String type, String text, String oktext, String canceltext) {
        Point p;
        this.typeLabel.setText(type);
        if (text != null) {
            this.textLabel.setText(text.replace("java.lang.Exception: ", ""));
        }
        if (oktext != null) {
            this.okButton.setText(oktext);
        }
        if (canceltext != null) {
            this.cancelButton.setText(canceltext);
        } else {
            this.buttonPane.remove(this.cancelButton);
        }
        this.okButton.setDefaultCapable(true);
        this.okButton.requestFocus();
        this.getRootPane().setDefaultButton(this.okButton);
        this.okPressed = false;
        this.pack();
        try {
            p = this.getParent().getLocationOnScreen();
            p.translate((this.getParent().getWidth() - this.getWidth()) / 2, (this.getParent().getHeight() - this.getHeight()) / 3);
        }
        catch (Exception ex) {
            Dimension sdim = Toolkit.getDefaultToolkit().getScreenSize();
            p = new Point(sdim.width / 2 - this.getWidth() / 2, (int)((double)sdim.height * 0.2));
        }
        this.setLocation(p);
        this.setVisible(true);
        return this.okPressed;
    }
}

