/*
 * Decompiled with CFR 0.152.
 */
package de.didappslib.guitools;

import de.didappslib.base.Document;
import de.didappslib.base.Koordinatensystem3D;
import de.didappslib.base.Statics;
import de.didappslib.guitools.GreekLetterConstPanel;
import de.didappslib.guitools.VariablesPopup;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class KSEinstellung3D
extends JFrame {
    private static final long serialVersionUID = 1L;
    private final Koordinatensystem3D ks;
    private final Document projekt;
    private final ResourceBundle rbundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/KSEinstellung", Statics.locale);
    private boolean rechtsAuftrTFWasActive;
    private boolean hochAuftrTFWasActive;
    private boolean achse3AuftrTFWasActive;
    private final PopupMenuListener rechtsAuftrTFPopupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KSEinstellung3D.this.rechtsAuftrTFWasActive = KSEinstellung3D.this.rechtsAuftrTF.hasFocus();
        }
    };
    private final PopupMenuListener hochAuftrTFPopupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KSEinstellung3D.this.hochAuftrTFWasActive = KSEinstellung3D.this.hochAuftrTF.hasFocus();
        }
    };
    private final PopupMenuListener achse3AuftrTFPopupMenuListener = new PopupMenuListener(){

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            KSEinstellung3D.this.achse3AuftrTFWasActive = KSEinstellung3D.this.achse3AuftrTF.hasFocus();
        }
    };
    private JTextField achse3AnfTF;
    private JTextField achse3AuftrTF;
    private JCheckBox achse3AutoCB;
    private JCheckBox achse3AutoEintCB;
    private JTextField achse3EintBrTF;
    private JTextField achse3EndTF;
    private JTextField achse3FeinTF;
    private JCheckBox achsenSichtbCB;
    private JTextField hAnfTF;
    private JCheckBox hAutoCB;
    private JCheckBox hAutoEintCB;
    private JTextField hEintBrTF;
    private JTextField hEndTF;
    private JTextField hFeinTF;
    private JTextField hochAuftrTF;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel17;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JTextField rAnfTF;
    private JCheckBox rAutoCB;
    private JCheckBox rAutoEintCB;
    private JTextField rEintBrTF;
    private JTextField rEndTF;
    private JTextField rFeinTF;
    private JTextField rechtsAuftrTF;

    public KSEinstellung3D(Koordinatensystem3D k, Document prj) {
        this.ks = k;
        this.projekt = prj;
        this.initComponents();
        this.rechtsAuftrTF.setFont(Statics.mathFont);
        this.rechtsAuftrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    KSEinstellung3D.this.rechtsAuftrTF.setText(KSEinstellung3D.this.rechtsAuftrTF.getText() + " ");
                    GreekLetterConstPanel.tfInputHook(KSEinstellung3D.this.rechtsAuftrTF);
                    KSEinstellung3D.this.rechtsAuftrTF.setText(KSEinstellung3D.this.rechtsAuftrTF.getText().trim());
                    KSEinstellung3D.this.ks.setAuftragungsStrings(KSEinstellung3D.this.rechtsAuftrTF.getText(), KSEinstellung3D.this.hochAuftrTF.getText(), KSEinstellung3D.this.achse3AuftrTF.getText());
                    KSEinstellung3D.this.hochAuftrTF.requestFocusInWindow();
                } else {
                    KSEinstellung3D.this.cbKeyPressed(evt);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.hochAuftrTF.setFont(Statics.mathFont);
        this.hochAuftrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    KSEinstellung3D.this.hochAuftrTF.setText(KSEinstellung3D.this.hochAuftrTF.getText() + " ");
                    GreekLetterConstPanel.tfInputHook(KSEinstellung3D.this.hochAuftrTF);
                    KSEinstellung3D.this.hochAuftrTF.setText(KSEinstellung3D.this.hochAuftrTF.getText().trim());
                    KSEinstellung3D.this.ks.setAuftragungsStrings(KSEinstellung3D.this.rechtsAuftrTF.getText(), KSEinstellung3D.this.hochAuftrTF.getText(), KSEinstellung3D.this.achse3AuftrTF.getText());
                    KSEinstellung3D.this.rechtsAuftrTF.requestFocusInWindow();
                } else {
                    KSEinstellung3D.this.cbKeyPressed(evt);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.achse3AuftrTF.setFont(Statics.mathFont);
        this.achse3AuftrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 10) {
                    KSEinstellung3D.this.achse3AuftrTF.setText(KSEinstellung3D.this.achse3AuftrTF.getText() + " ");
                    GreekLetterConstPanel.tfInputHook(KSEinstellung3D.this.hochAuftrTF);
                    KSEinstellung3D.this.achse3AuftrTF.setText(KSEinstellung3D.this.achse3AuftrTF.getText().trim());
                    KSEinstellung3D.this.ks.setAuftragungsStrings(KSEinstellung3D.this.rechtsAuftrTF.getText(), KSEinstellung3D.this.hochAuftrTF.getText(), KSEinstellung3D.this.achse3AuftrTF.getText());
                    KSEinstellung3D.this.achse3AuftrTF.requestFocusInWindow();
                } else {
                    KSEinstellung3D.this.cbKeyPressed(evt);
                }
            }

            @Override
            public void keyTyped(KeyEvent evt) {
            }
        });
        this.jLabel4.setVisible(false);
        this.jLabel6.setVisible(false);
        this.jLabel11.setVisible(false);
        this.jLabel12.setVisible(false);
        this.jLabel15.setVisible(false);
        this.jLabel17.setVisible(false);
        this.rEintBrTF.setVisible(false);
        this.hEintBrTF.setVisible(false);
        this.achse3EintBrTF.setVisible(false);
        this.rFeinTF.setVisible(false);
        this.hFeinTF.setVisible(false);
        this.achse3FeinTF.setVisible(false);
        this.rAutoEintCB.setVisible(false);
        this.hAutoEintCB.setVisible(false);
        this.achse3AutoEintCB.setVisible(false);
        this.achsenSichtbCB.setVisible(false);
        this.pack();
    }

    public void activate(int x, int y, int whichAxis) {
        this.updateFields();
        Rectangle r = this.projekt.getViewer().getWindow().getBounds();
        if (x < 0 && y < 0) {
            this.setLocation(r.x + r.width / 2 - this.getWidth() / 2, r.y + r.height / 2 * 3 / 5 - this.getHeight() / 2);
        } else {
            this.setLocation(x - this.getWidth() / 2, y - this.getHeight() / 2);
        }
        switch (whichAxis) {
            case 0: 
            case 1: {
                this.rechtsAuftrTF.requestFocus();
                break;
            }
            case 2: {
                this.hochAuftrTF.requestFocus();
                break;
            }
            case 3: {
                this.achse3AuftrTF.requestFocus();
            }
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.rechtsAuftrTF = new JTextField();
        this.jLabel2 = new JLabel();
        this.rAnfTF = new JTextField();
        this.jLabel3 = new JLabel();
        this.rEndTF = new JTextField();
        this.rAutoCB = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.rEintBrTF = new JTextField();
        this.rAutoEintCB = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.rFeinTF = new JTextField();
        this.jLabel9 = new JLabel();
        this.hochAuftrTF = new JTextField();
        this.jLabel8 = new JLabel();
        this.hAnfTF = new JTextField();
        this.jLabel10 = new JLabel();
        this.hEndTF = new JTextField();
        this.hAutoCB = new JCheckBox();
        this.jLabel11 = new JLabel();
        this.hEintBrTF = new JTextField();
        this.hAutoEintCB = new JCheckBox();
        this.jLabel12 = new JLabel();
        this.hFeinTF = new JTextField();
        this.jLabel13 = new JLabel();
        this.achse3AuftrTF = new JTextField();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.achse3AnfTF = new JTextField();
        this.achse3EndTF = new JTextField();
        this.achse3EintBrTF = new JTextField();
        this.achse3FeinTF = new JTextField();
        this.jLabel16 = new JLabel();
        this.jLabel17 = new JLabel();
        this.achse3AutoCB = new JCheckBox();
        this.achse3AutoEintCB = new JCheckBox();
        this.achsenSichtbCB = new JCheckBox();
        this.jPanel1 = new JPanel();
        ResourceBundle bundle = ResourceBundle.getBundle("de/didappslib/guitools/resources/KSEinstellung");
        this.setTitle(bundle.getString("Einstellungen_der_Koordinatenachsen"));
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.setType(Window.Type.UTILITY);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabel1.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel1.setText(this.rbundle.getString("Achse1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 2);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.rechtsAuftrTF.setColumns(8);
        this.rechtsAuftrTF.setToolTipText(bundle.getString("KSEinstellung3D.rechtsAuftrTF.toolTipText"));
        this.rechtsAuftrTF.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 6, 0, 0);
        this.getContentPane().add((Component)this.rechtsAuftrTF, gridBagConstraints);
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText(this.rbundle.getString("Anfang"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.rAnfTF.setColumns(4);
        this.rAnfTF.setToolTipText(bundle.getString("Start_TIP"));
        this.rAnfTF.setOpaque(true);
        this.rAnfTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.rAnfTFFocusLost(evt);
            }
        });
        this.rAnfTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rAnfTFActionPerformed(evt);
            }
        });
        this.rAnfTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.rAnfTF, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText(this.rbundle.getString("Ende"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.rEndTF.setColumns(4);
        this.rEndTF.setToolTipText(bundle.getString("End_TIP"));
        this.rEndTF.setOpaque(true);
        this.rEndTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.rEndTFFocusLost(evt);
            }
        });
        this.rEndTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rEndTFActionPerformed(evt);
            }
        });
        this.rEndTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 40;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.rEndTF, gridBagConstraints);
        this.rAutoCB.setText(this.rbundle.getString("auto"));
        this.rAutoCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.rAutoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rAutoCBActionPerformed(evt);
            }
        });
        this.rAutoCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 0, 17);
        this.getContentPane().add((Component)this.rAutoCB, gridBagConstraints);
        this.jLabel4.setHorizontalAlignment(4);
        this.jLabel4.setText(this.rbundle.getString("Division"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.rEintBrTF.setColumns(4);
        this.rEintBrTF.setToolTipText(bundle.getString("Division_TIP"));
        this.rEintBrTF.setOpaque(true);
        this.rEintBrTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.rEintBrTFFocusLost(evt);
            }
        });
        this.rEintBrTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rEintBrTFActionPerformed(evt);
            }
        });
        this.rEintBrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.rEintBrTF, gridBagConstraints);
        this.rAutoEintCB.setText(this.rbundle.getString("auto"));
        this.rAutoEintCB.setToolTipText(bundle.getString("autoDivision_TIP"));
        this.rAutoEintCB.setEnabled(false);
        this.rAutoEintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rAutoEintCBActionPerformed(evt);
            }
        });
        this.rAutoEintCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.getContentPane().add((Component)this.rAutoEintCB, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(4);
        this.jLabel6.setText(this.rbundle.getString("Feinteilung"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.rFeinTF.setColumns(4);
        this.rFeinTF.setToolTipText(bundle.getString("Subdivisions_TIP"));
        this.rFeinTF.setOpaque(true);
        this.rFeinTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.rFeinTFFocusLost(evt);
            }
        });
        this.rFeinTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.rFeinTFActionPerformed(evt);
            }
        });
        this.rFeinTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.rFeinTF, gridBagConstraints);
        this.jLabel9.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel9.setText(this.rbundle.getString("Achse2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(14, 10, 0, 2);
        this.getContentPane().add((Component)this.jLabel9, gridBagConstraints);
        this.hochAuftrTF.setColumns(8);
        this.hochAuftrTF.setToolTipText(bundle.getString("KSEinstellung3D.hochAuftrTF.toolTipText"));
        this.hochAuftrTF.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 6, 0, 0);
        this.getContentPane().add((Component)this.hochAuftrTF, gridBagConstraints);
        this.jLabel8.setHorizontalAlignment(4);
        this.jLabel8.setText(this.rbundle.getString("Anfang"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel8, gridBagConstraints);
        this.hAnfTF.setColumns(4);
        this.hAnfTF.setToolTipText(bundle.getString("Start_TIP"));
        this.hAnfTF.setOpaque(true);
        this.hAnfTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.hAnfTFFocusLost(evt);
            }
        });
        this.hAnfTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hAnfTFActionPerformed(evt);
            }
        });
        this.hAnfTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.hAnfTF, gridBagConstraints);
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setText(this.rbundle.getString("Ende"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel10, gridBagConstraints);
        this.hEndTF.setColumns(4);
        this.hEndTF.setToolTipText(bundle.getString("End_TIP"));
        this.hEndTF.setOpaque(true);
        this.hEndTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.hEndTFFocusLost(evt);
            }
        });
        this.hEndTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hEndTFActionPerformed(evt);
            }
        });
        this.hEndTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.hEndTF, gridBagConstraints);
        this.hAutoCB.setText(this.rbundle.getString("auto"));
        this.hAutoCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.hAutoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hAutoCBActionPerformed(evt);
            }
        });
        this.hAutoCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 0, 6);
        this.getContentPane().add((Component)this.hAutoCB, gridBagConstraints);
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setText(this.rbundle.getString("Division"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel11, gridBagConstraints);
        this.hEintBrTF.setColumns(4);
        this.hEintBrTF.setToolTipText(bundle.getString("Division_TIP"));
        this.hEintBrTF.setOpaque(true);
        this.hEintBrTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.hEintBrTFFocusLost(evt);
            }
        });
        this.hEintBrTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hEintBrTFActionPerformed(evt);
            }
        });
        this.hEintBrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.hEintBrTF, gridBagConstraints);
        this.hAutoEintCB.setText(this.rbundle.getString("auto"));
        this.hAutoEintCB.setToolTipText(bundle.getString("autoDivision_TIP"));
        this.hAutoEintCB.setEnabled(false);
        this.hAutoEintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hAutoEintCBActionPerformed(evt);
            }
        });
        this.hAutoEintCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.getContentPane().add((Component)this.hAutoEintCB, gridBagConstraints);
        this.jLabel12.setHorizontalAlignment(4);
        this.jLabel12.setText(this.rbundle.getString("Feinteilung"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel12, gridBagConstraints);
        this.hFeinTF.setColumns(4);
        this.hFeinTF.setToolTipText(bundle.getString("Subdivisions_TIP"));
        this.hFeinTF.setOpaque(true);
        this.hFeinTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.hFeinTFFocusLost(evt);
            }
        });
        this.hFeinTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.hFeinTFActionPerformed(evt);
            }
        });
        this.hFeinTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.hFeinTF, gridBagConstraints);
        this.jLabel13.setFont(new Font("Lucida Grande", 1, 13));
        this.jLabel13.setText(this.rbundle.getString("Achse3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(14, 10, 0, 2);
        this.getContentPane().add((Component)this.jLabel13, gridBagConstraints);
        this.achse3AuftrTF.setColumns(8);
        this.achse3AuftrTF.setToolTipText(bundle.getString("KSEinstellung3D.achse3AuftrTF.toolTipText"));
        this.achse3AuftrTF.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(14, 6, 0, 0);
        this.getContentPane().add((Component)this.achse3AuftrTF, gridBagConstraints);
        this.jLabel14.setHorizontalAlignment(4);
        this.jLabel14.setText(bundle.getString("Anfang"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel14, gridBagConstraints);
        this.jLabel15.setHorizontalAlignment(4);
        this.jLabel15.setText(bundle.getString("Division"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.getContentPane().add((Component)this.jLabel15, gridBagConstraints);
        this.achse3AnfTF.setColumns(4);
        this.achse3AnfTF.setToolTipText(bundle.getString("Start_TIP"));
        this.achse3AnfTF.setOpaque(true);
        this.achse3AnfTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.achse3AnfTFFocusLost(evt);
            }
        });
        this.achse3AnfTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3AnfTFActionPerformed(evt);
            }
        });
        this.achse3AnfTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.achse3AnfTF, gridBagConstraints);
        this.achse3EndTF.setColumns(4);
        this.achse3EndTF.setToolTipText(bundle.getString("End_TIP"));
        this.achse3EndTF.setOpaque(true);
        this.achse3EndTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.achse3EndTFFocusLost(evt);
            }
        });
        this.achse3EndTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3EndTFActionPerformed(evt);
            }
        });
        this.achse3EndTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 0);
        this.getContentPane().add((Component)this.achse3EndTF, gridBagConstraints);
        this.achse3EintBrTF.setColumns(4);
        this.achse3EintBrTF.setToolTipText(bundle.getString("Division_TIP"));
        this.achse3EintBrTF.setOpaque(true);
        this.achse3EintBrTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.achse3EintBrTFFocusLost(evt);
            }
        });
        this.achse3EintBrTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3EintBrTFActionPerformed(evt);
            }
        });
        this.achse3EintBrTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.getContentPane().add((Component)this.achse3EintBrTF, gridBagConstraints);
        this.achse3FeinTF.setColumns(4);
        this.achse3FeinTF.setToolTipText(bundle.getString("Subdivisions_TIP"));
        this.achse3FeinTF.setOpaque(true);
        this.achse3FeinTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                KSEinstellung3D.this.achse3FeinTFFocusLost(evt);
            }
        });
        this.achse3FeinTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3FeinTFActionPerformed(evt);
            }
        });
        this.achse3FeinTF.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 13, 0);
        this.getContentPane().add((Component)this.achse3FeinTF, gridBagConstraints);
        this.jLabel16.setHorizontalAlignment(4);
        this.jLabel16.setText(bundle.getString("Ende"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel16, gridBagConstraints);
        this.jLabel17.setHorizontalAlignment(4);
        this.jLabel17.setText(bundle.getString("Feinteilung"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(9, 10, 0, 0);
        this.getContentPane().add((Component)this.jLabel17, gridBagConstraints);
        this.achse3AutoCB.setText(bundle.getString("auto"));
        this.achse3AutoCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.achse3AutoCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3AutoCBActionPerformed(evt);
            }
        });
        this.achse3AutoCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 6, 0, 6);
        this.getContentPane().add((Component)this.achse3AutoCB, gridBagConstraints);
        this.achse3AutoEintCB.setText(bundle.getString("auto"));
        this.achse3AutoEintCB.setToolTipText(bundle.getString("autoCB_TIP"));
        this.achse3AutoEintCB.setEnabled(false);
        this.achse3AutoEintCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achse3AutoEintCBActionPerformed(evt);
            }
        });
        this.achse3AutoEintCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 6, 0, 6);
        this.getContentPane().add((Component)this.achse3AutoEintCB, gridBagConstraints);
        this.achsenSichtbCB.setText(bundle.getString("Axis_always_visible_at_automatic"));
        this.achsenSichtbCB.setToolTipText(bundle.getString("achseSichtbCB_TIP"));
        this.achsenSichtbCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                KSEinstellung3D.this.achsenSichtbCBActionPerformed(evt);
            }
        });
        this.achsenSichtbCB.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                KSEinstellung3D.this.cbKeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 18;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        this.getContentPane().add((Component)this.achsenSichtbCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 15;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 7;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void hAutoEintCBActionPerformed(ActionEvent evt) {
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAutoCBActionPerformed(ActionEvent evt) {
        this.ks.setSelectedXAnp(this.rAutoCB.isSelected());
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAutoEintCBActionPerformed(ActionEvent evt) {
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAutoCBActionPerformed(ActionEvent evt) {
        this.ks.setSelectedYAnp(this.hAutoCB.isSelected());
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAnfTFActionPerformed(ActionEvent evt) {
        this.ks.XMin = Statics.textFieldToDouble(this.rAnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEndTFActionPerformed(ActionEvent evt) {
        this.ks.XMax = Statics.textFieldToDouble(this.rEndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rAnfTFFocusLost(FocusEvent evt) {
        this.ks.XMin = Statics.textFieldToDouble(this.rAnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEndTFFocusLost(FocusEvent evt) {
        this.ks.XMax = Statics.textFieldToDouble(this.rEndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEintBrTFActionPerformed(ActionEvent evt) {
        this.ks.XBigTickDist = Statics.textFieldToDouble(this.rEintBrTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rEintBrTFFocusLost(FocusEvent evt) {
        this.ks.XBigTickDist = Statics.textFieldToDouble(this.rEintBrTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rFeinTFActionPerformed(ActionEvent evt) {
        this.ks.XSmallTicks = (int)Statics.textFieldToDouble(this.rFeinTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void rFeinTFFocusLost(FocusEvent evt) {
        this.ks.XSmallTicks = (int)Statics.textFieldToDouble(this.rFeinTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAnfTFActionPerformed(ActionEvent evt) {
        this.ks.YMin = Statics.textFieldToDouble(this.hAnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hAnfTFFocusLost(FocusEvent evt) {
        this.ks.YMin = Statics.textFieldToDouble(this.hAnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEndTFActionPerformed(ActionEvent evt) {
        this.ks.YMax = Statics.textFieldToDouble(this.hEndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEndTFFocusLost(FocusEvent evt) {
        this.ks.YMax = Statics.textFieldToDouble(this.hEndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEintBrTFActionPerformed(ActionEvent evt) {
        this.ks.YBigTickDist = Statics.textFieldToDouble(this.hEintBrTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hEintBrTFFocusLost(FocusEvent evt) {
        this.ks.YBigTickDist = Statics.textFieldToDouble(this.hEintBrTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hFeinTFActionPerformed(ActionEvent evt) {
        this.ks.YSmallTicks = (int)Statics.textFieldToDouble(this.hFeinTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void hFeinTFFocusLost(FocusEvent evt) {
        this.ks.YSmallTicks = (int)Statics.textFieldToDouble(this.hFeinTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void cbKeyPressed(KeyEvent evt) {
        if (evt.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && evt.getKeyChar() == 'w') {
            this.setVisible(false);
        }
    }

    private void achsenSichtbCBActionPerformed(ActionEvent evt) {
        this.ks.achseSichtbar = this.achsenSichtbCB.isSelected();
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3AnfTFFocusLost(FocusEvent evt) {
        this.ks.ZMin = Statics.textFieldToDouble(this.achse3AnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3AnfTFActionPerformed(ActionEvent evt) {
        this.ks.ZMin = Statics.textFieldToDouble(this.achse3AnfTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3EintBrTFFocusLost(FocusEvent evt) {
        this.ks.ZBigTickDist = Statics.textFieldToDouble(this.achse3EintBrTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3EintBrTFActionPerformed(ActionEvent evt) {
        this.ks.ZBigTickDist = Statics.textFieldToDouble(this.achse3EintBrTF, false);
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3EndTFFocusLost(FocusEvent evt) {
        this.ks.ZMax = Statics.textFieldToDouble(this.achse3EndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3EndTFActionPerformed(ActionEvent evt) {
        this.ks.ZMax = Statics.textFieldToDouble(this.achse3EndTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3FeinTFFocusLost(FocusEvent evt) {
        this.ks.ZSmallTicks = (int)Statics.textFieldToDouble(this.achse3FeinTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3FeinTFActionPerformed(ActionEvent evt) {
        this.ks.ZSmallTicks = (int)Statics.textFieldToDouble(this.achse3FeinTF, false);
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3AutoCBActionPerformed(ActionEvent evt) {
        this.ks.setSelectedZAnp(this.achse3AutoCB.isSelected());
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    private void achse3AutoEintCBActionPerformed(ActionEvent evt) {
        this.ks.generateAllPlotArrays();
        this.ks.zeichneAlles();
        this.updateFields();
    }

    public final void updateFields() {
        if (this.ks == null) {
            return;
        }
        UIManager.put("MenuItem.font", Statics.mathFont);
        VariablesPopup varPopup = new VariablesPopup(this.projekt.getModel(), e -> {
            if (this.rechtsAuftrTF.getSelectedText() != null) {
                this.rechtsAuftrTF.replaceSelection(e.getActionCommand());
            } else if (this.rechtsAuftrTFWasActive) {
                this.rechtsAuftrTF.replaceSelection(e.getActionCommand());
            } else {
                this.rechtsAuftrTF.setText(e.getActionCommand());
            }
            this.requestFocus();
            this.ks.setAuftragungsStrings(this.rechtsAuftrTF.getText(), this.hochAuftrTF.getText(), this.achse3AuftrTF.getText());
        });
        varPopup.addPopupMenuListener(this.rechtsAuftrTFPopupMenuListener);
        this.rechtsAuftrTF.setComponentPopupMenu(varPopup);
        this.rechtsAuftrTF.setText(this.ks.varXStr);
        this.rAnfTF.setText(Statics.doubleToString(this.ks.XMin));
        this.rEndTF.setText(Statics.doubleToString(this.ks.XMax));
        this.rAnfTF.setEnabled(!this.ks.achse1Anp);
        this.rEndTF.setEnabled(!this.ks.achse1Anp);
        this.rAutoCB.setSelected(this.ks.achse1Anp);
        this.rEintBrTF.setText(Statics.doubleToString(this.ks.XBigTickDist));
        this.rEintBrTF.setEnabled(!this.ks.autoGitterX);
        this.rFeinTF.setText(Statics.doubleToString(this.ks.XSmallTicks));
        if (this.ks.XSmallTicks <= 1) {
            this.rFeinTF.setText("1");
        }
        this.rFeinTF.setEnabled(!this.ks.autoGitterX);
        this.rAutoEintCB.setSelected(this.ks.autoGitterX);
        varPopup = new VariablesPopup(this.projekt.getModel(), e -> {
            if (this.hochAuftrTF.getSelectedText() != null) {
                this.hochAuftrTF.replaceSelection(e.getActionCommand());
            } else if (this.hochAuftrTFWasActive) {
                this.hochAuftrTF.replaceSelection(e.getActionCommand());
            } else {
                this.hochAuftrTF.setText(e.getActionCommand());
            }
            this.requestFocus();
            this.ks.setAuftragungsStrings(this.rechtsAuftrTF.getText(), this.hochAuftrTF.getText(), this.achse3AuftrTF.getText());
        });
        varPopup.addPopupMenuListener(this.hochAuftrTFPopupMenuListener);
        this.hochAuftrTF.setComponentPopupMenu(varPopup);
        this.hochAuftrTF.setText(this.ks.varYStr);
        this.hAnfTF.setText(Statics.doubleToString(this.ks.YMin));
        this.hEndTF.setText(Statics.doubleToString(this.ks.YMax));
        this.hAnfTF.setEnabled(!this.ks.achse2Anp);
        this.hEndTF.setEnabled(!this.ks.achse2Anp);
        this.hAutoCB.setSelected(this.ks.achse2Anp);
        this.hEintBrTF.setText(Statics.doubleToString(this.ks.YBigTickDist));
        this.hEintBrTF.setEnabled(!this.ks.autoGitterY);
        this.hFeinTF.setText(Statics.doubleToString(this.ks.YSmallTicks));
        if (this.ks.YSmallTicks <= 1) {
            this.hFeinTF.setText("1");
        }
        this.hFeinTF.setEnabled(!this.ks.autoGitterY);
        this.hAutoEintCB.setSelected(this.ks.autoGitterY);
        varPopup = new VariablesPopup(this.projekt.getModel(), e -> {
            if (this.achse3AuftrTF.getSelectedText() != null) {
                this.achse3AuftrTF.replaceSelection(e.getActionCommand());
            } else if (this.achse3AuftrTFWasActive) {
                this.achse3AuftrTF.replaceSelection(e.getActionCommand());
            } else {
                this.achse3AuftrTF.setText(e.getActionCommand());
            }
            this.requestFocus();
            this.ks.setAuftragungsStrings(this.rechtsAuftrTF.getText(), this.hochAuftrTF.getText(), this.achse3AuftrTF.getText());
        });
        varPopup.addPopupMenuListener(this.achse3AuftrTFPopupMenuListener);
        this.achse3AuftrTF.setComponentPopupMenu(varPopup);
        this.achse3AuftrTF.setText(this.ks.varZStr);
        this.achse3AnfTF.setText(Statics.doubleToString(this.ks.ZMin));
        this.achse3EndTF.setText(Statics.doubleToString(this.ks.ZMax));
        this.achse3AnfTF.setEnabled(!this.ks.achse3Anp);
        this.achse3EndTF.setEnabled(!this.ks.achse3Anp);
        this.achse3AutoCB.setSelected(this.ks.achse3Anp);
        this.achse3EintBrTF.setText(Statics.doubleToString(this.ks.ZBigTickDist));
        this.achse3EintBrTF.setEnabled(!this.ks.autoGitterZ);
        this.achse3FeinTF.setText(Statics.doubleToString(this.ks.ZSmallTicks));
        if (this.ks.ZSmallTicks <= 1) {
            this.achse3FeinTF.setText("1");
        }
        this.achse3FeinTF.setEnabled(!this.ks.autoGitterZ);
        this.achse3AutoEintCB.setSelected(this.ks.autoGitterZ);
        if (this.ks.whatToDo == 6) {
            this.hochAuftrTF.requestFocus();
        } else {
            this.rechtsAuftrTF.requestFocus();
        }
        UIManager.put("MenuItem.font", null);
    }

    class BlockComboListener
    implements ActionListener {
        JComboBox combo;
        Object currentItem;

        BlockComboListener(JComboBox combo) {
            this.combo = combo;
            combo.setSelectedIndex(0);
            this.currentItem = combo.getSelectedItem();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String tempItem = (String)this.combo.getSelectedItem();
            if ("SEPARATOR".equals(tempItem)) {
                this.combo.setSelectedItem(this.currentItem);
            } else {
                this.currentItem = tempItem;
            }
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        JSeparator separator;

        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
            this.separator = new JSeparator(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            String string = str = value == null ? "" : value.toString();
            if ("SEPARATOR".equals(str)) {
                return this.separator;
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(str);
            return this;
        }
    }
}

